/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionNotInitializedException;
import com.liferay.portal.search.elasticsearch6.internal.connection.MissingOperationModeException;
import com.liferay.portal.search.elasticsearch6.internal.connection.OperationMode;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, service={ElasticsearchConnectionManager.class})
public class ElasticsearchConnectionManager {
    @Reference(unbind="-")
    protected IndexFactory indexFactory;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchConnectionManager.class);
    private final Map<Long, Long> _companyIds = new HashMap<Long, Long>();
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;
    private final Map<OperationMode, ElasticsearchConnection> _elasticsearchConnections = new HashMap<OperationMode, ElasticsearchConnection>();
    private OperationMode _operationMode;

    public void connect() {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection();
        elasticsearchConnection.connect();
    }

    public AdminClient getAdminClient() {
        Client client = this.getClient();
        return client.admin();
    }

    public Client getClient() {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection();
        if (elasticsearchConnection == null) {
            throw new ElasticsearchConnectionNotInitializedException();
        }
        return elasticsearchConnection.getClient();
    }

    public ClusterAdminClient getClusterAdminClient() {
        AdminClient adminClient = this.getAdminClient();
        return adminClient.cluster();
    }

    public ClusterHealthResponse getClusterHealthResponse(long timeout) {
        ElasticsearchConnection elasticsearchConnection = this.getElasticsearchConnection();
        return elasticsearchConnection.getClusterHealthResponse(timeout);
    }

    public ElasticsearchConnection getElasticsearchConnection() {
        return this._elasticsearchConnections.get((Object)this._operationMode);
    }

    public synchronized void registerCompanyId(long companyId) {
        this._companyIds.put(companyId, companyId);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(operation.mode=EMBEDDED)", unbind="unsetElasticsearchConnection")
    public void setEmbeddedElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.put(elasticsearchConnection.getOperationMode(), elasticsearchConnection);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(operation.mode=REMOTE)", unbind="unsetElasticsearchConnection")
    public void setRemoteElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.put(elasticsearchConnection.getOperationMode(), elasticsearchConnection);
    }

    public synchronized void unregisterCompanyId(long companyId) {
        this._companyIds.remove(companyId);
    }

    public void unsetElasticsearchConnection(ElasticsearchConnection elasticsearchConnection) {
        this._elasticsearchConnections.remove((Object)elasticsearchConnection.getOperationMode());
        elasticsearchConnection.close();
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.activate(this.translate(this._elasticsearchConfiguration.operationMode()));
    }

    protected void activate(OperationMode operationMode) {
        this.validate(operationMode);
        this._operationMode = operationMode;
    }

    @Modified
    protected synchronized void modified(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this.modify(this.translate(this._elasticsearchConfiguration.operationMode()));
    }

    protected synchronized void modify(OperationMode operationMode) {
        if (Objects.equals((Object)operationMode, (Object)this._operationMode)) {
            return;
        }
        this.validate(operationMode);
        ElasticsearchConnection newElasticsearchConnection = this._elasticsearchConnections.get((Object)operationMode);
        newElasticsearchConnection.connect();
        if (this._operationMode != null) {
            ElasticsearchConnection oldElasticsearchConnection = this._elasticsearchConnections.get((Object)this._operationMode);
            try {
                oldElasticsearchConnection.close();
            }
            catch (Exception e) {
                _log.error((Object)("Unable to close " + oldElasticsearchConnection), (Throwable)e);
            }
        }
        this._operationMode = operationMode;
        for (Long companyId : this._companyIds.values()) {
            try {
                this.indexFactory.createIndices(this.getAdminClient(), companyId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to reinitialize index for company " + companyId), (Throwable)e);
            }
        }
    }

    protected OperationMode translate(com.liferay.portal.search.elasticsearch6.configuration.OperationMode operationMode) {
        return OperationMode.valueOf(operationMode.name());
    }

    protected void validate(OperationMode operationMode) {
        if (!this._elasticsearchConnections.containsKey((Object)operationMode)) {
            throw new MissingOperationModeException(operationMode);
        }
    }
}

