/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.ElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch6.internal.document.ElasticsearchUpdateDocumentCommand;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ElasticsearchUpdateDocumentCommand.class})
public class ElasticsearchUpdateDocumentCommandImpl
implements ElasticsearchUpdateDocumentCommand {
    @Reference(unbind="-")
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference(unbind="-")
    protected ElasticsearchDocumentFactory elasticsearchDocumentFactory;
    @Reference(unbind="-")
    protected IndexNameBuilder indexNameBuilder;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchUpdateDocumentCommandImpl.class);
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;

    @Override
    public String updateDocument(String documentType, SearchContext searchContext, Document document, boolean deleteFirst) throws SearchException {
        BulkItemResponse[] bulkItemResponses;
        BulkResponse bulkResponse = this.doUpdateDocuments(documentType, searchContext, Arrays.asList(document), deleteFirst);
        if (bulkResponse.hasFailures()) {
            Exception throwable = null;
            for (BulkItemResponse bulkItemResponse : bulkResponse) {
                if (!bulkItemResponse.isFailed()) continue;
                BulkItemResponse.Failure failure = bulkItemResponse.getFailure();
                if (throwable == null) {
                    throwable = failure.getCause();
                    continue;
                }
                throwable.addSuppressed(failure.getCause());
            }
            throw new SearchException(bulkResponse.buildFailureMessage(), throwable);
        }
        for (BulkItemResponse bulkItemResponse : bulkItemResponses = bulkResponse.getItems()) {
            DocWriteResponse actionResponse = bulkItemResponse.getResponse();
            if (!(actionResponse instanceof UpdateResponse)) continue;
            UpdateResponse updateResponse = (UpdateResponse)actionResponse;
            return updateResponse.getId();
        }
        return "";
    }

    @Override
    public void updateDocuments(String documentType, SearchContext searchContext, Collection<Document> documents, boolean deleteFirst) throws SearchException {
        try {
            this.doUpdateDocuments(documentType, searchContext, documents, deleteFirst);
        }
        catch (Exception e) {
            throw new SearchException("Unable to update documents " + documents, (Throwable)e);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
    }

    protected UpdateRequestBuilder buildUpdateRequestBuilder(String documentType, SearchContext searchContext, Document document) throws IOException {
        Client client = this.elasticsearchConnectionManager.getClient();
        UpdateRequestBuilder updateRequestBuilder = client.prepareUpdate(this.indexNameBuilder.getIndexName(searchContext.getCompanyId()), documentType, document.getUID());
        String elasticSearchDocument = this.elasticsearchDocumentFactory.getElasticsearchDocument(document);
        updateRequestBuilder.setDoc(elasticSearchDocument, XContentType.JSON);
        updateRequestBuilder.setDocAsUpsert(true);
        updateRequestBuilder.setRetryOnConflict(this._elasticsearchConfiguration.retryOnConflict());
        document.get("modified");
        return updateRequestBuilder;
    }

    protected BulkResponse doUpdateDocuments(String documentType, SearchContext searchContext, Collection<Document> documents, boolean deleteFirst) throws SearchException {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
            for (Document document : documents) {
                if (deleteFirst) {
                    DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete(this.indexNameBuilder.getIndexName(searchContext.getCompanyId()), "LiferayDocumentType", document.getUID());
                    bulkRequestBuilder.add(deleteRequestBuilder);
                }
                UpdateRequestBuilder updateRequestBuilder = this.buildUpdateRequestBuilder(documentType, searchContext, document);
                bulkRequestBuilder.add(updateRequestBuilder);
            }
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.get();
            LogUtil.logActionResponse(_log, bulkResponse);
            return bulkResponse;
        }
        catch (Exception e) {
            throw new SearchException("Unable to update documents " + documents, (Throwable)e);
        }
    }
}

