/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.search.elasticsearch6.internal.DeleteDocumentsSearchHitsProcessor;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitsProcessor;
import com.liferay.portal.search.elasticsearch6.internal.SearchResponseScroller;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.ElasticsearchUpdateDocumentCommand;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.suggest.BaseGenericSpellCheckIndexWriter;
import java.util.Collection;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={SpellCheckIndexWriter.class})
public class ElasticsearchSpellCheckIndexWriter
extends BaseGenericSpellCheckIndexWriter {
    @Reference(unbind="-")
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference(unbind="-")
    protected ElasticsearchUpdateDocumentCommand elasticsearchUpdateDocumentCommand;
    @Reference(unbind="-")
    protected IndexNameBuilder indexNameBuilder;
    protected Localization localization;
    private volatile SearchHitsProcessor _searchHitsProcessor;

    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        try {
            this.deleteDocuments(searchContext, "querySuggestion");
        }
        catch (Exception e) {
            throw new SearchException("Unable to clear query suggestions", (Throwable)e);
        }
    }

    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        try {
            this.deleteDocuments(searchContext, "spellChecker");
        }
        catch (Exception e) {
            throw new SearchException("Unable to to clear spell checks", (Throwable)e);
        }
    }

    protected void addDocument(String documentType, SearchContext searchContext, Document document) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocument("LiferayDocumentType", searchContext, document, false);
    }

    protected void addDocuments(String documentType, SearchContext searchContext, Collection<Document> documents) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocuments("LiferayDocumentType", searchContext, documents, false);
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String keywords, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) {
        Document document = this.createDocument();
        Localization localization = this.getLocalization();
        String localizedName = localization.getLocalizedName(keywordFieldName, languageId);
        document.addKeyword(localizedName, keywords);
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("languageId", languageId);
        document.addKeyword("priority", String.valueOf(weight));
        document.addKeyword("type", typeFieldValue);
        document.addKeyword("uid", this.getUID(companyId, keywordFieldName, languageId, keywords, new String[0]));
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDocuments(SearchContext searchContext, String typeFieldValue) throws Exception {
        if (this._searchHitsProcessor == null) {
            throw new IllegalStateException("Module not properly initialized");
        }
        try (SearchResponseScroller searchResponseScroller = null;){
            Client client = this.elasticsearchConnectionManager.getClient();
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)"type", (Object)typeFieldValue);
            searchResponseScroller = new SearchResponseScroller(client, searchContext, this.indexNameBuilder, (QueryBuilder)matchQueryBuilder, TimeValue.timeValueSeconds((long)30L), "LiferayDocumentType");
            searchResponseScroller.prepare();
            searchResponseScroller.scroll(this._searchHitsProcessor);
        }
    }

    protected Localization getLocalization() {
        if (this.localization != null) {
            return this.localization;
        }
        return LocalizationUtil.getLocalization();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(!(search.engine.impl=*))")
    protected void setIndexWriter(IndexWriter indexWriter) {
        this._searchHitsProcessor = new DeleteDocumentsSearchHitsProcessor(indexWriter);
    }

    protected void unsetIndexWriter(IndexWriter indexWriter) {
        this._searchHitsProcessor = null;
    }
}

