/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.AggregateSuggester;
import com.liferay.portal.kernel.search.suggest.PhraseSuggester;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.search.suggest.Suggester;
import com.liferay.portal.kernel.search.suggest.SuggesterResult;
import com.liferay.portal.kernel.search.suggest.SuggesterResults;
import com.liferay.portal.kernel.search.suggest.SuggesterTranslator;
import com.liferay.portal.kernel.search.suggest.TermSuggester;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={QuerySuggester.class})
public class ElasticsearchQuerySuggester
implements QuerySuggester {
    @Reference(unbind="-")
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference(unbind="-")
    protected IndexNameBuilder indexNameBuilder;
    protected Localization localization;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected SuggesterTranslator<SuggestBuilder> suggesterTranslator;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchQuerySuggester.class);

    public String spellCheckKeywords(SearchContext searchContext) throws SearchException {
        Suggester suggester = this.createSpellCheckSuggester(searchContext, 1);
        Suggest suggest = this.doSuggest(suggester, searchContext);
        if (suggest == null) {
            return "";
        }
        ArrayList<String> words = new ArrayList<String>();
        for (Suggest.Suggestion suggestion : suggest) {
            for (Suggest.Suggestion.Entry suggestionEntry : suggestion) {
                Text text = this.getWord((Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>)suggestionEntry);
                words.add(text.string());
            }
        }
        return StringUtil.merge(words, (String)" ");
    }

    public Map<String, List<String>> spellCheckKeywords(SearchContext searchContext, int max) {
        Suggester suggester = this.createSpellCheckSuggester(searchContext, max);
        Suggest suggest = this.doSuggest(suggester, searchContext);
        if (suggest == null) {
            return new LinkedHashMap<String, List<String>>();
        }
        LinkedHashMap<String, List<String>> suggestionsMap = new LinkedHashMap<String, List<String>>();
        for (Suggest.Suggestion suggestion : suggest) {
            for (Suggest.Suggestion.Entry suggestionEntry : suggestion) {
                ArrayList<String> suggestionsList = new ArrayList<String>();
                for (Suggest.Suggestion.Entry.Option suggestionEntryOption : suggestionEntry.getOptions()) {
                    Text optionText = suggestionEntryOption.getText();
                    suggestionsList.add(optionText.string());
                }
                Text text = suggestionEntry.getText();
                suggestionsMap.put(text.string(), suggestionsList);
            }
        }
        return suggestionsMap;
    }

    public SuggesterResults suggest(SearchContext searchContext, Suggester suggester) {
        Suggest suggest = this.doSuggest(suggester, searchContext);
        if (suggest == null) {
            return new SuggesterResults();
        }
        SuggesterResults suggesterResults = new SuggesterResults();
        for (Suggest.Suggestion suggestion : suggest) {
            suggesterResults.addSuggesterResult(this.translate((Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>)suggestion));
        }
        return suggesterResults;
    }

    public String[] suggestKeywordQueries(SearchContext searchContext, int max) {
        PhraseSuggester suggester = this.createQuerySuggester(searchContext, max);
        Suggest suggest = this.doSuggest((Suggester)suggester, searchContext);
        if (suggest == null) {
            return StringPool.EMPTY_ARRAY;
        }
        Suggest.Suggestion suggestion = suggest.getSuggestion(suggester.getName());
        if (suggestion == null) {
            return StringPool.EMPTY_ARRAY;
        }
        ArrayList<String> keywordQueries = new ArrayList<String>();
        for (Suggest.Suggestion.Entry suggestionEntry : suggestion) {
            for (Suggest.Suggestion.Entry.Option suggestionEntryOption : suggestionEntry.getOptions()) {
                Text optionText = suggestionEntryOption.getText();
                keywordQueries.add(optionText.string());
            }
        }
        return keywordQueries.toArray(new String[keywordQueries.size()]);
    }

    protected PhraseSuggester createQuerySuggester(SearchContext searchContext, int max) {
        Localization localization = this.getLocalization();
        String field = localization.getLocalizedName("keywordSearch", searchContext.getLanguageId());
        PhraseSuggester phraseSuggester = new PhraseSuggester("keywordQueryRequest", field, searchContext.getKeywords());
        phraseSuggester.setSize(Integer.valueOf(max));
        return phraseSuggester;
    }

    protected Suggester createSpellCheckSuggester(SearchContext searchContext, int max) {
        Localization localization = this.getLocalization();
        String field = localization.getLocalizedName("spellCheckWord", searchContext.getLanguageId());
        TermSuggester termSuggester = new TermSuggester("spellCheckRequest", field, searchContext.getKeywords());
        termSuggester.setSize(Integer.valueOf(max));
        return termSuggester;
    }

    protected Suggest doSuggest(Suggester suggester, SearchContext searchContext) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Client client = this.elasticsearchConnectionManager.getClient();
        SuggestBuilder suggestBuilder = (SuggestBuilder)this.suggesterTranslator.translate(suggester, searchContext);
        if (suggester instanceof AggregateSuggester) {
            AggregateSuggester aggregateSuggester = (AggregateSuggester)suggester;
            suggestBuilder.setGlobalText(aggregateSuggester.getValue());
        }
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(new String[]{this.indexNameBuilder.getIndexName(searchContext.getCompanyId())});
        Map suggestionBuilders = suggestBuilder.getSuggestions();
        for (Map.Entry entry : suggestionBuilders.entrySet()) {
            SuggestBuilder suggestBuilder2 = new SuggestBuilder();
            searchRequestBuilder.suggest(suggestBuilder2.addSuggestion((String)entry.getKey(), (SuggestionBuilder)entry.getValue()));
        }
        SearchResponse suggestResponse = this.getSuggestResponse(searchRequestBuilder);
        if (suggestResponse == null) {
            return null;
        }
        Suggest suggest = suggestResponse.getSuggest();
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)("Spell checked keywords in " + stopWatch.getTime() + "ms"));
        }
        return suggest;
    }

    protected Localization getLocalization() {
        if (this.localization != null) {
            return this.localization;
        }
        return LocalizationUtil.getLocalization();
    }

    protected SearchResponse getSuggestResponse(SearchRequestBuilder searchRequestBuilder) {
        try {
            return (SearchResponse)searchRequestBuilder.get();
        }
        catch (SearchPhaseExecutionException spee) {
            ElasticsearchException ee = spee.guessRootCauses()[0];
            String message = ee.getMessage();
            if (message.startsWith("no mapping found for field")) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"No dictionary indexed", (Throwable)ee);
                }
                return null;
            }
            throw spee;
        }
    }

    protected Text getWord(Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option> suggestionEntry) {
        List suggestionEntryOptions = suggestionEntry.getOptions();
        if (suggestionEntryOptions.isEmpty()) {
            return suggestionEntry.getText();
        }
        Suggest.Suggestion.Entry.Option suggestionEntryOption = (Suggest.Suggestion.Entry.Option)suggestionEntryOptions.get(0);
        return suggestionEntryOption.getText();
    }

    protected SuggesterResult translate(Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> suggestion) {
        SuggesterResult suggesterResult = new SuggesterResult(suggestion.getName());
        for (Suggest.Suggestion.Entry suggestionEntry : suggestion) {
            SuggesterResult.Entry suggesterResultEntry = this.translate((Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>)suggestionEntry);
            suggesterResult.addEntry(suggesterResultEntry);
        }
        return suggesterResult;
    }

    protected SuggesterResult.Entry.Option translate(Suggest.Suggestion.Entry.Option suggestionEntryOption) {
        Text text = suggestionEntryOption.getText();
        SuggesterResult.Entry.Option suggesterResultEntryOption = new SuggesterResult.Entry.Option(text.string(), suggestionEntryOption.getScore());
        if (suggestionEntryOption.getHighlighted() != null) {
            Text highlightedText = suggestionEntryOption.getHighlighted();
            suggesterResultEntryOption.setHighlightedText(highlightedText.string());
        }
        if (suggestionEntryOption instanceof TermSuggestion.Entry.Option) {
            TermSuggestion.Entry.Option termSuggestionEntryOption = (TermSuggestion.Entry.Option)suggestionEntryOption;
            suggesterResultEntryOption.setFrequency(Integer.valueOf(termSuggestionEntryOption.getFreq()));
        }
        return suggesterResultEntryOption;
    }

    protected SuggesterResult.Entry translate(Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option> suggestionEntry) {
        Text text = suggestionEntry.getText();
        SuggesterResult.Entry suggesterResultEntry = new SuggesterResult.Entry(text.string());
        List suggestionEntryOptions = suggestionEntry.getOptions();
        for (Suggest.Suggestion.Entry.Option suggestionEntryOption : suggestionEntryOptions) {
            SuggesterResult.Entry.Option suggesterResultEntryOption = this.translate(suggestionEntryOption);
            suggesterResultEntry.addOption(suggesterResultEntryOption);
        }
        return suggesterResultEntry;
    }
}

