/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexWriter;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.elasticsearch6.internal.DeleteDocumentsSearchHitsProcessor;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitsProcessor;
import com.liferay.portal.search.elasticsearch6.internal.SearchResponseScroller;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.ElasticsearchUpdateDocumentCommand;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import java.util.Collection;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={IndexWriter.class})
public class ElasticsearchIndexWriter
extends BaseIndexWriter {
    @Reference(unbind="-")
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference(unbind="-")
    protected ElasticsearchUpdateDocumentCommand elasticsearchUpdateDocumentCommand;
    @Reference(unbind="-")
    protected IndexNameBuilder indexNameBuilder;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexWriter.class);
    private final SearchHitsProcessor _searchHitsProcessor = new DeleteDocumentsSearchHitsProcessor((IndexWriter)this);

    public void addDocument(SearchContext searchContext, Document document) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocument("LiferayDocumentType", searchContext, document, false);
    }

    public void addDocuments(SearchContext searchContext, Collection<Document> documents) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocuments("LiferayDocumentType", searchContext, documents, false);
    }

    public void commit(SearchContext searchContext) throws SearchException {
        try {
            AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
            IndicesAdminClient indicesAdminClient = adminClient.indices();
            RefreshRequestBuilder refreshRequestBuilder = indicesAdminClient.prepareRefresh(new String[]{this.indexNameBuilder.getIndexName(searchContext.getCompanyId())});
            RefreshResponse refreshResponse = (RefreshResponse)refreshRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)refreshResponse);
        }
        catch (Exception e) {
            throw new SearchException("Unable to commit indices", (Throwable)e);
        }
    }

    public void deleteDocument(SearchContext searchContext, String uid) throws SearchException {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete(indexName, "LiferayDocumentType", uid);
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            DeleteResponse deleteResponse = (DeleteResponse)deleteRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)deleteResponse);
        }
        catch (IndexNotFoundException infe) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"No index found while attempting to delete ", uid, " in index ", indexName}));
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to delete document " + uid, (Throwable)e);
        }
    }

    public void deleteDocuments(SearchContext searchContext, Collection<String> uids) throws SearchException {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            BulkRequestBuilder bulkRequestBuilder = client.prepareBulk();
            for (String uid : uids) {
                DeleteRequestBuilder deleteRequestBuilder = client.prepareDelete(this.indexNameBuilder.getIndexName(searchContext.getCompanyId()), "LiferayDocumentType", uid);
                bulkRequestBuilder.add(deleteRequestBuilder);
            }
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            BulkResponse bulkResponse = (BulkResponse)bulkRequestBuilder.get();
            LogUtil.logActionResponse(_log, bulkResponse);
        }
        catch (Exception e) {
            throw new SearchException("Unable to delete documents " + uids, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntityDocuments(SearchContext searchContext, String className) throws SearchException {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            MatchAllQueryBuilder matchAllQueryBuilder = QueryBuilders.matchAllQuery();
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery((String)"entryClassName", (String)className);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter((QueryBuilder)termQueryBuilder);
            boolQueryBuilder.must((QueryBuilder)matchAllQueryBuilder);
            try (SearchResponseScroller searchResponseScroller = new SearchResponseScroller(client, searchContext, this.indexNameBuilder, (QueryBuilder)boolQueryBuilder, TimeValue.timeValueSeconds((long)30L), "LiferayDocumentType");){
                searchResponseScroller.prepare();
                searchResponseScroller.scroll(this._searchHitsProcessor);
            }
        }
        catch (IndexNotFoundException infe) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"No index found while attempting to delete documents ", "for ", className, " in index ", this.indexNameBuilder.getIndexName(searchContext.getCompanyId())}));
            }
        }
        catch (Exception e) {
            throw new SearchException("Unable to delete data for entity " + className, (Throwable)e);
        }
    }

    public void partiallyUpdateDocument(SearchContext searchContext, Document document) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocument("LiferayDocumentType", searchContext, document, false);
    }

    public void partiallyUpdateDocuments(SearchContext searchContext, Collection<Document> documents) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocuments("LiferayDocumentType", searchContext, documents, false);
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setSpellCheckIndexWriter(SpellCheckIndexWriter spellCheckIndexWriter) {
        super.setSpellCheckIndexWriter(spellCheckIndexWriter);
    }

    public void updateDocument(SearchContext searchContext, Document document) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocument("LiferayDocumentType", searchContext, document, true);
    }

    public void updateDocuments(SearchContext searchContext, Collection<Document> documents) throws SearchException {
        this.elasticsearchUpdateDocumentCommand.updateDocuments("LiferayDocumentType", searchContext, documents, true);
    }
}

