/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.helper;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.search.ccr.CrossClusterReplicationConfigurationHelper;
import com.liferay.portal.search.ccr.CrossClusterReplicationHelper;
import com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.CrossClusterReplicationConfiguration;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.ccr.CCRRequest;
import com.liferay.portal.search.engine.adapter.ccr.FollowInfoCCRRequest;
import com.liferay.portal.search.engine.adapter.ccr.FollowInfoCCRResponse;
import com.liferay.portal.search.engine.adapter.ccr.FollowInfoStatus;
import com.liferay.portal.search.engine.adapter.ccr.PauseFollowCCRRequest;
import com.liferay.portal.search.engine.adapter.ccr.PutFollowCCRRequest;
import com.liferay.portal.search.engine.adapter.ccr.UnfollowCCRRequest;
import com.liferay.portal.search.engine.adapter.cluster.ClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.UpdateSettingsClusterRequest;
import com.liferay.portal.search.engine.adapter.index.CloseIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.CrossClusterReplicationConfiguration"}, enabled=false, service={CrossClusterReplicationHelper.class})
public class CrossClusterReplicationHelperImpl
implements CrossClusterReplicationHelper {
    @Reference
    protected CrossClusterReplicationConfigurationHelper crossClusterReplicationConfigurationHelper;
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Log _log = LogFactoryUtil.getLog(CrossClusterReplicationHelperImpl.class);
    private volatile CrossClusterReplicationConfiguration _crossClusterReplicationConfiguration;

    public void addRemoteCluster(String remoteClusterAlias, String remoteClusterSeedNodeTransportAddress, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Adding remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}));
        }
        try {
            this._updateSettings(localClusterConnectionId, remoteClusterAlias, remoteClusterSeedNodeTransportAddress);
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to add the remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}), (Throwable)runtimeException);
        }
    }

    public void deleteRemoteCluster(String remoteClusterAlias, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Removing remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}));
        }
        try {
            this._updateSettings(localClusterConnectionId, remoteClusterAlias, null);
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to remove the remote cluster ", remoteClusterAlias, " for connection ", localClusterConnectionId}), (Throwable)runtimeException);
        }
    }

    public void follow(String indexName) {
        if (!this.crossClusterReplicationConfigurationHelper.isCrossClusterReplicationEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Not following index " + indexName + " because cross-cluster replication is not enabled"));
            }
            return;
        }
        for (String localClusterConnectionId : this.crossClusterReplicationConfigurationHelper.getLocalClusterConnectionIds()) {
            this.follow(this._crossClusterReplicationConfiguration.remoteClusterAlias(), indexName, localClusterConnectionId);
        }
    }

    public void follow(String remoteClusterAlias, String indexName, String localClusterConnectionId) {
        if (this._isFollowingActive(localClusterConnectionId, indexName)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{"The ", indexName, " index is already being followed for connection ", localClusterConnectionId}));
            }
            return;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Executing follow request for the ", indexName, " index with connection ", localClusterConnectionId}));
        }
        try {
            this._putFollow(remoteClusterAlias, indexName, localClusterConnectionId);
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to follow the ", indexName, " index in the ", remoteClusterAlias, " cluster for connection ", localClusterConnectionId}), (Throwable)runtimeException);
        }
    }

    public void unfollow(String indexName) {
        if (!this.crossClusterReplicationConfigurationHelper.isCrossClusterReplicationEnabled()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Not unfollowing index " + indexName + " because cross-cluster replication is not enabled"));
            }
            return;
        }
        for (String localClusterConnectionId : this.crossClusterReplicationConfigurationHelper.getLocalClusterConnectionIds()) {
            this.unfollow(indexName, localClusterConnectionId);
        }
    }

    public void unfollow(String indexName, String localClusterConnectionId) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((String[])new String[]{"Executing unfollow requests for the ", indexName, " index with connection ", localClusterConnectionId}));
        }
        try {
            this._pauseFollow(indexName, localClusterConnectionId);
            this._closeIndex(indexName, localClusterConnectionId);
            this._unfollow(indexName, localClusterConnectionId);
            this._deleteIndex(indexName, localClusterConnectionId);
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to unfollow the ", indexName, " index for connection ", localClusterConnectionId}), (Throwable)runtimeException);
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._crossClusterReplicationConfiguration = (CrossClusterReplicationConfiguration)ConfigurableUtil.createConfigurable(CrossClusterReplicationConfiguration.class, properties);
    }

    private void _closeIndex(String indexName, String connectionId) {
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{indexName});
        closeIndexRequest.setConnectionId(connectionId);
        this.searchEngineAdapter.execute((IndexRequest)closeIndexRequest);
    }

    private void _deleteIndex(String indexName, String connectionId) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(new String[]{indexName});
        deleteIndexRequest.setConnectionId(connectionId);
        this.searchEngineAdapter.execute((IndexRequest)deleteIndexRequest);
    }

    private boolean _isFollowingActive(String connectionId, String indexName) {
        block3: {
            try {
                FollowInfoCCRRequest followInfoCCRRequest = new FollowInfoCCRRequest(indexName);
                followInfoCCRRequest.setConnectionId(connectionId);
                FollowInfoCCRResponse followInfoCCRResponse = (FollowInfoCCRResponse)this.searchEngineAdapter.execute((CCRRequest)followInfoCCRRequest);
                FollowInfoStatus followInfoStatus = followInfoCCRResponse.getFollowInfoStatus();
                if (followInfoStatus == FollowInfoStatus.ACTIVE) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)runtimeException);
            }
        }
        return false;
    }

    private void _pauseFollow(String indexName, String connectionId) {
        PauseFollowCCRRequest pauseFollowCCRRequest = new PauseFollowCCRRequest(indexName);
        pauseFollowCCRRequest.setConnectionId(connectionId);
        this.searchEngineAdapter.execute((CCRRequest)pauseFollowCCRRequest);
    }

    private void _putFollow(String remoteClusterAlias, String indexName, String connectionId) {
        PutFollowCCRRequest putFollowRequest = new PutFollowCCRRequest(remoteClusterAlias, indexName, indexName);
        putFollowRequest.setConnectionId(connectionId);
        putFollowRequest.setWaitForActiveShards(1);
        this.searchEngineAdapter.execute((CCRRequest)putFollowRequest);
    }

    private void _unfollow(String indexName, String connectionId) {
        UnfollowCCRRequest unfollowCCRRequest = new UnfollowCCRRequest(indexName);
        unfollowCCRRequest.setConnectionId(connectionId);
        this.searchEngineAdapter.execute((CCRRequest)unfollowCCRRequest);
    }

    private void _updateSettings(String connectionId, String remoteClusterAlias, String remoteClusterSeedNodeTransportAddress) {
        UpdateSettingsClusterRequest updateSettingsClusterRequest = new UpdateSettingsClusterRequest();
        updateSettingsClusterRequest.setConnectionId(connectionId);
        updateSettingsClusterRequest.setPersistentSettings((Map)HashMapBuilder.put((Object)("cluster.remote." + remoteClusterAlias + ".seeds"), (Object)remoteClusterSeedNodeTransportAddress).build());
        this.searchEngineAdapter.execute((ClusterRequest)updateSettingsClusterRequest);
    }
}

