/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.persistence.listener;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.search.ccr.CrossClusterReplicationHelper;
import com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.CrossClusterReplicationConfiguration;
import com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.helper.CrossClusterReplicationHelperImpl;
import com.liferay.portal.search.engine.SearchEngineInformation;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetIndexIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.portal.search.elasticsearch.cross.cluster.replication.internal.configuration.CrossClusterReplicationConfiguration"}, service={ConfigurationModelListener.class})
public class CrossClusterReplicationConfigurationModelListener
implements ConfigurationModelListener {
    @Reference
    protected ConfigurationAdmin configurationAdmin;
    @Reference
    protected CrossClusterReplicationHelper crossClusterReplicationHelper;
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Log _log = LogFactoryUtil.getLog(CrossClusterReplicationConfigurationModelListener.class);
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private SearchEngineInformation _searchEngineInformation;

    public void onAfterSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        if (GetterUtil.getBoolean((Object)properties.get("ccrEnabled"))) {
            if (GetterUtil.getBoolean((Object)properties.get("automaticReplicationEnabled"))) {
                String remoteClusterAlias = (String)properties.get("remoteClusterAlias");
                this._addRemoteAndFollowIndexes(remoteClusterAlias, properties);
            }
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Read operations from local clusters are enabled");
            }
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)"Read operations from local clusters are disabled");
        }
    }

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        boolean ccrEnabled = GetterUtil.getBoolean((Object)properties.get("ccrEnabled"));
        String[] ccrLocalClusterConnectionConfigurations = GetterUtil.getStringValues((Object)properties.get("ccrLocalClusterConnectionConfigurations"));
        if (ccrEnabled) {
            this._validateCCRLocalClusterConnectionConfigurations(ccrLocalClusterConnectionConfigurations, properties);
        }
        Configuration[] configurations = null;
        try {
            String filterString = String.format("(service.pid=%s)", pid);
            configurations = this.configurationAdmin.listConfigurations(filterString);
        }
        catch (Exception exception) {
            throw new ConfigurationModelListenerException(exception.getMessage(), CrossClusterReplicationConfiguration.class, this.getClass(), properties);
        }
        if (configurations == null) {
            return;
        }
        Configuration configuration = configurations[0];
        Dictionary previousProperties = configuration.getProperties();
        boolean automaticReplicationEnabled = GetterUtil.getBoolean((Object)properties.get("automaticReplicationEnabled"));
        String[] excludedIndexes = GetterUtil.getStringValues((Object)properties.get("excludedIndexes"));
        boolean previousAutomaticReplicationEnabled = GetterUtil.getBoolean(previousProperties.get("automaticReplicationEnabled"), (boolean)true);
        String[] previousExcludedIndexes = GetterUtil.getStringValues(previousProperties.get("excludedIndexes"));
        boolean previousCcrEnabled = GetterUtil.getBoolean(previousProperties.get("ccrEnabled"));
        String[] previousCcrLocalClusterConnectionConfigurations = GetterUtil.getStringValues(previousProperties.get("ccrLocalClusterConnectionConfigurations"));
        String previousRemoteClusterAlias = (String)previousProperties.get("remoteClusterAlias");
        String previousRemoteClusterSeedNodeTransportAddress = (String)previousProperties.get("remoteClusterSeedNodeTransportAddress");
        String remoteClusterAlias = (String)properties.get("remoteClusterAlias");
        String remoteClusterSeedNodeTransportAddress = (String)properties.get("remoteClusterSeedNodeTransportAddress");
        if (!(!previousCcrEnabled || !previousAutomaticReplicationEnabled || ccrEnabled && automaticReplicationEnabled && this._equals(previousCcrLocalClusterConnectionConfigurations, ccrLocalClusterConnectionConfigurations) && previousRemoteClusterAlias.equals(remoteClusterAlias) && previousRemoteClusterSeedNodeTransportAddress.equals(remoteClusterSeedNodeTransportAddress) && this._equals(previousExcludedIndexes, excludedIndexes))) {
            this._unfollowIndexesAndDeleteRemoteCluster(previousCcrLocalClusterConnectionConfigurations, previousRemoteClusterAlias, previousExcludedIndexes);
        }
    }

    private void _addRemoteAndFollowIndexes(String remoteClusterAlias, Dictionary<String, Object> properties) {
        Log log;
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Creating follower indexes");
        }
        if (!(log = LogFactoryUtil.getLog(CrossClusterReplicationHelperImpl.class)).isInfoEnabled() && _log.isInfoEnabled()) {
            _log.info((Object)("For more information, enable INFO logs on " + CrossClusterReplicationHelperImpl.class));
        }
        String[] excludedIndexes = GetterUtil.getStringValues((Object)properties.get("excludedIndexes"));
        String remoteClusterSeedNodeTransportAddress = (String)properties.get("remoteClusterSeedNodeTransportAddress");
        String[] ccrLocalClusterConnectionConfigurations = GetterUtil.getStringValues((Object)properties.get("ccrLocalClusterConnectionConfigurations"));
        String[] indexNames = this._getIndexNames(null);
        for (String ccrLocalClusterConnectionConfiguration : ccrLocalClusterConnectionConfigurations) {
            List localClusterConnectionConfigurationParts = StringUtil.split((String)ccrLocalClusterConnectionConfiguration);
            String localClusterConnectionId = (String)localClusterConnectionConfigurationParts.get(1);
            this.crossClusterReplicationHelper.addRemoteCluster(remoteClusterAlias, remoteClusterSeedNodeTransportAddress, localClusterConnectionId);
            for (String indexName : indexNames) {
                if (indexName.startsWith(".") || this._isExcludedIndex(indexName, excludedIndexes)) continue;
                this.crossClusterReplicationHelper.follow(remoteClusterAlias, indexName, localClusterConnectionId);
            }
        }
    }

    private boolean _equals(String[] array1, String[] array2) {
        if (ArrayUtil.isEmpty((Object[])array1) && ArrayUtil.isEmpty((Object[])array2)) {
            return true;
        }
        return ArrayUtil.containsAll((Object[])array1, (Object[])array2) && ArrayUtil.containsAll((Object[])array2, (Object[])array1);
    }

    private String[] _getIndexNames(String connectionId) {
        GetIndexIndexRequest getIndexIndexRequest = new GetIndexIndexRequest("*");
        getIndexIndexRequest.setConnectionId(connectionId);
        getIndexIndexRequest.setPreferLocalCluster(false);
        GetIndexIndexResponse getIndexIndexResponse = (GetIndexIndexResponse)this.searchEngineAdapter.execute((IndexRequest)getIndexIndexRequest);
        return getIndexIndexResponse.getIndexNames();
    }

    private String _getMessage(String key, Object ... arguments) {
        try {
            return ResourceBundleUtil.getString((ResourceBundle)this._getResourceBundle(), (String)key, (Object[])arguments);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private ResourceBundle _getResourceBundle() {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)LocaleThreadLocal.getThemeDisplayLocale(), this.getClass());
    }

    private boolean _isExcludedIndex(String indexName, String[] excludedIndexes) {
        return ArrayUtil.contains((Object[])excludedIndexes, (Object)indexName);
    }

    private void _unfollowIndexesAndDeleteRemoteCluster(String[] ccrLocalClusterConnectionConfigurations, String remoteClusterAlias, String[] excludedIndexes) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Deleting follower indexes");
        }
        for (String ccrLocalClusterConnectionConfiguration : ccrLocalClusterConnectionConfigurations) {
            List localClusterConnectionConfigurationParts = StringUtil.split((String)ccrLocalClusterConnectionConfiguration);
            String localClusterConnectionId = (String)localClusterConnectionConfigurationParts.get(1);
            try {
                for (String indexName : this._getIndexNames(localClusterConnectionId)) {
                    if (indexName.startsWith(".") || this._isExcludedIndex(indexName, excludedIndexes)) continue;
                    this.crossClusterReplicationHelper.unfollow(indexName, localClusterConnectionId);
                }
                this.crossClusterReplicationHelper.deleteRemoteCluster(remoteClusterAlias, localClusterConnectionId);
            }
            catch (RuntimeException runtimeException) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to unfollow indexes and/or delete remote cluster for connection " + localClusterConnectionId), (Throwable)runtimeException);
            }
        }
    }

    private void _validateCCRLocalClusterConnectionConfigurations(String[] ccrLocalClusterConnectionConfigurations, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        if (ArrayUtil.isEmpty((Object[])ccrLocalClusterConnectionConfigurations)) {
            throw new ConfigurationModelListenerException(this._getMessage("please-set-a-hostname-and-connection-id", new Object[0]), CrossClusterReplicationConfiguration.class, this.getClass(), properties);
        }
        ClusterNode localClusterNode = this._clusterExecutor.getLocalClusterNode();
        if (localClusterNode == null && ccrLocalClusterConnectionConfigurations.length > 1) {
            throw new ConfigurationModelListenerException(this._getMessage("please-set-only-one-config-when-liferay-is-not-clustered", new Object[0]), CrossClusterReplicationConfiguration.class, this.getClass(), properties);
        }
        List connectionIds = TransformUtil.transform((Collection)this._searchEngineInformation.getConnectionInformationList(), connectionInformation -> connectionInformation.getConnectionId());
        for (String ccrLocalClusterConnectionConfiguration : ccrLocalClusterConnectionConfigurations) {
            List localClusterConnectionConfigurationParts = StringUtil.split((String)ccrLocalClusterConnectionConfiguration);
            if (localClusterConnectionConfigurationParts.size() != 2) {
                throw new ConfigurationModelListenerException(this._getMessage("please-set-a-hostname-and-connection-id", new Object[0]), CrossClusterReplicationConfiguration.class, this.getClass(), properties);
            }
            if (connectionIds.contains(localClusterConnectionConfigurationParts.get(1))) continue;
            throw new ConfigurationModelListenerException(this._getMessage("please-set-a-valid-connection-id", new Object[0]), CrossClusterReplicationConfiguration.class, this.getClass(), properties);
        }
    }
}

