/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.suggest;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.suggest.DictionaryEntry;
import com.liferay.portal.search.suggest.DictionaryVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class DictionaryReader {
    private static final int _UNICODE_BYTE_ORDER_MARK = 65279;
    private final BufferedReader _bufferedReader;
    private final boolean _utf8;

    public DictionaryReader(InputStream inputStream) throws UnsupportedEncodingException {
        this(inputStream, "UTF-8");
    }

    public DictionaryReader(InputStream inputStream, String encoding) throws UnsupportedEncodingException {
        this._utf8 = "UTF-8".equals(encoding);
        this._bufferedReader = new BufferedReader(new InputStreamReader(inputStream, encoding));
    }

    public void accept(DictionaryVisitor dictionaryVisitor) {
        DictionaryIterator iterator = new DictionaryIterator();
        iterator.forEachRemaining(dictionaryEntry -> {
            if (!Validator.isBlank((String)dictionaryEntry.getWord())) {
                dictionaryVisitor.visitDictionaryEntry((DictionaryEntry)dictionaryEntry);
            }
        });
    }

    public Iterator<DictionaryEntry> getDictionaryEntriesIterator() {
        return new DictionaryIterator();
    }

    private class DictionaryIterator
    implements Iterator<DictionaryEntry> {
        private boolean _calledHasNext;
        private String _line;

        private DictionaryIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this._calledHasNext) {
                try {
                    this._line = DictionaryReader.this._bufferedReader.readLine();
                    this._calledHasNext = true;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(ioe);
                }
            }
            return this._line != null;
        }

        @Override
        public DictionaryEntry next() {
            if (!this._calledHasNext) {
                this.hasNext();
            }
            this._calledHasNext = false;
            if (DictionaryReader.this._utf8 && !this._line.isEmpty() && this._line.charAt(0) == '\ufeff') {
                this._line = this._line.substring(1);
            }
            return new DictionaryEntry(this._line);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

