/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.suggest;

import com.liferay.osgi.util.service.Snapshot;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.NGramHolder;
import com.liferay.portal.kernel.search.suggest.NGramHolderBuilder;
import com.liferay.portal.search.suggest.BaseSpellCheckIndexWriter;
import com.liferay.portal.search.suggest.DictionaryReader;
import com.liferay.portal.search.suggest.NullNGramHolderBuilder;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class BaseGenericSpellCheckIndexWriter
extends BaseSpellCheckIndexWriter {
    private static final int _DEFAULT_BATCH_SIZE = 1000;
    private static final Log _log = LogFactoryUtil.getLog(BaseGenericSpellCheckIndexWriter.class);
    private static final NGramHolderBuilder _defaultNGramHolderBuilder = new NullNGramHolderBuilder();
    private static final Snapshot<NGramHolderBuilder> _nGramHolderBuilderSnapshot = new Snapshot(BaseGenericSpellCheckIndexWriter.class, NGramHolderBuilder.class, null, true);
    private int _batchSize = 1000;
    private Document _documentPrototype = new DocumentImpl();

    public void setBatchSize(int batchSize) {
        this._batchSize = batchSize;
    }

    public void setDocumentPrototype(Document documentPrototype) {
        this._documentPrototype = documentPrototype;
    }

    protected abstract void addDocument(String var1, SearchContext var2, Document var3) throws SearchException;

    protected abstract void addDocuments(String var1, SearchContext var2, Collection<Document> var3) throws SearchException;

    protected void addNGramFields(Document document, Map<String, String> nGrams) {
        for (Map.Entry<String, String> nGramEntry : nGrams.entrySet()) {
            document.addKeyword(nGramEntry.getKey(), nGramEntry.getValue());
        }
    }

    protected Document createDocument() {
        return (Document)this._documentPrototype.clone();
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String keywords, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws SearchException {
        Document document = this.createDocument();
        document.addKeyword(keywordFieldName, keywords);
        document.addKeyword("companyId", companyId);
        document.addKeyword("groupId", groupId);
        document.addKeyword("languageId", languageId);
        document.addKeyword("priority", String.valueOf(weight));
        document.addKeyword("type", typeFieldValue);
        document.addKeyword("uid", this.getUID(companyId, keywordFieldName, languageId, keywords, new String[0]));
        NGramHolderBuilder nGramHolderBuilder = this.getNGramHolderBuilder();
        NGramHolder nGramHolder = nGramHolderBuilder.buildNGramHolder(keywords, maxNGramLength);
        this.addNGramFields(document, nGramHolder.getNGramEnds());
        Map nGrams = nGramHolder.getNGrams();
        for (Map.Entry entry : nGrams.entrySet()) {
            String fieldName = (String)entry.getKey();
            for (String nGram : (List)entry.getValue()) {
                document.addKeyword(fieldName, nGram);
            }
        }
        this.addNGramFields(document, nGramHolder.getNGramStarts());
        return document;
    }

    protected NGramHolderBuilder getNGramHolderBuilder() {
        NGramHolderBuilder nGramHolderBuilder = (NGramHolderBuilder)_nGramHolderBuilderSnapshot.get();
        if (nGramHolderBuilder != null) {
            return nGramHolderBuilder;
        }
        return _defaultNGramHolderBuilder;
    }

    @Override
    protected void indexKeyword(SearchContext searchContext, long groupId, String languageId, String keyword, float weight, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        Document document = this.createDocument(searchContext.getCompanyId(), groupId, languageId, keyword, weight, keywordFieldName, typeFieldValue, maxNGramLength);
        this.addDocument(typeFieldValue, searchContext, document);
    }

    @Override
    protected void indexKeywords(SearchContext searchContext, long groupId, String languageId, InputStream inputStream, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        HashSet<Document> documents = new HashSet<Document>();
        try {
            DictionaryReader dictionaryReader = new DictionaryReader(inputStream, "UTF-8");
            try {
                dictionaryReader.accept(dictionaryEntry -> {
                    try {
                        Document document = this.createDocument(searchContext.getCompanyId(), groupId, languageId, dictionaryEntry.getWord(), dictionaryEntry.getWeight(), keywordFieldName, typeFieldValue, maxNGramLength);
                        documents.add(document);
                        if (documents.size() == this._batchSize) {
                            this.addDocuments(typeFieldValue, searchContext, documents);
                            documents.clear();
                        }
                    }
                    catch (SearchException searchException) {
                        throw new RuntimeException(searchException);
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable = runtimeException.getCause();
                if (throwable instanceof SearchException) {
                    throw (SearchException)throwable;
                }
                throw runtimeException;
            }
            this.addDocuments(typeFieldValue, searchContext, documents);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to index dictionaries", (Throwable)exception);
            }
            throw exception;
        }
    }
}

