/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.admin.web.internal.portlet.action;

import com.liferay.portal.instances.service.PortalInstancesLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskManager;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageListenerException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.uuid.PortalUUID;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_portal_search_admin_web_portlet_SearchAdminPortlet", "mvc.command.name=/search_admin/edit"}, service={MVCActionCommand.class})
public class EditMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private BackgroundTaskManager _backgroundTaskManager;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private MessageBus _messageBus;
    @Reference
    private PortalInstancesLocalService _portalInstancesLocalService;
    @Reference
    private PortalUUID _portalUUID;

    public void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (!permissionChecker.isOmniadmin()) {
            SessionErrors.add((PortletRequest)actionRequest, (String)PrincipalException.MustBeOmniadmin.class.getName());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            return;
        }
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (cmd.equals("reindex")) {
            this.reindex(actionRequest);
        } else if (cmd.equals("reindexDictionaries")) {
            this.reindexDictionaries(actionRequest);
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindex(final ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        HashMap taskContextMap = new HashMap();
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        if (!ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"blocking")) {
            this._indexWriterHelper.reindex(themeDisplay.getUserId(), "reindex", this._portalInstancesLocalService.getCompanyIds(), className, taskContextMap);
            return;
        }
        final String jobName = "reindex-".concat(this._portalUUID.generate());
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        MessageListener messageListener = new MessageListener(){

            public void receive(Message message) throws MessageListenerException {
                int status = message.getInteger("status");
                if (status != 5 && status != 2 && status != 3) {
                    return;
                }
                if (!jobName.equals(message.getString("name"))) {
                    return;
                }
                PortletSession portletSession = actionRequest.getPortletSession();
                long lastAccessedTime = portletSession.getLastAccessedTime();
                int maxInactiveInterval = portletSession.getMaxInactiveInterval();
                int extendedMaxInactiveIntervalTime = (int)(System.currentTimeMillis() - lastAccessedTime + (long)maxInactiveInterval);
                portletSession.setMaxInactiveInterval(extendedMaxInactiveIntervalTime);
                countDownLatch.countDown();
            }
        };
        this._messageBus.registerMessageListener("liferay/background_task_status", messageListener);
        try {
            this._indexWriterHelper.reindex(themeDisplay.getUserId(), jobName, this._portalInstancesLocalService.getCompanyIds(), className, taskContextMap);
            countDownLatch.await(ParamUtil.getLong((PortletRequest)actionRequest, (String)"timeout", (long)3600000L), TimeUnit.MILLISECONDS);
        }
        finally {
            this._messageBus.unregisterMessageListener("liferay/background_task_status", messageListener);
        }
    }

    protected void reindexDictionaries(ActionRequest actionRequest) throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = this._portalInstancesLocalService.getCompanyIds()) {
            this._indexWriterHelper.indexQuerySuggestionDictionaries(companyId);
            this._indexWriterHelper.indexSpellCheckerDictionaries(companyId);
        }
    }
}

