/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.admin.web.internal.display.context;

import com.liferay.frontend.taglib.clay.servlet.taglib.util.NavigationItemList;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.admin.web.internal.display.context.SearchAdminDisplayContext;
import com.liferay.portal.search.index.IndexInformation;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class SearchAdminDisplayBuilder {
    private IndexInformation _indexInformation;
    private final Language _language;
    private final Portal _portal;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;

    public SearchAdminDisplayBuilder(Language language, Portal portal, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._language = language;
        this._portal = portal;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public SearchAdminDisplayContext build() {
        SearchAdminDisplayContext searchAdminDisplayContext = new SearchAdminDisplayContext();
        boolean indexInformationAvailable = this.isIndexInformationAvailable();
        searchAdminDisplayContext.setIndexInformationAvailable(indexInformationAvailable);
        NavigationItemList navigationItemList = new NavigationItemList();
        String selectedTab = this.getSelectedTab();
        this.addNavigationItemList(navigationItemList, "index-actions", selectedTab);
        if (indexInformationAvailable) {
            this.addNavigationItemList(navigationItemList, "field-mappings", selectedTab);
        }
        searchAdminDisplayContext.setNavigationItemList(navigationItemList);
        searchAdminDisplayContext.setSelectedTab(selectedTab);
        return searchAdminDisplayContext;
    }

    public void setIndexInformation(IndexInformation indexInformation) {
        this._indexInformation = indexInformation;
    }

    protected void addNavigationItemList(NavigationItemList navigationItemList, String label, String selectedTab) {
        navigationItemList.add(navigationItem -> {
            navigationItem.setActive(selectedTab.equals(label));
            navigationItem.setHref(this._renderResponse.createRenderURL(), new Object[]{"tabs1", label});
            navigationItem.setLabel(this._language.get(this._portal.getHttpServletRequest((PortletRequest)this._renderRequest), label));
        });
    }

    protected String getSelectedTab() {
        String selectedTab = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"tabs1", (String)"index-actions");
        selectedTab = this.isIndexInformationAvailable() && Objects.equals(selectedTab, "field-mappings") ? "field-mappings" : "index-actions";
        return selectedTab;
    }

    protected boolean isIndexInformationAvailable() {
        return this._indexInformation != null;
    }
}

