/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.admin.web.internal.display.context;

import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.admin.web.internal.display.context.FieldMappingIndexDisplayContext;
import com.liferay.portal.search.admin.web.internal.display.context.FieldMappingsDisplayContext;
import com.liferay.portal.search.index.IndexInformation;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldMappingsDisplayBuilder {
    private long _companyId;
    private String _currentURL;
    private final Http _http;
    private IndexInformation _indexInformation;
    private String _namespace = "";
    private String _selectedIndexName;

    public FieldMappingsDisplayBuilder(Http http) {
        this._http = http;
    }

    public FieldMappingsDisplayContext build() {
        FieldMappingsDisplayContext fieldMappingsDisplayContext = new FieldMappingsDisplayContext();
        List<String> indexNames = Arrays.asList(this._indexInformation.getIndexNames());
        fieldMappingsDisplayContext.setIndexNames(indexNames);
        String selectedIndexName = this.getSelectedIndexName(indexNames);
        fieldMappingsDisplayContext.setFieldMappingIndexDisplayContexts(this.getFieldMappingIndexDisplayContexts(indexNames, selectedIndexName));
        fieldMappingsDisplayContext.setFieldMappings(this._indexInformation.getFieldMappings(selectedIndexName));
        fieldMappingsDisplayContext.setSelectedIndexName(selectedIndexName);
        return fieldMappingsDisplayContext;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setCurrentURL(String currentURL) {
        this._currentURL = currentURL;
    }

    public void setIndexInformation(IndexInformation indexInformation) {
        this._indexInformation = indexInformation;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setSelectedIndexName(String selectedIndexName) {
        this._selectedIndexName = selectedIndexName;
    }

    protected FieldMappingIndexDisplayContext getFieldMappingIndexDisplayContext(String indexName, boolean selected) {
        FieldMappingIndexDisplayContext fieldMappingIndexDisplayContext = new FieldMappingIndexDisplayContext();
        fieldMappingIndexDisplayContext.setName(indexName);
        if (selected) {
            fieldMappingIndexDisplayContext.setCssClass("active");
        }
        String url = this._http.setParameter(this._currentURL, this._namespace + "selectedIndexName", indexName);
        fieldMappingIndexDisplayContext.setUrl(url);
        return fieldMappingIndexDisplayContext;
    }

    protected List<FieldMappingIndexDisplayContext> getFieldMappingIndexDisplayContexts(List<String> indexNames, String selectedIndexName) {
        Stream stream = indexNames.stream();
        return stream.map(indexName -> this.getFieldMappingIndexDisplayContext((String)indexName, selectedIndexName.equals(indexName))).collect(Collectors.toList());
    }

    protected String getSelectedIndexName(List<String> indexNames) {
        String selectedIndexName = this._selectedIndexName;
        if (Validator.isBlank((String)selectedIndexName)) {
            selectedIndexName = this._indexInformation.getCompanyIndexName(this._companyId);
        }
        if (!indexNames.contains(selectedIndexName)) {
            selectedIndexName = indexNames.get(0);
        }
        return selectedIndexName;
    }
}

