/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.ruby.internal;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scripting.ExecutionException;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.scripting.BaseScriptingExecutor;
import com.liferay.portal.scripting.ruby.configuration.RubyScriptingConfiguration;
import com.liferay.portal.scripting.ruby.internal.RubyScriptingContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.LocalContextProvider;
import org.jruby.exceptions.RaiseException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Deprecated
@Component(configurationPid={"com.liferay.portal.scripting.ruby.configuration.RubyScriptingConfiguration"}, immediate=true, property={"scripting.language=ruby"}, service={ScriptingExecutor.class})
public class RubyExecutor
extends BaseScriptingExecutor {
    public static final String LANGUAGE = "ruby";
    private static final String _COMPILE_MODE_FORCE = "force";
    private static final String _COMPILE_MODE_JIT = "jit";
    private static final Log _log = LogFactoryUtil.getLog(RubyExecutor.class);
    private static final Field _globalRuntimeField;
    private static final ThreadFactory _threadFactory;
    private String _basePath;
    private boolean _executeInSeparateThread = true;
    private List<String> _loadPaths;
    private volatile RubyScriptingConfiguration _rubyScriptingConfiguration;
    private com.liferay.portal.kernel.scripting.ScriptingContainer<ScriptingContainer> _scriptingContainer;

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, scriptFile, null);
    }

    public Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, String script) throws ScriptingException {
        return this.eval(allowedClasses, inputObjects, outputNames, null, script);
    }

    public String getLanguage() {
        return LANGUAGE;
    }

    public com.liferay.portal.kernel.scripting.ScriptingContainer<?> getScriptingContainer() {
        return this._scriptingContainer;
    }

    public ScriptingExecutor newInstance(boolean executeInSeparateThread) {
        RubyExecutor rubyExecutor = new RubyExecutor();
        rubyExecutor.setExecuteInSeparateThread(executeInSeparateThread);
        return rubyExecutor;
    }

    public void setExecuteInSeparateThread(boolean executeInSeparateThread) {
        this._executeInSeparateThread = executeInSeparateThread;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._rubyScriptingConfiguration = (RubyScriptingConfiguration)ConfigurableUtil.createConfigurable(RubyScriptingConfiguration.class, properties);
        this.initialize();
    }

    @Deactivate
    protected void deactivate() {
        this._scriptingContainer.destroy();
    }

    protected Map<String, Object> doEval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script) throws ScriptingException {
        if (allowedClasses != null) {
            throw new ExecutionException("Constrained execution not supported for Ruby");
        }
        ScriptingContainer scriptingContainer = (ScriptingContainer)this._scriptingContainer.getWrappedScriptingContainer();
        try {
            LocalContextProvider localContextProvider = scriptingContainer.getProvider();
            RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
            rubyInstanceConfig.setCurrentDirectory(this._basePath);
            rubyInstanceConfig.setLoader(this.getClassLoader());
            rubyInstanceConfig.setLoadPaths(this._loadPaths);
            for (Map.Entry<String, Object> entry : inputObjects.entrySet()) {
                String inputName = entry.getKey();
                Object inputObject = entry.getValue();
                if (!inputName.startsWith("$")) {
                    inputName = "$" + inputName;
                }
                scriptingContainer.put(inputName, inputObject);
            }
            if (scriptFile != null) {
                scriptingContainer.runScriptlet((InputStream)new FileInputStream(scriptFile), scriptFile.toString());
            } else {
                this._scriptingContainer.runScriptlet(script);
            }
            if (outputNames == null) {
                Iterator<Map.Entry<String, Object>> iterator = null;
                return iterator;
            }
            HashMap<String, Object> outputObjects = new HashMap<String, Object>();
            for (String outputName : outputNames) {
                outputObjects.put(outputName, scriptingContainer.get(outputName));
            }
            HashMap<String, Object> hashMap = outputObjects;
            return hashMap;
        }
        catch (RaiseException re) {
            RubyException rubyException = re.getException();
            throw new ScriptingException(rubyException.message.asJavaString() + "\n\n", (Throwable)re);
        }
        catch (FileNotFoundException fnfe) {
            throw new ScriptingException((Throwable)fnfe);
        }
        finally {
            try {
                _globalRuntimeField.set(null, null);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected Map<String, Object> eval(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script) throws ScriptingException {
        if (!this._executeInSeparateThread) {
            return this.doEval(allowedClasses, inputObjects, outputNames, scriptFile, script);
        }
        EvalCallable evalCallable = new EvalCallable(allowedClasses, inputObjects, outputNames, scriptFile, script);
        FutureTask<Map<String, Object>> futureTask = new FutureTask<Map<String, Object>>(evalCallable);
        Thread oneTimeExecutorThread = _threadFactory.newThread(futureTask);
        oneTimeExecutorThread.start();
        try {
            oneTimeExecutorThread.join();
            return futureTask.get();
        }
        catch (Exception e) {
            futureTask.cancel(true);
            oneTimeExecutorThread.interrupt();
            throw new ScriptingException((Throwable)e);
        }
    }

    protected void initialize() {
        ScriptingContainer scriptingContainer = new ScriptingContainer(LocalContextScope.THREADSAFE);
        this._scriptingContainer = new RubyScriptingContainer(scriptingContainer);
        LocalContextProvider localContextProvider = scriptingContainer.getProvider();
        RubyInstanceConfig rubyInstanceConfig = localContextProvider.getRubyInstanceConfig();
        String compileMode = this._rubyScriptingConfiguration.compileMode();
        if (compileMode.equals(_COMPILE_MODE_FORCE)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.FORCE);
        } else if (compileMode.equals(_COMPILE_MODE_JIT)) {
            rubyInstanceConfig.setCompileMode(RubyInstanceConfig.CompileMode.JIT);
        }
        rubyInstanceConfig.setJitThreshold(this._rubyScriptingConfiguration.compileThreshold());
        rubyInstanceConfig.setLoader(this.getClassLoader());
        this._loadPaths = new ArrayList<String>(Arrays.asList(this._rubyScriptingConfiguration.loadPaths()));
        rubyInstanceConfig.setLoadPaths(this._loadPaths);
        scriptingContainer.setCurrentDirectory(this._basePath);
    }

    @Reference(unbind="-")
    protected void setProps(Props props) {
        this._basePath = props.get("liferay.lib.portal.dir");
    }

    static {
        _threadFactory = new NamedThreadFactory(RubyExecutor.class.getName(), 5, RubyExecutor.class.getClassLoader());
        try {
            _globalRuntimeField = ReflectionUtil.getDeclaredField(Ruby.class, (String)"globalRuntime");
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class EvalCallable
    implements Callable<Map<String, Object>> {
        private final Set<String> _allowedClasses;
        private final Map<String, Object> _inputObjects;
        private final Set<String> _outputNames;
        private final String _script;
        private final File _scriptFile;

        public EvalCallable(Set<String> allowedClasses, Map<String, Object> inputObjects, Set<String> outputNames, File scriptFile, String script) {
            this._allowedClasses = allowedClasses;
            this._inputObjects = inputObjects;
            this._outputNames = outputNames;
            this._scriptFile = scriptFile;
            this._script = script;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            return RubyExecutor.this.doEval(this._allowedClasses, this._inputObjects, this._outputNames, this._scriptFile, this._script);
        }
    }
}

