/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.ruby.internal;

import com.liferay.portal.kernel.scripting.ScriptingException;
import org.jruby.RubyArray;
import org.jruby.RubyException;
import org.jruby.embed.ScriptingContainer;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyScriptingContainer
implements com.liferay.portal.kernel.scripting.ScriptingContainer<ScriptingContainer> {
    private final ScriptingContainer _scriptingContainer;

    public RubyScriptingContainer(ScriptingContainer scriptingContainer) {
        this._scriptingContainer = scriptingContainer;
    }

    public <T> T callMethod(Object scriptObject, String methodName, Object[] arguments, Class<T> returnClass) throws ScriptingException {
        try {
            return (T)this._scriptingContainer.callMethod(scriptObject, methodName, arguments, returnClass);
        }
        catch (RaiseException re) {
            RubyException rubyException = re.getException();
            IRubyObject iRubyObject = rubyException.getBacktrace();
            RubyArray rubyArray = (RubyArray)iRubyObject.toJava(RubyArray.class);
            StringBuilder sb = new StringBuilder(2 * rubyArray.size() + 2);
            sb.append(String.valueOf(rubyException.message.toJava(String.class)));
            sb.append("\n");
            for (Object object : rubyArray) {
                sb.append(String.valueOf(object));
                sb.append("\n");
            }
            throw new ScriptingException(sb.toString(), (Throwable)re);
        }
    }

    public void destroy() {
        this._scriptingContainer.terminate();
    }

    public ScriptingContainer getWrappedScriptingContainer() {
        return this._scriptingContainer;
    }

    public Object runScriptlet(String scriptlet) {
        return this._scriptingContainer.runScriptlet(scriptlet);
    }

    public void setCurrentDirName(String currentDirName) {
        this._scriptingContainer.setCurrentDirectory(currentDirName);
    }
}

