/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.executor.internal.messaging;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.URLUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class ScriptingExecutorMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ScriptingExecutorMessageListener.class);
    private final Scripting _scripting;

    public ScriptingExecutorMessageListener(Scripting scripting) {
        this._scripting = scripting;
    }

    protected void doReceive(Message message) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        String scriptingLanguage = message.getString("scriptingLanguage");
        List urls = (List)message.get("urls");
        ClassLoader bundleClassLoader = (ClassLoader)message.get("bundleClassLoader");
        if (bundleClassLoader != null) {
            classLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)classLoader, (ClassLoader[])new ClassLoader[]{bundleClassLoader});
        }
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)classLoader);){
            for (URL url : urls) {
                try {
                    this._scripting.exec(null, new HashMap(), scriptingLanguage, URLUtil.toString((URL)url));
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to execute script " + url.getFile()), (Throwable)exception);
                }
            }
        }
    }
}

