/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.executor.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scripting.Scripting;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

public class ScriptingExecutorMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(ScriptingExecutorMessageListener.class);
    private final Scripting _scripting;

    public ScriptingExecutorMessageListener(Scripting scripting) {
        this._scripting = scripting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        String scriptingLanguage = message.getString("scriptingLanguage");
        List urls = (List)message.get("urls");
        for (URL url : urls) {
            try {
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    ClassLoader bundleClassLoader = (ClassLoader)message.get("bundleClassLoader");
                    if (bundleClassLoader != null) {
                        ClassLoader aggregateClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)contextClassLoader, (ClassLoader[])new ClassLoader[]{bundleClassLoader});
                        currentThread.setContextClassLoader(aggregateClassLoader);
                    }
                    this._scripting.exec(null, new HashMap(), scriptingLanguage, StringUtil.read((InputStream)inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to execute script " + url.getFile()), (Throwable)exception);
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }
}

