/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scripting.executor.internal.extender;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSender;
import com.liferay.portal.kernel.messaging.sender.SingleDestinationMessageSenderFactory;
import com.liferay.portal.kernel.scripting.ScriptingExecutor;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.scripting.ScriptBundleProvider;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class ScriptingExecutorExtender {
    private static final String _SCRIPTS_DIR = "/META-INF/resources/scripts/";
    private static final Log _log = LogFactoryUtil.getLog(ScriptingExecutorExtender.class);
    private BundleContext _bundleContext;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Portal _portal;
    private final Set<String> _scriptingLanguages = new HashSet<String>();
    private ServiceTracker<ScriptBundleProvider, ScriptBundleProvider> _serviceTracker;
    private SingleDestinationMessageSender _singleDestinationMessageSender;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._serviceTracker = ServiceTrackerFactory.create((BundleContext)bundleContext, ScriptBundleProvider.class, (ServiceTrackerCustomizer)new ScriptBundleProviderServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeScriptingExecutor")
    protected void addScriptingExecutor(ScriptingExecutor scriptingExecutor) {
        this._scriptingLanguages.add(scriptingExecutor.getLanguage());
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
        this._bundleContext = null;
        this._singleDestinationMessageSender = null;
        this._serviceTracker = null;
    }

    protected void removeScriptingExecutor(ScriptingExecutor scriptingExecutor) {
        this._scriptingLanguages.remove(scriptingExecutor.getLanguage());
    }

    @Reference(target="(destination.name=liferay/scripting_executor)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    @Reference(unbind="-")
    protected void setSingleDestinationMessageSenderFactory(SingleDestinationMessageSenderFactory singleDestinationMessageSenderFactory) {
        this._singleDestinationMessageSender = singleDestinationMessageSenderFactory.createSingleDestinationMessageSender("liferay/scripting_executor");
    }

    private class ScriptBundleProviderServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ScriptBundleProvider, ScriptBundleProvider> {
        private ScriptBundleProviderServiceTrackerCustomizer() {
        }

        public ScriptBundleProvider addingService(ServiceReference<ScriptBundleProvider> serviceReference) {
            ScriptBundleProvider scriptBundleProvider = (ScriptBundleProvider)ScriptingExecutorExtender.this._bundleContext.getService(serviceReference);
            Bundle bundle = scriptBundleProvider.getBundle();
            Dictionary headers = bundle.getHeaders();
            if (GetterUtil.getBoolean((String)((String)headers.get("Liferay-Scripting-Executor-Cluster-Master-Only"))) && !ScriptingExecutorExtender.this._clusterMasterExecutor.isMaster()) {
                return null;
            }
            String scriptingLanguage = (String)headers.get("Liferay-Scripting-Executor-Scripting-Language");
            if (scriptingLanguage == null) {
                scriptingLanguage = "groovy";
            }
            if (!ScriptingExecutorExtender.this._scriptingLanguages.contains(scriptingLanguage)) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((String[])new String[]{"No ", scriptingLanguage, " executors available to process scripts from ", bundle.getSymbolicName()}));
                }
                return null;
            }
            Enumeration enumeration = bundle.findEntries(ScriptingExecutorExtender._SCRIPTS_DIR, "*", true);
            if (enumeration == null || !enumeration.hasMoreElements()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("No scripts in bundle " + bundle.getSymbolicName()));
                }
                return null;
            }
            Message message = new Message();
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            ClassLoader bundleClassLoader = bundleWiring.getClassLoader();
            message.put("bundleClassLoader", (Object)bundleClassLoader);
            message.put("scriptingLanguage", (Object)scriptingLanguage);
            ArrayList scriptURLs = new ArrayList();
            while (enumeration.hasMoreElements()) {
                scriptURLs.add(enumeration.nextElement());
            }
            message.put("urls", scriptURLs);
            ScriptingExecutorExtender.this._singleDestinationMessageSender.send(message);
            return null;
        }

        public void modifiedService(ServiceReference<ScriptBundleProvider> serviceReference, ScriptBundleProvider scriptBundleProvider) {
        }

        public void removedService(ServiceReference<ScriptBundleProvider> serviceReference, ScriptBundleProvider scriptBundleProvider) {
        }
    }
}

