/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.multiple.internal;

import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterLink;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.scheduler.multiple.internal.ClusterSchedulerEngine;
import com.liferay.portal.scheduler.multiple.internal.ClusterableProxyFactory;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ClusterSchedulerEngineConfigurator.class})
public class ClusterSchedulerEngineConfigurator {
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private ClusterLink _clusterLink;
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private Props _props;
    @Reference(target="(scheduler.engine.proxy=false)")
    private SchedulerEngine _schedulerEngine;
    private volatile ServiceRegistration<SchedulerEngine> _schedulerEngineServiceRegistration;
    private ServiceRegistration<IdentifiableOSGiService> _serviceRegistration;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    protected void activate(BundleContext bundleContext) {
        SchedulerEngine schedulerEngine = this._schedulerEngine;
        if (this._clusterLink.isEnabled()) {
            ClusterSchedulerEngine clusterSchedulerEngine = new ClusterSchedulerEngine(schedulerEngine, this._triggerFactory);
            clusterSchedulerEngine.setClusterExecutor(this._clusterExecutor);
            clusterSchedulerEngine.setClusterMasterExecutor(this._clusterMasterExecutor);
            clusterSchedulerEngine.setProps(this._props);
            this._serviceRegistration = bundleContext.registerService(IdentifiableOSGiService.class, (Object)clusterSchedulerEngine, (Dictionary)new HashMapDictionary());
            schedulerEngine = ClusterableProxyFactory.createClusterableProxy(clusterSchedulerEngine);
        }
        this._schedulerEngineServiceRegistration = bundleContext.registerService(SchedulerEngine.class, (Object)schedulerEngine, (Dictionary)HashMapDictionaryBuilder.put((Object)"scheduler.engine.proxy", (Object)Boolean.TRUE).build());
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
        if (this._schedulerEngineServiceRegistration != null) {
            this._schedulerEngineServiceRegistration.unregister();
        }
    }
}

