/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.scheduler.multiple.internal;

import com.liferay.portal.kernel.cluster.BaseClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.cluster.ClusterMasterTokenTransitionListener;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.ClusterableContextThreadLocal;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngine;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.servlet.PluginContextLifecycleThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.scheduler.multiple.internal.SchedulerClusterInvokeAcceptor;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClusterSchedulerEngine
implements IdentifiableOSGiService,
SchedulerEngine {
    protected static final String PLUGIN_READY = "plugin.ready";
    protected static final String PORTAL_READY = "portal.ready";
    private static final Log _log = LogFactoryUtil.getLog(ClusterSchedulerEngine.class);
    private static final MethodKey _addMemoryClusteredJobMethodKey = new MethodKey(ClusterSchedulerEngine.class, "_addMemoryClusteredJob", new Class[]{SchedulerResponse.class, String.class});
    private static final MethodKey _getScheduledJobMethodKey = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJob", new Class[]{String.class, String.class, StorageType.class});
    private static final MethodKey _getScheduledJobsMethodKey = new MethodKey(SchedulerEngineHelperUtil.class, "getScheduledJobs", new Class[]{StorageType.class});
    private static final MethodKey _reloadMemoryClusteredJobsMethodKey = new MethodKey(ClusterSchedulerEngine.class, "_reloadMemoryClusteredJobs", new Class[]{String.class});
    private long _callMasterTimeout;
    private ClusterExecutor _clusterExecutor;
    private ClusterMasterExecutor _clusterMasterExecutor;
    private final Map<String, ObjectValuePair<SchedulerResponse, TriggerState>> _memoryClusteredJobs = new ConcurrentHashMap<String, ObjectValuePair<SchedulerResponse, TriggerState>>();
    private boolean _portalReady;
    private Props _props;
    private final Lock _readLock;
    private ClusterMasterTokenTransitionListener _schedulerClusterMasterTokenTransitionListener;
    private final SchedulerEngine _schedulerEngine;
    private final TriggerFactory _triggerFactory;
    private final Lock _writeLock;

    public ClusterSchedulerEngine(SchedulerEngine schedulerEngine, TriggerFactory triggerFactory) {
        this._schedulerEngine = schedulerEngine;
        this._triggerFactory = triggerFactory;
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void delete(String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.delete(groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void delete(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.delete(jobName, groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    public String getOSGiServiceIdentifier() {
        return ClusterSchedulerEngine.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(onMaster=true)
    public SchedulerResponse getScheduledJob(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._readLock.lock();
        try {
            SchedulerResponse schedulerResponse = this._schedulerEngine.getScheduledJob(jobName, groupName, storageType);
            return schedulerResponse;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Clusterable(onMaster=true)
    public List<SchedulerResponse> getScheduledJobs() throws SchedulerException {
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs();
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    @Clusterable(onMaster=true)
    public List<SchedulerResponse> getScheduledJobs(StorageType storageType) throws SchedulerException {
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs(storageType);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(onMaster=true)
    public List<SchedulerResponse> getScheduledJobs(String groupName, StorageType storageType) throws SchedulerException {
        this._readLock.lock();
        try {
            List list = this._schedulerEngine.getScheduledJobs(groupName, storageType);
            return list;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void pause(String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.PAUSED);
            } else {
                this._schedulerEngine.pause(groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.PAUSED);
            } else {
                this._schedulerEngine.pause(jobName, groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void resume(String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJobs(groupName, TriggerState.NORMAL);
            } else {
                this._schedulerEngine.resume(groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.updateMemoryClusteredJob(jobName, groupName, TriggerState.NORMAL);
            } else {
                this._schedulerEngine.resume(jobName, groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void schedule(Trigger trigger, String description, String destinationName, Message message, StorageType storageType) throws SchedulerException {
        block10: {
            this._readLock.lock();
            try {
                if (storageType == StorageType.MEMORY_CLUSTERED) {
                    String groupName = trigger.getGroupName();
                    String jobName = trigger.getJobName();
                    if (this._clusterMasterExecutor.isMaster()) {
                        this._schedulerEngine.schedule(trigger, description, destinationName, message, storageType);
                        if (this._portalReady) {
                            SchedulerResponse schedulerResponse = new SchedulerResponse();
                            schedulerResponse.setDescription(description);
                            schedulerResponse.setDestinationName(destinationName);
                            schedulerResponse.setGroupName(groupName);
                            schedulerResponse.setJobName(jobName);
                            schedulerResponse.setMessage(message);
                            schedulerResponse.setStorageType(storageType);
                            schedulerResponse.setTrigger(trigger);
                            this._notifySlave(_addMemoryClusteredJobMethodKey, schedulerResponse, this.getOSGiServiceIdentifier());
                        }
                        break block10;
                    }
                    ObjectValuePair<SchedulerResponse, TriggerState> objectValuePair = this._memoryClusteredJobs.get(this.getFullName(jobName, groupName));
                    if (objectValuePair != null) break block10;
                    MethodHandler methodHandler = new MethodHandler(_getScheduledJobMethodKey, new Object[]{jobName, groupName, StorageType.MEMORY_CLUSTERED});
                    NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(methodHandler);
                    try {
                        SchedulerResponse schedulerResponse = (SchedulerResponse)future.get(this._callMasterTimeout, TimeUnit.SECONDS);
                        if (schedulerResponse == null || schedulerResponse.getTrigger() == null) {
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)"Memory clustered job is not yet deployed on master");
                            }
                            break block10;
                        }
                        this.addMemoryClusteredJob(schedulerResponse);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Unable to get a response from master", (Throwable)e);
                    }
                    break block10;
                }
                this._schedulerEngine.schedule(trigger, description, destinationName, message, storageType);
            }
            finally {
                this._readLock.unlock();
            }
        }
        this.setClusterableThreadLocal(storageType);
    }

    public void shutdown() throws SchedulerException {
        this._portalReady = false;
        this._clusterMasterExecutor.removeClusterMasterTokenTransitionListener(this._schedulerClusterMasterTokenTransitionListener);
        this._schedulerEngine.shutdown();
    }

    public void start() throws SchedulerException {
        if (!this._clusterMasterExecutor.isMaster()) {
            this.initMemoryClusteredJobs();
        }
        this._schedulerClusterMasterTokenTransitionListener = new SchedulerClusterMasterTokenTransitionListener();
        this._clusterMasterExecutor.addClusterMasterTokenTransitionListener(this._schedulerClusterMasterTokenTransitionListener);
        this._schedulerEngine.start();
        this._portalReady = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void suppressError(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        if (!memoryClusteredSlaveJob) {
            this._readLock.lock();
            try {
                this._schedulerEngine.suppressError(jobName, groupName, storageType);
            }
            finally {
                this._readLock.unlock();
            }
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void unschedule(String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this.removeMemoryClusteredJobs(groupName);
            } else {
                this._schedulerEngine.unschedule(groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void unschedule(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                this._memoryClusteredJobs.remove(this.getFullName(jobName, groupName));
            } else {
                this._schedulerEngine.unschedule(jobName, groupName, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Clusterable(acceptor=SchedulerClusterInvokeAcceptor.class)
    public void update(Trigger trigger, StorageType storageType) throws SchedulerException {
        String jobName = trigger.getJobName();
        String groupName = trigger.getGroupName();
        boolean memoryClusteredSlaveJob = this.isMemoryClusteredSlaveJob(storageType);
        this._readLock.lock();
        try {
            if (memoryClusteredSlaveJob) {
                boolean updated = false;
                for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
                    SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                    if (!jobName.equals(schedulerResponse.getJobName()) || !groupName.equals(schedulerResponse.getGroupName())) continue;
                    schedulerResponse.setTrigger(trigger);
                    updated = true;
                    break;
                }
                if (!updated) {
                    throw new SchedulerException("Unable to update trigger for memory clustered job");
                }
            } else {
                this._schedulerEngine.update(trigger, storageType);
            }
        }
        finally {
            this._readLock.unlock();
        }
        this.setClusterableThreadLocal(storageType);
    }

    public void validateTrigger(Trigger trigger, StorageType storageType) throws SchedulerException {
        this._schedulerEngine.validateTrigger(trigger, storageType);
    }

    protected void addMemoryClusteredJob(SchedulerResponse schedulerResponse) {
        String jobName = schedulerResponse.getJobName();
        String groupName = schedulerResponse.getGroupName();
        TriggerState triggerState = SchedulerEngineHelperUtil.getJobState((SchedulerResponse)schedulerResponse);
        Message message = schedulerResponse.getMessage();
        message.remove("JOB_STATE");
        this._memoryClusteredJobs.put(this.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)triggerState));
    }

    protected String getFullName(String jobName, String groupName) {
        return groupName.concat(".").concat(jobName);
    }

    protected void initMemoryClusteredJobs() {
        MethodHandler methodHandler = new MethodHandler(_getScheduledJobsMethodKey, new Object[]{StorageType.MEMORY_CLUSTERED});
        while (!this._clusterMasterExecutor.isMaster()) {
            try {
                NoticeableFuture future = this._clusterMasterExecutor.executeOnMaster(methodHandler);
                List schedulerResponses = (List)future.get(this._callMasterTimeout, TimeUnit.SECONDS);
                this._memoryClusteredJobs.clear();
                for (SchedulerResponse schedulerResponse : schedulerResponses) {
                    this.addMemoryClusteredJob(schedulerResponse);
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Load " + schedulerResponses.size() + " memory clustered jobs from master"));
                }
                return;
            }
            catch (InterruptedException ie) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Give up the master response waiting due to interruption", (Throwable)ie);
                }
                return;
            }
            catch (Exception e) {
                StringBundler sb = new StringBundler(5);
                sb.append("Unable to load memory clustered jobs from master in ");
                sb.append(this._callMasterTimeout);
                sb.append(" seconds, you might need to increase value set to ");
                sb.append("\"clusterable.advice.call.master.timeout\", will ");
                sb.append("retry again");
                _log.error((Object)sb.toString(), (Throwable)e);
            }
        }
    }

    protected boolean isMemoryClusteredSlaveJob(StorageType storageType) {
        return storageType == StorageType.MEMORY_CLUSTERED && !this._clusterMasterExecutor.isMaster();
    }

    protected void removeMemoryClusteredJobs(String groupName) {
        Set<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> memoryClusteredJobs = this._memoryClusteredJobs.entrySet();
        Iterator<Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>>> itr = memoryClusteredJobs.iterator();
        while (itr.hasNext()) {
            Map.Entry<String, ObjectValuePair<SchedulerResponse, TriggerState>> entry = itr.next();
            ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = entry.getValue();
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            itr.remove();
        }
    }

    protected void setClusterableThreadLocal(StorageType storageType) {
        ClusterableContextThreadLocal.putThreadLocalContext((String)"STORAGE_TYPE", (Serializable)storageType);
        ClusterableContextThreadLocal.putThreadLocalContext((String)PORTAL_READY, (Serializable)Boolean.valueOf(this._portalReady));
        boolean pluginReady = true;
        if (PluginContextLifecycleThreadLocal.isInitializing() || PluginContextLifecycleThreadLocal.isDestroying()) {
            pluginReady = false;
        }
        ClusterableContextThreadLocal.putThreadLocalContext((String)PLUGIN_READY, (Serializable)Boolean.valueOf(pluginReady));
    }

    protected void setClusterExecutor(ClusterExecutor clusterExecutor) {
        this._clusterExecutor = clusterExecutor;
    }

    protected void setClusterMasterExecutor(ClusterMasterExecutor clusterMasterExecutor) {
        this._clusterMasterExecutor = clusterMasterExecutor;
    }

    protected void setProps(Props props) {
        this._props = props;
        this._callMasterTimeout = GetterUtil.getLong((String)this._props.get("clusterable.advice.call.master.timeout"));
    }

    protected void updateMemoryClusteredJob(String jobName, String groupName, TriggerState triggerState) {
        ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob = this._memoryClusteredJobs.get(this.getFullName(jobName, groupName));
        if (memoryClusteredJob != null) {
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    protected void updateMemoryClusteredJobs(String groupName, TriggerState triggerState) {
        for (ObjectValuePair<SchedulerResponse, TriggerState> memoryClusteredJob : this._memoryClusteredJobs.values()) {
            SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
            if (!groupName.equals(schedulerResponse.getGroupName())) continue;
            memoryClusteredJob.setValue((Object)triggerState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _addMemoryClusteredJob(SchedulerResponse schedulerResponse, String osgiServiceIdentifier) throws Exception {
        ClusterSchedulerEngine clusterSchedulerEngine = (ClusterSchedulerEngine)IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)osgiServiceIdentifier);
        if (!clusterSchedulerEngine._portalReady) {
            return;
        }
        String jobName = schedulerResponse.getJobName();
        String groupName = schedulerResponse.getGroupName();
        Lock writeLock = clusterSchedulerEngine._writeLock;
        writeLock.lock();
        try {
            Map<String, ObjectValuePair<SchedulerResponse, TriggerState>> memoryClusteredJobs = clusterSchedulerEngine._memoryClusteredJobs;
            memoryClusteredJobs.put(clusterSchedulerEngine.getFullName(jobName, groupName), (ObjectValuePair<SchedulerResponse, TriggerState>)new ObjectValuePair((Object)schedulerResponse, (Object)TriggerState.NORMAL));
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Receive notification from master, add memory clustered job " + schedulerResponse));
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _reloadMemoryClusteredJobs(String osgiServiceIdentifier) throws Exception {
        ClusterSchedulerEngine clusterSchedulerEngine = (ClusterSchedulerEngine)IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)osgiServiceIdentifier);
        if (!clusterSchedulerEngine._portalReady) {
            return;
        }
        ClusterMasterExecutor clusterMasterExecutor = clusterSchedulerEngine._clusterMasterExecutor;
        if (clusterMasterExecutor.isMaster()) {
            return;
        }
        Lock writeLock = clusterSchedulerEngine._writeLock;
        writeLock.lock();
        try {
            clusterSchedulerEngine.initMemoryClusteredJobs();
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Receive notification from master, reload memory clustered jobs");
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void _notifySlave(MethodKey methodKey, Object ... arguments) {
        try {
            MethodHandler methodHandler = new MethodHandler(methodKey, arguments);
            ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
            clusterRequest.setFireAndForget(true);
            this._clusterExecutor.execute(clusterRequest);
        }
        catch (Throwable t) {
            _log.error((Object)"Unable to notify slave", t);
        }
    }

    private class SchedulerClusterMasterTokenTransitionListener
    extends BaseClusterMasterTokenTransitionListener {
        private SchedulerClusterMasterTokenTransitionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doMasterTokenAcquired() throws Exception {
            boolean forceSync = ProxyModeThreadLocal.isForceSync();
            ProxyModeThreadLocal.setForceSync((boolean)true);
            ClusterSchedulerEngine.this._writeLock.lock();
            try {
                for (ObjectValuePair memoryClusteredJob : ClusterSchedulerEngine.this._memoryClusteredJobs.values()) {
                    SchedulerResponse schedulerResponse = (SchedulerResponse)memoryClusteredJob.getKey();
                    Trigger oldTrigger = schedulerResponse.getTrigger();
                    Date startDate = oldTrigger.getFireDateAfter(new Date());
                    Trigger newTrigger = ClusterSchedulerEngine.this._triggerFactory.createTrigger(oldTrigger, startDate, oldTrigger.getEndDate());
                    ClusterSchedulerEngine.this._schedulerEngine.schedule(newTrigger, schedulerResponse.getDescription(), schedulerResponse.getDestinationName(), schedulerResponse.getMessage(), schedulerResponse.getStorageType());
                    TriggerState triggerState = (TriggerState)memoryClusteredJob.getValue();
                    if (!triggerState.equals((Object)TriggerState.PAUSED)) continue;
                    ClusterSchedulerEngine.this._schedulerEngine.pause(schedulerResponse.getJobName(), schedulerResponse.getGroupName(), schedulerResponse.getStorageType());
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(ClusterSchedulerEngine.this._memoryClusteredJobs.size() + " MEMORY_CLUSTERED jobs started running on this node"));
                }
                ClusterSchedulerEngine.this._memoryClusteredJobs.clear();
                ClusterSchedulerEngine.this._notifySlave(_reloadMemoryClusteredJobsMethodKey, new Object[]{ClusterSchedulerEngine.this.getOSGiServiceIdentifier()});
            }
            finally {
                ProxyModeThreadLocal.setForceSync((boolean)forceSync);
                ClusterSchedulerEngine.this._writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doMasterTokenReleased() throws Exception {
            ClusterSchedulerEngine.this._writeLock.lock();
            try {
                ClusterSchedulerEngine.this.initMemoryClusteredJobs();
                if (ClusterSchedulerEngine.this._clusterMasterExecutor.isMaster()) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)"Current node is elected as master again, stop transferring it to slave, all jobs running on current node will keep running");
                    }
                    return;
                }
                List schedulerResponses = ClusterSchedulerEngine.this._schedulerEngine.getScheduledJobs(StorageType.MEMORY_CLUSTERED);
                for (SchedulerResponse schedulerResponse : schedulerResponses) {
                    ClusterSchedulerEngine.this._schedulerEngine.delete(schedulerResponse.getJobName(), schedulerResponse.getGroupName(), schedulerResponse.getStorageType());
                }
                if (_log.isInfoEnabled()) {
                    _log.info((Object)(schedulerResponses.size() + " MEMORY_CLUSTERED jobs stopped running on this node"));
                }
                ClusterSchedulerEngine.this._notifySlave(_reloadMemoryClusteredJobsMethodKey, new Object[]{ClusterSchedulerEngine.this.getOSGiServiceIdentifier()});
            }
            finally {
                ClusterSchedulerEngine.this._writeLock.unlock();
            }
        }
    }
}

