/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.rules.engine.wiring.internal.messaging;

import com.liferay.portal.kernel.concurrent.CallerRunsPolicy;
import com.liferay.portal.kernel.concurrent.RejectedExecutionHandler;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.proxy.ProxyMessageListener;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public class RulesEngineMessagingConfigurator {
    private static final int _MAXIMUM_QUEUE_SIZE = 20;
    private static final Log _log = LogFactoryUtil.getLog(RulesEngineMessagingConfigurator.class);
    private BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private volatile ServiceRegistration<Destination> _destinationServiceRegistration;
    @Reference(service=ProxyMessageListener.class, target="(destination.name=liferay/rules_engine)")
    private ProxyMessageListener _proxyMessageListener;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/rules_engine");
        destinationConfiguration.setMaximumQueueSize(20);
        CallerRunsPolicy rejectedExecutionHandler = new CallerRunsPolicy(){

            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the rules engine's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary destinationProperties = new HashMapDictionary();
        destinationProperties.put("destination.name", destination.getName());
        this._destinationServiceRegistration = this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)destinationProperties);
        destination.register((MessageListener)this._proxyMessageListener);
    }

    @Deactivate
    protected void deactivate() {
        if (this._destinationServiceRegistration != null) {
            Destination destination = (Destination)this._bundleContext.getService(this._destinationServiceRegistration.getReference());
            this._destinationServiceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }
}

