/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.rules.engine.sample.web.internal.portlet.action;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.resource.ResourceRetriever;
import com.liferay.portal.kernel.resource.StringResourceRetriever;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.rules.engine.RulesEngine;
import com.liferay.portal.rules.engine.RulesEngineException;
import com.liferay.portal.rules.engine.RulesLanguage;
import com.liferay.portal.rules.engine.RulesResourceRetriever;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_portal_rules_engine_sample_web_portlet_SampleDroolsPortlet"}, service={ConfigurationAction.class})
public class SampleDroolsConfigurationAction
extends DefaultConfigurationAction {
    private static final Log _log = LogFactoryUtil.getLog(SampleDroolsConfigurationAction.class);
    @Reference
    private Portal _portal;
    @Reference
    private RulesEngine _rulesEngine;

    public String getJspPath(HttpServletRequest request) {
        return "/configuration.jsp";
    }

    public void processAction(PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        if (!cmd.equals("update")) {
            return;
        }
        PortletPreferences preferences = actionRequest.getPreferences();
        this.updatePreferences(actionRequest, preferences);
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.store();
            SessionMessages.add((PortletRequest)actionRequest, (String)(this._portal.getPortletId((PortletRequest)actionRequest) + ".updatedConfiguration"));
        }
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.portal.rules.engine.sample.web)", unbind="-")
    public void setServletContext(ServletContext servletContext) {
        super.setServletContext(servletContext);
    }

    protected void updatePreferences(ActionRequest actionRequest, PortletPreferences preferences) throws Exception {
        String domainName = ParamUtil.getString((PortletRequest)actionRequest, (String)"domainName");
        String rules = ParamUtil.getString((PortletRequest)actionRequest, (String)"rules");
        String userCustomAttributeNames = ParamUtil.getString((PortletRequest)actionRequest, (String)"userCustomAttributeNames");
        long[] classNameIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"classNameIds"), (long)0L);
        if (Validator.isNull((String)domainName)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"domainName");
        } else if (Validator.isNull((String)rules)) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"rules");
        } else if (classNameIds.length == 0) {
            SessionErrors.add((PortletRequest)actionRequest, (String)"classNameIds");
        } else {
            RulesResourceRetriever rulesResourceRetriever = new RulesResourceRetriever((ResourceRetriever)new StringResourceRetriever(rules), String.valueOf(RulesLanguage.DROOLS_RULE_LANGUAGE));
            try {
                this._rulesEngine.update(domainName, rulesResourceRetriever);
            }
            catch (RulesEngineException ree) {
                _log.error((Object)ree, (Throwable)ree);
                SessionErrors.add((PortletRequest)actionRequest, (String)"rulesEngineException");
            }
        }
        if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
            preferences.setValue("rules", rules);
            preferences.setValue("domain-name", domainName);
            preferences.setValue("user-custom-attribute-names", userCustomAttributeNames);
            preferences.setValues("class-name-ids", ArrayUtil.toStringArray((long[])classNameIds));
        }
    }
}

