/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.rules.engine;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.rules.engine.QueryType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Query
implements Serializable {
    private final List<Object> _arguments = new ArrayList<Object>();
    private final String _identifier;
    private final String _queryName;
    private final QueryType _queryType;

    public static Query createCustomQuery(String identifier, String queryName) {
        if (Validator.isNull((String)identifier)) {
            throw new IllegalArgumentException("Query idenfier is null");
        }
        if (Validator.isNull((String)queryName)) {
            throw new IllegalArgumentException("Query string is null");
        }
        return new Query(identifier, QueryType.CUSTOM, queryName);
    }

    public static Query createStandardQuery() {
        return new Query(null, QueryType.STANDARD, null);
    }

    public void addArgument(Object object) {
        if (this._queryType.equals((Object)QueryType.STANDARD)) {
            throw new IllegalStateException("Standard queries cannot accept query arguments");
        }
        this._arguments.add(object);
    }

    public void addArguments(List<?> arguments) {
        if (this._queryType.equals((Object)QueryType.STANDARD)) {
            throw new IllegalStateException("Standard queries cannot accept query arguments");
        }
        this._arguments.addAll(arguments);
    }

    public void addArguments(Object[] arguments) {
        if (this._queryType.equals((Object)QueryType.STANDARD)) {
            throw new IllegalStateException("Standard queries cannot accept query arguments");
        }
        if (ArrayUtil.isNotEmpty((Object[])arguments)) {
            Collections.addAll(this._arguments, arguments);
        }
    }

    public Object[] getArguments() {
        return this._arguments.toArray(new Object[this._arguments.size()]);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public String getQueryName() {
        return this._queryName;
    }

    public QueryType getQueryType() {
        return this._queryType;
    }

    private Query(String identifier, QueryType queryType, String queryName) {
        this._identifier = identifier;
        this._queryType = queryType;
        this._queryName = queryName;
    }
}

