/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.rules.engine;

import java.util.List;
import java.util.Map;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Michael C. Han
 * @author Raymond Augé
 * @deprecated As of 7.0.0
 */
@Component(immediate = true, service = RulesEngineUtil.class)
public class RulesEngineUtil {

	public static void add(
			String domainName, RulesResourceRetriever rulesResourceRetriever)
		throws RulesEngineException {

		getRulesEngine().add(domainName, rulesResourceRetriever);
	}

	public static boolean containsRuleDomain(String domainName)
		throws RulesEngineException {

		return getRulesEngine().containsRuleDomain(domainName);
	}

	public static void execute(
			RulesResourceRetriever rulesResourceRetriever, List<Fact<?>> facts)
		throws RulesEngineException {

		getRulesEngine().execute(rulesResourceRetriever, facts);
	}

	public static Map<String, ?> execute(
			RulesResourceRetriever rulesResourceRetriever, List<Fact<?>> facts,
			Query query)
		throws RulesEngineException {

		return getRulesEngine().execute(rulesResourceRetriever, facts, query);
	}

	public static void execute(String domainName, List<Fact<?>> facts)
		throws RulesEngineException {

		getRulesEngine().execute(domainName, facts);
	}

	public static Map<String, ?> execute(
			String domainName, List<Fact<?>> facts, Query query)
		throws RulesEngineException {

		return getRulesEngine().execute(domainName, facts, query);
	}

	public static RulesEngine getRulesEngine() {
		return _rulesEngine;
	}

	public static void remove(String domainName) throws RulesEngineException {
		getRulesEngine().remove(domainName);
	}

	public static void update(
			String domainName, RulesResourceRetriever rulesResourceRetriever)
		throws RulesEngineException {

		getRulesEngine().update(domainName, rulesResourceRetriever);
	}

	@Reference
	private static RulesEngine _rulesEngine;

}