/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.debug.osgi.commands;

import com.liferay.osgi.util.StringPlus;
import com.liferay.osgi.util.osgi.commands.OSGiCommands;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.remote.jaxrs.whiteboard.lifecycle.JAXRSLifecycle;
import java.util.Arrays;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.BaseDTO;
import org.osgi.service.jaxrs.runtime.dto.ExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;

@Component(property={"osgi.command.function=check", "osgi.command.scope=jaxrs"}, service={OSGiCommands.class})
public class JaxRsServiceRuntimeOSGiCommands
implements OSGiCommands {
    private static final Snapshot<JaxrsServiceRuntime> _jaxrsServiceRuntimeSnapshot = new Snapshot(JaxRsServiceRuntimeOSGiCommands.class, JaxrsServiceRuntime.class);
    private BundleContext _bundleContext;
    @Reference
    private JAXRSLifecycle _jaxrsLifecycle;

    /*
     * WARNING - void declaration
     */
    public void check() {
        void var6_12;
        this._jaxrsLifecycle.ensureReady();
        JaxrsServiceRuntime jaxrsServiceRuntime = (JaxrsServiceRuntime)_jaxrsServiceRuntimeSnapshot.get();
        RuntimeDTO runtimeDTO = jaxrsServiceRuntime.getRuntimeDTO();
        if (runtimeDTO.defaultApplication != null) {
            System.out.println();
            this.printApplicationDTO(runtimeDTO.defaultApplication);
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
            System.out.println();
            this.printApplicationDTO(applicationDTO);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeDTO.failedApplicationDTOs)) {
            System.out.println();
            System.out.println("Failed application report:");
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.failedApplicationDTOs) {
            this.printFailedApplicationDTO((FailedApplicationDTO)applicationDTO, runtimeDTO.applicationDTOs);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeDTO.failedExtensionDTOs)) {
            System.out.println();
            System.out.println("Extensions report:");
        }
        HashSet<ExtensionDTO> extensionDTOsSet = new HashSet<ExtensionDTO>();
        ApplicationDTO[] applicationDTOArray = runtimeDTO.applicationDTOs;
        int n = applicationDTOArray.length;
        boolean bl = false;
        while (var6_12 < n) {
            ApplicationDTO applicationDTO = applicationDTOArray[var6_12];
            for (ExtensionDTO extensionDTO : applicationDTO.extensionDTOs) {
                extensionDTOsSet.add(extensionDTO);
            }
            ++var6_12;
        }
        ExtensionDTO[] extensionDTOS = extensionDTOsSet.toArray(new ExtensionDTO[0]);
        for (FailedExtensionDTO failedExtensionDTO : runtimeDTO.failedExtensionDTOs) {
            this.printFailedExtensionDTO(failedExtensionDTO, extensionDTOS);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeDTO.failedResourceDTOs)) {
            System.out.println();
            System.out.println("Resources report:");
            HashSet<ResourceDTO> resourceDTOsSet = new HashSet<ResourceDTO>();
            for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
                for (ResourceDTO resourceDTO : applicationDTO.resourceDTOs) {
                    resourceDTOsSet.add(resourceDTO);
                }
            }
            ResourceDTO[] resourceDTOArray = resourceDTOsSet.toArray(new ResourceDTO[0]);
            for (FailedResourceDTO failedResourceDTO : runtimeDTO.failedResourceDTOs) {
                this.printFailedResourceDTO(failedResourceDTO, resourceDTOArray);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected BaseDTO getDTOByName(BaseDTO[] applicationDTOS, String jaxRsName) {
        for (BaseDTO applicationDTO : applicationDTOS) {
            if (!jaxRsName.equals(applicationDTO.name)) continue;
            return applicationDTO;
        }
        return null;
    }

    protected ServiceReference<?> getServiceReference(long serviceId) {
        try {
            Object[] serviceReferences = this._bundleContext.getServiceReferences((String)null, "(service.id=" + serviceId + ")");
            if (ArrayUtil.isEmpty((Object[])serviceReferences)) {
                return null;
            }
            return serviceReferences[0];
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new IllegalArgumentException(invalidSyntaxException);
        }
    }

    protected void printApplicationDTO(ApplicationDTO applicationDTO) {
        System.out.println(StringBundler.concat((Object[])new Object[]{"Application ", applicationDTO.name, " (", applicationDTO.serviceId, ") ", applicationDTO.base}));
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.resourceMethods)) {
            System.out.println();
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.resourceMethods) {
            this._printResourceMethodInfoDTO("    ", resourceMethodInfoDTO);
        }
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.extensionDTOs)) {
            System.out.println();
            System.out.println("    Attached extensions:");
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.extensionDTOs) {
            System.out.println(StringBundler.concat((Object[])new Object[]{"        ", resourceMethodInfoDTO.name, " (", resourceMethodInfoDTO.serviceId, ")"}));
        }
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.resourceDTOs)) {
            System.out.println();
            System.out.println("    Attached resources:");
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.resourceDTOs) {
            System.out.println(StringBundler.concat((Object[])new Object[]{"        ", resourceMethodInfoDTO.name, " (", resourceMethodInfoDTO.serviceId, ")"}));
            for (ResourceMethodInfoDTO resourceMethodInfoDTO2 : resourceMethodInfoDTO.resourceMethods) {
                this._printResourceMethodInfoDTO("            ", resourceMethodInfoDTO2);
            }
        }
    }

    protected void printFailedApplicationDTO(FailedApplicationDTO failedApplicationDTO, ApplicationDTO[] applicationDTOS) {
        StringBundler sb = new StringBundler(8);
        sb.append("    Application with service ID ");
        sb.append(failedApplicationDTO.serviceId);
        ServiceReference<?> serviceReference = this.getServiceReference(failedApplicationDTO.serviceId);
        String jaxRsName = GetterUtil.getString((Object)serviceReference.getProperty("osgi.jaxrs.name"));
        if (Validator.isNotNull((String)jaxRsName)) {
            sb.append(" and name ");
            sb.append(jaxRsName);
        }
        if (failedApplicationDTO.failureReason == 6) {
            sb.append(" is clashing with another service");
            BaseDTO applicationDTOByName = this.getDTOByName((BaseDTO[])applicationDTOS, jaxRsName);
            if (applicationDTOByName != null) {
                sb.append(" (");
                sb.append(applicationDTOByName.serviceId);
                sb.append(")");
            }
        } else if (failedApplicationDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions: ");
            sb.append((Object)StringPlus.asList((Object)serviceReference.getProperty("osgi.jaxrs.extension.select")));
        } else if (failedApplicationDTO.failureReason == 1) {
            sb.append(" is shadowed by another application (");
            sb.append(failedApplicationDTO.base);
            sb.append(")");
        } else if (failedApplicationDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedApplicationDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        }
        System.out.println(sb.toString());
    }

    protected void printFailedExtensionDTO(FailedExtensionDTO failedExtensionDTO, ExtensionDTO[] extensionDTOS) {
        StringBundler sb = new StringBundler(9);
        sb.append("    Extension ");
        sb.append(failedExtensionDTO.name);
        sb.append(" (");
        sb.append(failedExtensionDTO.serviceId);
        sb.append(")");
        if (failedExtensionDTO.failureReason == 6) {
            sb.append(" is clashing with another service");
            BaseDTO baseDTO = this.getDTOByName((BaseDTO[])extensionDTOS, failedExtensionDTO.name);
            if (baseDTO != null) {
                sb.append(" (");
                sb.append(failedExtensionDTO.serviceId);
                sb.append(")");
            }
        } else if (failedExtensionDTO.failureReason == 4) {
            sb.append(" is not a valid extension type");
        } else if (failedExtensionDTO.failureReason == 7) {
            sb.append(" is waiting for an application: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedExtensionDTO.serviceId);
            if (serviceReference != null) {
                sb.append(serviceReference.getProperty("osgi.jaxrs.application.select"));
            }
        } else if (failedExtensionDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedExtensionDTO.serviceId);
            if (serviceReference != null) {
                sb.append((Object)StringPlus.asList((Object)serviceReference.getProperty("osgi.jaxrs.extension.select")));
            }
        } else if (failedExtensionDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedExtensionDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        } else if (failedExtensionDTO.failureReason == 3) {
            sb.append(" has failed property validation");
        }
        System.out.println(sb.toString());
    }

    protected void printFailedResourceDTO(FailedResourceDTO failedResourceDTO, ResourceDTO[] resourceDTOS) {
        StringBundler sb = new StringBundler(9);
        sb.append("    Resource ");
        sb.append(failedResourceDTO.name);
        sb.append(" (");
        sb.append(failedResourceDTO.serviceId);
        sb.append(")");
        if (failedResourceDTO.failureReason == 6) {
            sb.append(" is clashing with another service");
            BaseDTO baseDTO = this.getDTOByName((BaseDTO[])resourceDTOS, failedResourceDTO.name);
            if (baseDTO != null) {
                sb.append(" (");
                sb.append(failedResourceDTO.serviceId);
                sb.append(")");
            }
        } else if (failedResourceDTO.failureReason == 7) {
            sb.append(" is waiting for an application: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedResourceDTO.serviceId);
            if (serviceReference != null) {
                sb.append(serviceReference.getProperty("osgi.jaxrs.application.select"));
            }
        } else if (failedResourceDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedResourceDTO.serviceId);
            if (serviceReference != null) {
                sb.append((Object)StringPlus.asList((Object)serviceReference.getProperty("osgi.jaxrs.extension.select")));
            }
        } else if (failedResourceDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedResourceDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        } else if (failedResourceDTO.failureReason == 3) {
            sb.append(" has failed property validation");
        }
        System.out.println(sb.toString());
    }

    private void _printResourceMethodInfoDTO(String prefix, ResourceMethodInfoDTO resourceMethodInfoDTO) {
        System.out.println(StringBundler.concat((String[])new String[]{prefix, resourceMethodInfoDTO.method, " ", resourceMethodInfoDTO.path, " Consumes: ", Arrays.toString(resourceMethodInfoDTO.consumingMimeType), " Produces: ", Arrays.toString(resourceMethodInfoDTO.producingMimeType)}));
    }
}

