/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.whiteboard.debug.osgi.commands;

import com.liferay.osgi.util.StringPlus;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Arrays;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.runtime.JaxrsServiceRuntime;
import org.osgi.service.jaxrs.runtime.dto.ApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedApplicationDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedExtensionDTO;
import org.osgi.service.jaxrs.runtime.dto.FailedResourceDTO;
import org.osgi.service.jaxrs.runtime.dto.ResourceMethodInfoDTO;
import org.osgi.service.jaxrs.runtime.dto.RuntimeDTO;

@Component(immediate=true, property={"osgi.command.function=check", "osgi.command.scope=jaxrs"}, service={JaxRsServiceRuntimeOSGiCommands.class})
public class JaxRsServiceRuntimeOSGiCommands {
    private BundleContext _bundleContext;
    @Reference
    private JaxrsServiceRuntime _jaxrsServiceRuntime;

    public void check() {
        RuntimeDTO runtimeDTO = this._jaxrsServiceRuntime.getRuntimeDTO();
        if (runtimeDTO.defaultApplication != null) {
            System.out.println();
            this.printApplicationDTO(runtimeDTO.defaultApplication);
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.applicationDTOs) {
            System.out.println();
            this.printApplicationDTO(applicationDTO);
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.failedApplicationDTOs) {
            this.printFailedApplicationDTO((FailedApplicationDTO)applicationDTO);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeDTO.failedExtensionDTOs)) {
            System.out.println();
            System.out.println("Extensions report:");
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.failedExtensionDTOs) {
            this.printFailedExtensionDTO((FailedExtensionDTO)applicationDTO);
        }
        if (ArrayUtil.isNotEmpty((Object[])runtimeDTO.failedResourceDTOs)) {
            System.out.println();
            System.out.println("Resources report:");
        }
        for (ApplicationDTO applicationDTO : runtimeDTO.failedResourceDTOs) {
            this.printFailedResourceDTO((FailedResourceDTO)applicationDTO);
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected ServiceReference<?> getServiceReference(long serviceId) {
        try {
            ServiceReference[] serviceReferences = this._bundleContext.getServiceReferences((String)null, "(service.id=" + serviceId + ")");
            if (serviceReferences == null || serviceReferences.length == 0) {
                return null;
            }
            return serviceReferences[0];
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
    }

    protected void printApplicationDTO(ApplicationDTO applicationDTO) {
        System.out.println(StringBundler.concat((Object[])new Object[]{"Application ", applicationDTO.name, " (", applicationDTO.serviceId, ") ", applicationDTO.base}));
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.resourceMethods)) {
            System.out.println();
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.resourceMethods) {
            this._printResourceMethodInfoDTO("    ", resourceMethodInfoDTO);
        }
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.extensionDTOs)) {
            System.out.println();
            System.out.println("    Attached extensions:");
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.extensionDTOs) {
            System.out.println(StringBundler.concat((Object[])new Object[]{"        ", resourceMethodInfoDTO.name, " (", resourceMethodInfoDTO.serviceId, ")"}));
        }
        if (ArrayUtil.isNotEmpty((Object[])applicationDTO.resourceDTOs)) {
            System.out.println();
            System.out.println("    Attached resources:");
        }
        for (ResourceMethodInfoDTO resourceMethodInfoDTO : applicationDTO.resourceDTOs) {
            System.out.println(StringBundler.concat((Object[])new Object[]{"        ", resourceMethodInfoDTO.name, " (", resourceMethodInfoDTO.serviceId, ")"}));
            for (ResourceMethodInfoDTO resourceMethodInfoDTO2 : resourceMethodInfoDTO.resourceMethods) {
                this._printResourceMethodInfoDTO("            ", resourceMethodInfoDTO2);
            }
        }
    }

    protected void printFailedApplicationDTO(FailedApplicationDTO failedApplicationDTO) {
        StringBundler sb = new StringBundler(5);
        sb.append("    Application with service ID ");
        sb.append(failedApplicationDTO.serviceId);
        if (failedApplicationDTO.failureReason == 6) {
            sb.append(" is clashing with another service (");
            sb.append(failedApplicationDTO.serviceId);
            sb.append(")");
        } else if (failedApplicationDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions");
        } else if (failedApplicationDTO.failureReason == 1) {
            sb.append(" is shadowed by another application (");
            sb.append(failedApplicationDTO.base);
            sb.append(")");
        } else if (failedApplicationDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedApplicationDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        }
        System.out.println(sb.toString());
    }

    protected void printFailedExtensionDTO(FailedExtensionDTO failedExtensionDTO) {
        StringBundler sb = new StringBundler(8);
        sb.append("    Extension ");
        sb.append(failedExtensionDTO.name);
        sb.append(" (");
        sb.append(failedExtensionDTO.serviceId);
        sb.append(")");
        if (failedExtensionDTO.failureReason == 6) {
            sb.append(" is clashing with another service (");
            sb.append(failedExtensionDTO.serviceId);
            sb.append(")");
        } else if (failedExtensionDTO.failureReason == 4) {
            sb.append(" is not a valid extension type");
        } else if (failedExtensionDTO.failureReason == 7) {
            sb.append(" is waiting for an application: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedExtensionDTO.serviceId);
            if (serviceReference != null) {
                sb.append(serviceReference.getProperty("osgi.jaxrs.application.select"));
            }
        } else if (failedExtensionDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedExtensionDTO.serviceId);
            if (serviceReference != null) {
                sb.append((Object)StringPlus.asList((Object)serviceReference.getProperty("osgi.jaxrs.extension.select")));
            }
        } else if (failedExtensionDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedExtensionDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        } else if (failedExtensionDTO.failureReason == 3) {
            sb.append(" has failed property validation");
        }
        System.out.println(sb.toString());
    }

    protected void printFailedResourceDTO(FailedResourceDTO failedResourceDTO) {
        StringBundler sb = new StringBundler(8);
        sb.append("    Resource ");
        sb.append(failedResourceDTO.name);
        sb.append(" (");
        sb.append(failedResourceDTO.serviceId);
        sb.append(")");
        if (failedResourceDTO.failureReason == 6) {
            sb.append(" is clashing with another service (");
            sb.append(failedResourceDTO.serviceId);
            sb.append(")");
        } else if (failedResourceDTO.failureReason == 7) {
            sb.append(" is waiting for an application: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedResourceDTO.serviceId);
            if (serviceReference != null) {
                sb.append(serviceReference.getProperty("osgi.jaxrs.application.select"));
            }
        } else if (failedResourceDTO.failureReason == 5) {
            sb.append(" has unresolved dependencies on extensions: ");
            ServiceReference<?> serviceReference = this.getServiceReference(failedResourceDTO.serviceId);
            if (serviceReference != null) {
                sb.append((Object)StringPlus.asList((Object)serviceReference.getProperty("osgi.jaxrs.extension.select")));
            }
        } else if (failedResourceDTO.failureReason == 2) {
            sb.append(" cannot be retrieved by the whiteboard");
        } else if (failedResourceDTO.failureReason == 0) {
            sb.append(" has failed for an unknown reason");
        } else if (failedResourceDTO.failureReason == 3) {
            sb.append(" has failed property validation");
        }
        System.out.println(sb.toString());
    }

    private void _printResourceMethodInfoDTO(String prefix, ResourceMethodInfoDTO resourceMethodInfoDTO) {
        System.out.println(StringBundler.concat((String[])new String[]{prefix, resourceMethodInfoDTO.method, " ", resourceMethodInfoDTO.path, " Consumes: ", Arrays.toString(resourceMethodInfoDTO.consumingMimeType), " Produces: ", Arrays.toString(resourceMethodInfoDTO.producingMimeType)}));
    }
}

