/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.security.internal.container.response.filter;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.security.access.control.AccessControlAdvisorImpl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(property={"osgi.jaxrs.application.select=(!(liferay.access.control.disable=true))", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.Access.Control"}, scope=ServiceScope.PROTOTYPE, service={ContainerRequestFilter.class, ContainerResponseFilter.class})
public class AccessControlledContainerRequestResponseFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final AccessControlled _NULL_ACCESS_CONTROLLED = new AccessControlled(){

        public Class<? extends Annotation> annotationType() {
            return AccessControlled.class;
        }

        public boolean guestAccessEnabled() {
            return false;
        }

        public boolean hostAllowedValidationEnabled() {
            return false;
        }
    };
    private final AccessControlAdvisor _accessControlAdvisor = new AccessControlAdvisorImpl();
    @Context
    private Request _request;
    @Context
    private ResourceInfo _resourceInfo;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        this._incrementServiceDepth();
        Method method = this._resourceInfo.getResourceMethod();
        AccessControlled accessControlled = (AccessControlled)AnnotationLocator.locate((Method)method, this._resourceInfo.getClass(), AccessControlled.class);
        if (accessControlled == null) {
            accessControlled = _NULL_ACCESS_CONTROLLED;
        }
        this._accessControlAdvisor.accept(method, new Object[0], accessControlled);
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        this._decrementServiceDepth();
    }

    private void _decrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            return;
        }
        Integer n = serviceDepth;
        Integer n2 = serviceDepth = Integer.valueOf(serviceDepth - 1);
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }

    private void _incrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            serviceDepth = 1;
        } else {
            Integer n = serviceDepth;
            Integer n2 = serviceDepth = Integer.valueOf(serviceDepth + 1);
        }
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }
}

