/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.jaxrs.security.internal.container;

import com.liferay.petra.reflect.AnnotationLocator;
import com.liferay.portal.kernel.security.access.control.AccessControlUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.remote.jaxrs.security.internal.entity.ForbiddenEntity;
import com.liferay.portal.security.access.control.AccessControlAdvisor;
import com.liferay.portal.security.access.control.AccessControlAdvisorImpl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(property={"osgi.jaxrs.application.select=(!(liferay.access.control.disable=true))", "osgi.jaxrs.extension=true", "osgi.jaxrs.name=Liferay.Access.Control"}, scope=ServiceScope.PROTOTYPE, service={ContainerRequestFilter.class, ContainerResponseFilter.class, ExceptionMapper.class})
public class AccessControlledContainerRequestResponseFilterExceptionMapper
implements ContainerRequestFilter,
ContainerResponseFilter,
ExceptionMapper<SecurityException> {
    private static final AccessControlled _NULL_ACCESS_CONTROLLED = new AccessControlled(){

        public Class<? extends Annotation> annotationType() {
            return AccessControlled.class;
        }

        public boolean guestAccessEnabled() {
            return false;
        }

        public boolean hostAllowedValidationEnabled() {
            return false;
        }
    };
    private final AccessControlAdvisor _accessControlAdvisor = new AccessControlAdvisorImpl();
    @Context
    private HttpHeaders _httpHeaders;
    @Context
    private Providers _providers;
    @Context
    private Request _request;
    @Context
    private ResourceInfo _resourceInfo;

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        this.incrementServiceDepth();
        Method method = this._resourceInfo.getResourceMethod();
        AccessControlled accessControlled = (AccessControlled)AnnotationLocator.locate((Method)method, this._resourceInfo.getClass(), AccessControlled.class);
        if (accessControlled == null) {
            accessControlled = _NULL_ACCESS_CONTROLLED;
        }
        this._accessControlAdvisor.accept(method, new Object[0], accessControlled);
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
        this.decrementServiceDepth();
    }

    public Response toResponse(SecurityException exception) {
        MediaType mediaType = null;
        List mediaTypes = this._httpHeaders.getAcceptableMediaTypes();
        for (MediaType currentMediaType : mediaTypes) {
            MessageBodyWriter messageBodyWriter = this._providers.getMessageBodyWriter(ForbiddenEntity.class, null, null, currentMediaType);
            if (messageBodyWriter == null) continue;
            mediaType = currentMediaType;
            break;
        }
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_XML_TYPE;
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ForbiddenEntity(exception)).type(mediaType).build();
    }

    protected void decrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            return;
        }
        Integer n = serviceDepth;
        Integer n2 = serviceDepth = Integer.valueOf(serviceDepth - 1);
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }

    protected void incrementServiceDepth() {
        AccessControlContext accessControlContext = AccessControlUtil.getAccessControlContext();
        if (accessControlContext == null) {
            return;
        }
        Map settings = accessControlContext.getSettings();
        Integer serviceDepth = (Integer)settings.get(AccessControlContext.Settings.SERVICE_DEPTH.toString());
        if (serviceDepth == null) {
            serviceDepth = 1;
        } else {
            Integer n = serviceDepth;
            Integer n2 = serviceDepth = Integer.valueOf(serviceDepth + 1);
        }
        settings.put(AccessControlContext.Settings.SERVICE_DEPTH.toString(), serviceDepth);
    }
}

