/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.relationship.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.relationship.Degree;
import com.liferay.portal.relationship.Relationship;
import com.liferay.portal.relationship.RelationshipManager;
import com.liferay.portal.relationship.RelationshipResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={RelationshipManager.class})
public class RelationshipManagerImpl
implements RelationshipManager {
    private static final Log _log = LogFactoryUtil.getLog(RelationshipManagerImpl.class);
    private ServiceTrackerMap<String, List<RelationshipResource>> _serviceTrackerMap;

    public <T extends ClassedModel> Collection<? extends ClassedModel> getInboundRelatedModels(Class<T> modelClass, long primKey) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        return stream.flatMap(relationship -> relationship.getInboundRelatedModelStream(primKey)).collect(Collectors.toList());
    }

    public <T extends ClassedModel> Collection<? extends ClassedModel> getInboundRelatedModels(Class<T> modelClass, long primKey, Degree degree) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        ArrayList inboundRelatedClassedModels = new ArrayList();
        stream.forEach(relationship -> {
            Stream inboundRelatedModelStream = relationship.getInboundRelatedModelStream(primKey);
            inboundRelatedModelStream.map(inboundRelatedModel -> inboundRelatedModel).forEach(inboundRelatedClassedModel -> {
                inboundRelatedClassedModels.add(inboundRelatedClassedModel);
                Degree minusOneDegree = Degree.minusOne((Degree)degree);
                if (minusOneDegree.getDegree() <= 0) {
                    return;
                }
                Collection<ClassedModel> minusOneDegreeInboundRelatedClassedModels = this.getInboundRelatedModels(inboundRelatedClassedModel.getModelClass(), (Long)inboundRelatedClassedModel.getPrimaryKeyObj(), minusOneDegree);
                inboundRelatedClassedModels.addAll(minusOneDegreeInboundRelatedClassedModels);
            });
        });
        return inboundRelatedClassedModels;
    }

    public <T extends ClassedModel> Collection<? extends ClassedModel> getOutboundRelatedModels(Class<T> modelClass, long primKey) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        return stream.flatMap(relationship -> relationship.getOutboundRelatedModelStream(primKey)).collect(Collectors.toList());
    }

    public <T extends ClassedModel> Collection<? extends ClassedModel> getOutboundRelatedModels(Class<T> modelClass, long primKey, Degree degree) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        ArrayList outBoundRelatedClassedModels = new ArrayList();
        stream.forEach(relationship -> {
            Stream outboundRelatedModelStream = relationship.getOutboundRelatedModelStream(primKey);
            outboundRelatedModelStream.map(outboundRelatedModel -> outboundRelatedModel).forEach(outboundRelatedClassedModel -> {
                outBoundRelatedClassedModels.add(outboundRelatedClassedModel);
                Degree minusOneDegree = Degree.minusOne((Degree)degree);
                if (minusOneDegree.getDegree() <= 0) {
                    return;
                }
                Collection<ClassedModel> minusOneDegreeOutboundRelatedClassedModels = this.getInboundRelatedModels(outboundRelatedClassedModel.getModelClass(), (Long)outboundRelatedClassedModel.getPrimaryKeyObj(), minusOneDegree);
                outBoundRelatedClassedModels.addAll(minusOneDegreeOutboundRelatedClassedModels);
            });
        });
        return outBoundRelatedClassedModels;
    }

    public <T extends ClassedModel> Collection<? extends ClassedModel> getRelatedModels(Class<T> modelClass, long primKey) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        return stream.flatMap(relationship -> relationship.getRelatedModelStream(primKey)).collect(Collectors.toList());
    }

    public <T extends ClassedModel> Collection<? extends ClassedModel> getRelatedModels(Class<T> modelClass, long primKey, Degree degree) {
        List<Relationship<T>> relationships = this._getRelationships(modelClass);
        Stream stream = relationships.stream();
        ArrayList relatedClassedModels = new ArrayList();
        stream.forEach(relationship -> {
            Stream relatedModelStream = relationship.getRelatedModelStream(primKey);
            relatedModelStream.map(relatedModel -> relatedModel).forEach(relatedClassedModel -> {
                relatedClassedModels.add(relatedClassedModel);
                Degree minusOneDegree = Degree.minusOne((Degree)degree);
                if (minusOneDegree.getDegree() <= 0) {
                    return;
                }
                Collection<ClassedModel> minusOneDegreeRelatedClassedModels = this.getInboundRelatedModels(relatedClassedModel.getModelClass(), (Long)relatedClassedModel.getPrimaryKeyObj(), minusOneDegree);
                relatedClassedModels.addAll(minusOneDegreeRelatedClassedModels);
            });
        });
        return relatedClassedModels;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, RelationshipResource.class, null, (serviceReference, emitter) -> {
            String modelClassName = (String)serviceReference.getProperty("model.class.name");
            if (Validator.isNull((String)modelClassName)) {
                _log.error((Object)"Unable to register relationship resource because of missing service property \"model.class.name\"");
            }
            emitter.emit((Object)modelClassName);
        });
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private <T extends ClassedModel> List<Relationship<T>> _getRelationships(Class<T> modelClass) {
        ArrayList<Relationship<T>> relationships = new ArrayList<Relationship<T>>();
        List relationshipResources = (List)this._serviceTrackerMap.getService((Object)modelClass.getName());
        for (RelationshipResource relationshipResource : relationshipResources) {
            Relationship.Builder builder = new Relationship.Builder();
            Relationship relationship = relationshipResource.relationship(builder);
            relationships.add(relationship);
        }
        return relationships;
    }
}

