/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.relationship;

public class Degree {
    private final int _degree;

    public static Degree infinite() {
        return new Degree(Integer.MAX_VALUE);
    }

    public static Degree minusOne(Degree degree) {
        int degreeValue = degree.getDegree();
        if (degreeValue == 1) {
            throw new RuntimeException("Relationship degree cannot be 0");
        }
        return new Degree(degreeValue - 1);
    }

    public static Degree one() {
        return new Degree(1);
    }

    public static Degree parse(String string) {
        try {
            int degree = Integer.valueOf(string);
            if (degree <= 0) {
                throw new IllegalArgumentException("Relationship degree cannot be 0 or less than 0");
            }
            return new Degree(degree);
        }
        catch (NumberFormatException numberFormatException) {
            return Degree.one();
        }
    }

    public static Degree two() {
        return new Degree(2);
    }

    public int getDegree() {
        return this._degree;
    }

    private Degree(int degree) {
        this._degree = degree;
    }
}

