/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.relationship;

import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.relationship.ModelSupplier;
import com.liferay.portal.relationship.MultiRelationshipFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class Relationship<T extends ClassedModel> {
    private final Set<MultiRelationshipFunction<T, ? extends ClassedModel>> _inboundMultiRelationshipFunctions = new HashSet<MultiRelationshipFunction<T, ? extends ClassedModel>>();
    private final Set<Function<T, ? extends ClassedModel>> _inboundSingleRelationshipFunctions = new HashSet<Function<T, ? extends ClassedModel>>();
    private ModelSupplier<Long, T> _modelSupplier;
    private final Set<MultiRelationshipFunction<T, ? extends ClassedModel>> _outboundMultiRelationshipFunctions = new HashSet<MultiRelationshipFunction<T, ? extends ClassedModel>>();
    private final Set<Function<T, ? extends ClassedModel>> _outboundSingleRelationshipFunctions = new HashSet<Function<T, ? extends ClassedModel>>();

    public Stream<? extends ClassedModel> getInboundRelatedModelStream(long primKey) {
        T model = this._modelSupplier.supply(primKey);
        return this._getInboundRelatedModelStream(model);
    }

    public Stream<? extends ClassedModel> getOutboundRelatedModelStream(long primKey) {
        T model = this._modelSupplier.supply(primKey);
        return this._getOutboundRelatedModelStream(model);
    }

    public Stream<? extends ClassedModel> getRelatedModelStream(long primKey) {
        T model = this._modelSupplier.supply(primKey);
        return Stream.concat(this._getInboundRelatedModelStream(model), this._getOutboundRelatedModelStream(model));
    }

    private Relationship() {
    }

    private Stream<? extends ClassedModel> _getInboundMultiRelatedModelStream(T model) {
        Stream stream = this._inboundMultiRelationshipFunctions.stream();
        return stream.map(multiRelationshipFunction -> multiRelationshipFunction.apply(model)).flatMap(Collection::stream);
    }

    private Stream<? extends ClassedModel> _getInboundRelatedModelStream(T model) {
        return Stream.concat(this._getInboundMultiRelatedModelStream(model), this._getSingleInboundRelatedModelStream(model));
    }

    private Stream<? extends ClassedModel> _getOutboundMultiRelatedModelStream(T model) {
        Stream stream = this._outboundMultiRelationshipFunctions.stream();
        return stream.map(multiRelationshipFunction -> multiRelationshipFunction.apply(model)).flatMap(Collection::stream);
    }

    private Stream<? extends ClassedModel> _getOutboundRelatedModelStream(T model) {
        return Stream.concat(this._getOutboundMultiRelatedModelStream(model), this._getSingleOutboudRelatedModelStream(model));
    }

    private Stream<? extends ClassedModel> _getSingleInboundRelatedModelStream(T model) {
        Stream stream = this._inboundSingleRelationshipFunctions.stream();
        return stream.map(function -> (ClassedModel)function.apply(model));
    }

    private Stream<? extends ClassedModel> _getSingleOutboudRelatedModelStream(T model) {
        Stream stream = this._outboundSingleRelationshipFunctions.stream();
        return stream.map(function -> (ClassedModel)function.apply(model));
    }

    public static class Builder<T extends ClassedModel> {
        private final Relationship<T> _relationship;

        public Builder() {
            this._relationship = new Relationship();
        }

        public Builder(Relationship<T> relationship) {
            this._relationship = relationship;
        }

        public RelationshipStep modelSupplier(ModelSupplier<Long, T> modelSupplier) {
            ((Relationship)this._relationship)._modelSupplier = modelSupplier;
            return new RelationshipStep();
        }

        public class RelationshipStep {
            public Relationship<T> build() {
                return Builder.this._relationship;
            }

            public <U extends ClassedModel> RelationshipStep inboundMultiRelationship(MultiRelationshipFunction<T, U> multiRelationshipFunction) {
                Objects.requireNonNull(multiRelationshipFunction);
                Builder.this._relationship._inboundMultiRelationshipFunctions.add(multiRelationshipFunction);
                return this;
            }

            public <U extends ClassedModel> RelationshipStep inboundSingleRelationship(Function<T, U> function) {
                Objects.requireNonNull(function);
                Builder.this._relationship._inboundSingleRelationshipFunctions.add(function);
                return this;
            }

            public <U extends ClassedModel> RelationshipStep outboundMultiRelationship(MultiRelationshipFunction<T, U> multiRelationshipFunction) {
                Objects.requireNonNull(multiRelationshipFunction);
                Builder.this._relationship._outboundMultiRelationshipFunctions.add(multiRelationshipFunction);
                return this;
            }

            public <U extends ClassedModel> RelationshipStep outboundSingleRelationship(Function<T, U> function) {
                Objects.requireNonNull(function);
                Builder.this._relationship._outboundSingleRelationshipFunctions.add(function);
                return this;
            }
        }
    }
}

