/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.profile.internal;

import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.profile.PortalProfile;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(immediate=true)
public class PortalProfileGatekeeper {
    private ServiceTracker<PortalProfile, Void> _serviceTracker;

    @Activate
    public void activate(BundleContext bundleContext) {
        Set portalProfileNames = SetUtil.fromArray((Object[])StringUtil.split((String)bundleContext.getProperty("portal.profile.names")));
        if (portalProfileNames.isEmpty()) {
            String name = ReleaseInfo.getName();
            if (name.contains("Community")) {
                portalProfileNames.add("CE");
            } else {
                portalProfileNames.add("DXP");
            }
        }
        this._serviceTracker = new ServiceTracker(bundleContext, PortalProfile.class, (ServiceTrackerCustomizer)new PortalProfileServiceTrackerCustomizer(bundleContext, portalProfileNames));
        this._serviceTracker.open();
    }

    @Deactivate
    public void deactivate() {
        this._serviceTracker.close();
    }

    private static class PortalProfileServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalProfile, Void> {
        private final BundleContext _bundleContext;
        private final Set<String> _portalProfileNames;

        public Void addingService(ServiceReference<PortalProfile> serviceReference) {
            PortalProfile portalProfile = (PortalProfile)this._bundleContext.getService(serviceReference);
            for (String portalProfileName : portalProfile.getPortalProfileNames()) {
                if (!this._portalProfileNames.contains(portalProfileName)) continue;
                portalProfile.activate();
                break;
            }
            return null;
        }

        public void modifiedService(ServiceReference<PortalProfile> serviceReference, Void v) {
        }

        public void removedService(ServiceReference<PortalProfile> serviceReference, Void v) {
        }

        private PortalProfileServiceTrackerCustomizer(BundleContext bundleContext, Set<String> portalProfileNames) {
            this._bundleContext = bundleContext;
            this._portalProfileNames = portalProfileNames;
        }
    }
}

