/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.profile.internal;

import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.profile.PortalProfile;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={})
public class PortalProfileGatekeeper {
    private ServiceTracker<PortalProfile, Void> _serviceTracker;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Set blacklistPortalProfileNames = SetUtil.fromArray((Object[])StringUtil.split((String)bundleContext.getProperty("blacklist.portal.profile.names")));
        Set whitelistPortalProfileNames = SetUtil.fromArray((Object[])StringUtil.split((String)bundleContext.getProperty("whitelist.portal.profile.names")));
        if (whitelistPortalProfileNames.isEmpty()) {
            if (ReleaseInfo.isDXP()) {
                whitelistPortalProfileNames.add("DXP");
            } else {
                whitelistPortalProfileNames.add("CE");
            }
        }
        this._serviceTracker = new ServiceTracker(bundleContext, PortalProfile.class, (ServiceTrackerCustomizer)new PortalProfileServiceTrackerCustomizer(bundleContext, blacklistPortalProfileNames, whitelistPortalProfileNames));
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }

    private static class PortalProfileServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalProfile, Void> {
        private final Set<String> _blacklistPortalProfileNames;
        private final BundleContext _bundleContext;
        private final Set<String> _whitelistPortalProfileNames;

        public Void addingService(ServiceReference<PortalProfile> serviceReference) {
            PortalProfile portalProfile = (PortalProfile)this._bundleContext.getService(serviceReference);
            for (String portalProfileName : portalProfile.getPortalProfileNames()) {
                if (!this._blacklistPortalProfileNames.contains(portalProfileName)) continue;
                return null;
            }
            for (String portalProfileName : portalProfile.getPortalProfileNames()) {
                if (!this._whitelistPortalProfileNames.contains(portalProfileName)) continue;
                portalProfile.activate();
                break;
            }
            return null;
        }

        public void modifiedService(ServiceReference<PortalProfile> serviceReference, Void v) {
        }

        public void removedService(ServiceReference<PortalProfile> serviceReference, Void v) {
        }

        private PortalProfileServiceTrackerCustomizer(BundleContext bundleContext, Set<String> blacklistPortalProfileNames, Set<String> whitelistPortalProfileNames) {
            this._bundleContext = bundleContext;
            this._blacklistPortalProfileNames = blacklistPortalProfileNames;
            this._whitelistPortalProfileNames = whitelistPortalProfileNames;
        }
    }
}

