/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.profile;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.profile.PortalProfile;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class BaseEnterpriseDSModulePortalProfile
implements PortalProfile {
    private static final boolean _DXP;
    private static final Log _log;
    private static final Set<String> _startingBundleSymbolicNames;
    private ComponentContext _componentContext;
    private Set<String> _supportedPortalProfileNames;

    @Override
    public void activate() {
        if (!_DXP) {
            this._componentContext.enableComponent(null);
            return;
        }
        BundleContext bundleContext = this._componentContext.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!Objects.equals(bundle.getSymbolicName(), "com.liferay.portal.license.enterprise.app")) continue;
            this._componentContext.enableComponent(null);
            return;
        }
    }

    @Override
    public Set<String> getPortalProfileNames() {
        return this._supportedPortalProfileNames;
    }

    protected void init(ComponentContext componentContext) {
        this._componentContext = componentContext;
        BundleContext bundleContext = componentContext.getBundleContext();
        Bundle bundle = bundleContext.getBundle();
        Dictionary headers = bundle.getHeaders("");
        this._supportedPortalProfileNames = new HashSet<String>();
        String liferayEnterpriseApp = (String)headers.get("Liferay-Enterprise-App");
        if (liferayEnterpriseApp == null) {
            return;
        }
        if (!_startingBundleSymbolicNames.add(bundle.getSymbolicName())) {
            _startingBundleSymbolicNames.remove(bundle.getSymbolicName());
            return;
        }
        if (liferayEnterpriseApp.contains("dxp.only=true")) {
            this._supportedPortalProfileNames.add("DXP");
        } else {
            this._supportedPortalProfileNames.add("CE");
            this._supportedPortalProfileNames.add("DXP");
        }
        this._supportedPortalProfileNames.add(bundle.getSymbolicName());
    }

    static {
        boolean dxp;
        block2: {
            _log = LogFactoryUtil.getLog(BaseEnterpriseDSModulePortalProfile.class);
            _startingBundleSymbolicNames = Collections.newSetFromMap(new ConcurrentHashMap());
            ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
            dxp = false;
            try {
                classLoader.loadClass("com.liferay.portal.ee.license.LCSLicenseManager");
                dxp = true;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)reflectiveOperationException);
            }
        }
        _DXP = dxp;
    }
}

