/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portlet.bridge.soy.internal;

import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolverUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayActionRequest;
import com.liferay.portal.kernel.portlet.LiferayActionResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.LiferayRenderResponse;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommandCache;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.servlet.taglib.aui.ScriptData;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.portlet.bridge.soy.SoyPortletRegister;
import com.liferay.portal.portlet.bridge.soy.internal.SoyPortletHelper;
import com.liferay.portal.portlet.bridge.soy.internal.SoyPortletRequestFactory;
import com.liferay.portal.portlet.bridge.soy.internal.util.SoyTemplateResourceFactoryUtil;
import com.liferay.portal.portlet.bridge.soy.internal.util.SoyTemplateResourcesProviderUtil;
import com.liferay.portal.template.soy.util.SoyContext;
import com.liferay.portal.template.soy.util.SoyContextFactoryUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SoyPortlet
extends MVCPortlet {
    protected boolean propagateRequestParameters;
    private static final Log _log = LogFactoryUtil.getLog(SoyPortlet.class);
    private Bundle _bundle;
    private PortletConfig _portletConfig;
    private SoyPortletHelper _soyPortletHelper;
    private SoyPortletRegister _soyPortletRegister;
    private List<TemplateResource> _templateResources;

    public SoyPortlet() {
        this(null);
    }

    public SoyPortlet(SoyPortletRegister soyPortletRegister) {
        this._soyPortletRegister = soyPortletRegister;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        this._portletConfig = portletConfig;
        this.propagateRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("propagate-request-parameters"), (boolean)true);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (this._soyPortletRegister != null) {
            clazz = this._soyPortletRegister.getClass();
        }
        this._bundle = FrameworkUtil.getBundle(clazz);
        try {
            MVCCommandCache mvcRenderCommandCache = this.getRenderMVCCommandCache();
            FriendlyURLMapper friendlyURLMapper = this._getFriendlyURLMapper();
            this._soyPortletHelper = new SoyPortletHelper(this._bundle, mvcRenderCommandCache, friendlyURLMapper);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        Template template = (Template)renderRequest.getAttribute("TEMPLATE");
        if (template == null) {
            try {
                this._createRequestTemplate((PortletRequest)renderRequest);
            }
            catch (TemplateException te) {
                throw new PortletException((Throwable)te);
            }
        }
        if (this._isPjaxRequest((PortletRequest)renderRequest)) {
            return;
        }
        super.render(renderRequest, renderResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        HttpServletResponse httpServletResponse = PortalUtil.getHttpServletResponse((PortletResponse)resourceResponse);
        try {
            if (this._isProcessAction((PortletRequest)resourceRequest)) {
                this._callProcessAction(resourceRequest, resourceResponse, httpServletResponse, this._getPortlet());
            } else if (this._isRoutedRequest((PortletRequest)resourceRequest)) {
                this._callRender(resourceRequest, resourceResponse, this._getPortlet());
                this._prepareTemplate((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
                httpServletResponse.setContentType("application/json");
                Template template = this.getTemplate((PortletRequest)resourceRequest);
                ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)this._soyPortletHelper.serializeTemplate(template));
            } else {
                this.callResourceMethod(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            _log.error((Object)"Error on the Serve Resource Phase", (Throwable)e);
        }
    }

    protected Set<String> getJavaScriptRequiredModules(String path) {
        try {
            HashSet<String> javaScriptRequiredModules = new HashSet<String>();
            String javaScriptRequiredModule = this._soyPortletHelper.getJavaScriptLoaderModule(path);
            javaScriptRequiredModules.add(javaScriptRequiredModule);
            if (this._soyPortletRegister != null) {
                javaScriptRequiredModules.addAll(this._soyPortletRegister.getJavaScriptRequiredModules(path));
            }
            return javaScriptRequiredModules;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    protected String getPath(PortletRequest portletRequest, PortletResponse portletResponse) {
        String path = super.getPath(portletRequest, portletResponse);
        if (Validator.isNull((String)path) || "/".equals(path)) {
            return this.viewTemplate;
        }
        return path;
    }

    protected Writer getResponseWriter(PortletResponse portletResponse) throws IOException {
        UnsyncStringWriter writer = null;
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            writer = UnsyncPrintWriterPool.borrow((Writer)mimeResponse.getWriter());
        } else {
            writer = new UnsyncStringWriter();
        }
        return writer;
    }

    protected Template getTemplate(PortletRequest portletRequest) throws PortletException {
        Template template = (Template)portletRequest.getAttribute("TEMPLATE");
        if (template != null) {
            return template;
        }
        try {
            return this._createRequestTemplate(portletRequest);
        }
        catch (TemplateException te) {
            throw new PortletException("Unable to create template", (Throwable)te);
        }
    }

    protected void include(String path, PortletRequest portletRequest, PortletResponse portletResponse, String lifecycle) throws IOException, PortletException {
        try {
            Writer writer = this.getResponseWriter(portletResponse);
            this._prepareTemplate(portletRequest, portletResponse);
            this._writeTemplate(portletRequest, portletResponse, writer);
            this._writeJavaScript(portletRequest, portletResponse, writer);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
        if (this.clearRequestParameters && lifecycle.equals("RENDER_PHASE")) {
            portletResponse.setProperty("clear-request-parameters", "true");
        }
    }

    protected void populateJavaScriptTemplateContext(Template template, String portletNamespace) {
        String portletComponentId = this._getPortletComponentId(portletNamespace);
        template.put((Object)"element", (Object)("#" + this._getPortletWrapperId(portletNamespace) + " > div"));
        template.put((Object)"id", (Object)portletComponentId);
    }

    protected void propagateRequestParameters(PortletRequest portletRequest) throws PortletException {
        HashMap<String, Object> soyContextParametersMap = new HashMap<String, Object>();
        Map parametersMap = portletRequest.getParameterMap();
        for (Map.Entry entry : parametersMap.entrySet()) {
            String parameterName = (String)entry.getKey();
            String[] parameterValues = (String[])entry.getValue();
            if (parameterValues.length == 1) {
                soyContextParametersMap.put(parameterName, parameterValues[0]);
                continue;
            }
            if (parameterValues.length <= 1) continue;
            soyContextParametersMap.put(parameterName, parameterValues);
        }
        Template template = this.getTemplate(portletRequest);
        HashMap injectedData = (HashMap)template.get((Object)"_INJECTED_DATA_");
        if (injectedData == null) {
            injectedData = new HashMap();
        }
        injectedData.put("requestParams", soyContextParametersMap);
        template.put((Object)"_INJECTED_DATA_", injectedData);
    }

    private void _callProcessAction(ResourceRequest resourceRequest, ResourceResponse resourceResponse, HttpServletResponse httpServletResponse, Portlet portlet) throws Exception {
        SoyPortletRequestFactory soyPortletRequestFactory = new SoyPortletRequestFactory(portlet);
        LiferayActionRequest liferayActionRequest = soyPortletRequestFactory.createActionRequest(resourceRequest);
        LiferayActionResponse liferayActionResponse = soyPortletRequestFactory.createActionResponse((ActionRequest)liferayActionRequest, resourceResponse);
        this.processAction((ActionRequest)liferayActionRequest, (ActionResponse)liferayActionResponse);
        this._copyRequestAttributes((PortletRequest)liferayActionRequest, resourceRequest);
        String portletNamespace = resourceResponse.getNamespace();
        String redirect = HttpUtil.setParameter((String)liferayActionResponse.getRedirectLocation(), (String)(portletNamespace + "pjax"), (String)"true");
        redirect = HttpUtil.setParameter((String)redirect, (String)"p_p_lifecycle", (String)"2");
        httpServletResponse.sendRedirect(redirect);
    }

    private void _callRender(ResourceRequest resourceRequest, ResourceResponse resourceResponse, Portlet portlet) throws Exception {
        SoyPortletRequestFactory soyPortletRequestFactory = new SoyPortletRequestFactory(portlet);
        LiferayRenderRequest liferayRenderRequest = soyPortletRequestFactory.createRenderRequest(resourceRequest, resourceResponse);
        LiferayRenderResponse liferayRenderResponse = soyPortletRequestFactory.createRenderResponse((RenderRequest)liferayRenderRequest, resourceResponse);
        this.render((RenderRequest)liferayRenderRequest, (RenderResponse)liferayRenderResponse);
        this._copyRequestAttributes((PortletRequest)liferayRenderRequest, resourceRequest);
        String mvcRenderCommandName = ParamUtil.getString((PortletRequest)resourceRequest, (String)"mvcRenderCommandName", (String)"/");
        MVCRenderCommand mvcRenderCommand = this._getMVCRenderCommand(mvcRenderCommandName);
        String path = this.getPath((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (mvcRenderCommand != MVCRenderCommand.EMPTY) {
            path = mvcRenderCommand.render((RenderRequest)liferayRenderRequest, (RenderResponse)liferayRenderResponse);
            this._copyRequestAttributes((PortletRequest)liferayRenderRequest, resourceRequest);
        }
        resourceRequest.setAttribute(this.getMVCPathAttributeName(liferayRenderResponse.getNamespace()), (Object)path);
    }

    private void _clearSessionMessages(PortletRequest portletRequest) {
        SessionErrors.clear((PortletRequest)portletRequest);
        SessionMessages.clear((PortletRequest)portletRequest);
    }

    private void _copyRequestAttributes(PortletRequest portletRequest, ResourceRequest resourceRequest) {
        Enumeration attributeNames = portletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            resourceRequest.setAttribute(attributeName, portletRequest.getAttribute(attributeName));
        }
    }

    private Template _createRequestTemplate(PortletRequest portletRequest) throws TemplateException {
        List<TemplateResource> templateResources = this._getTemplateResources();
        Template template = TemplateManagerUtil.getTemplate((String)"soy", (TemplateResource)SoyTemplateResourceFactoryUtil.createSoyTemplateResource(templateResources), (boolean)false);
        portletRequest.setAttribute("TEMPLATE", (Object)template);
        return template;
    }

    private FriendlyURLMapper _getFriendlyURLMapper() {
        Portlet portlet = this._getPortlet();
        return portlet.getFriendlyURLMapperInstance();
    }

    private MVCRenderCommand _getMVCRenderCommand(String mvcRenderCommandName) {
        MVCCommandCache mvcRenderCommandCache = this.getRenderMVCCommandCache();
        return (MVCRenderCommand)mvcRenderCommandCache.getMVCCommand(mvcRenderCommandName);
    }

    private Portlet _getPortlet() {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)this._portletConfig;
        return liferayPortletConfig.getPortlet();
    }

    private String _getPortletComponentId(String portletNamespace) {
        return portletNamespace.concat("PortletComponent");
    }

    private String _getPortletWrapperId(String portletNamespace) {
        StringBundler sb = new StringBundler(3);
        sb.append(portletNamespace);
        sb.append("_");
        sb.append("SoyWrapper");
        return sb.toString();
    }

    private List<TemplateResource> _getTemplateResources() throws TemplateException {
        if (this._templateResources != null) {
            return this._templateResources;
        }
        ArrayList<TemplateResource> templateResources = new ArrayList<TemplateResource>(SoyTemplateResourcesProviderUtil.getBundleTemplateResources(this._bundle, this.templatePath));
        MVCCommandCache mvcCommandCache = this.getRenderMVCCommandCache();
        for (String mvcCommandName : mvcCommandCache.getMVCCommandNames()) {
            MVCRenderCommand mvcCommand = this._getMVCRenderCommand(mvcCommandName);
            Bundle curBundle = FrameworkUtil.getBundle(mvcCommand.getClass());
            List<TemplateResource> mvcCommandTemplateResources = SoyTemplateResourcesProviderUtil.getBundleTemplateResources(curBundle, this.templatePath);
            templateResources.addAll(mvcCommandTemplateResources);
        }
        this._templateResources = templateResources;
        return templateResources;
    }

    private boolean _isPjaxRequest(PortletRequest portletRequest) {
        return ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"pjax");
    }

    private boolean _isProcessAction(PortletRequest portletRequest) {
        int original_p_p_lifecycle = ParamUtil.getInteger((PortletRequest)portletRequest, (String)"original_p_p_lifecycle");
        return original_p_p_lifecycle == 1;
    }

    private boolean _isRoutedRequest(PortletRequest portletRequest) {
        return Validator.isNotNull((String)portletRequest.getParameter("original_p_p_lifecycle"));
    }

    private void _prepareSessionMessages(PortletRequest portletRequest, SoyContext soyContext) {
        HashMap<String, Object> sessionErrors = new HashMap<String, Object>();
        for (String key : SessionErrors.keySet((PortletRequest)portletRequest)) {
            sessionErrors.put(key, SessionErrors.get((PortletRequest)portletRequest, (String)key));
        }
        soyContext.putInjectedData("sessionErrors", sessionErrors);
        HashMap<String, Object> sessionMessages = new HashMap<String, Object>();
        for (String key : SessionMessages.keySet((PortletRequest)portletRequest)) {
            if (key.endsWith(".hideDefaultErrorMessage")) continue;
            sessionMessages.put(key, SessionMessages.get((PortletRequest)portletRequest, (String)key));
        }
        soyContext.putInjectedData("sessionMessages", sessionMessages);
    }

    private void _prepareTemplate(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        this.hideDefaultErrorMessage(portletRequest);
        Template template = this.getTemplate(portletRequest);
        String path = this.getPath(portletRequest, portletResponse);
        template.put((Object)"javaScriptLoaderModule", (Object)this._soyPortletHelper.getJavaScriptLoaderModule(path));
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        template.put((Object)"locale", (Object)themeDisplay.getLocale());
        String templateNamespace = path.concat(".render");
        template.put((Object)"namespace", (Object)templateNamespace);
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        template.prepare(httpServletRequest);
        SoyContext soyContext = SoyContextFactoryUtil.createSoyContext();
        soyContext.putInjectedData("portletNamespace", (Object)portletResponse.getNamespace());
        this._prepareSessionMessages(portletRequest, soyContext);
        template.putAll((Map)soyContext);
        if (this.propagateRequestParameters) {
            this.propagateRequestParameters(portletRequest);
        }
        this.populateJavaScriptTemplateContext(template, portletResponse.getNamespace());
        this._clearSessionMessages(portletRequest);
    }

    private void _writeJavaScript(PortletRequest portletRequest, PortletResponse portletResponse, Writer writer) throws Exception {
        ScriptData scriptData = new ScriptData();
        String portletNamespace = portletResponse.getNamespace();
        String portletComponentId = this._getPortletComponentId(portletNamespace);
        String portletId = PortalUtil.getPortletId((PortletRequest)portletRequest);
        String portletWrapperId = this._getPortletWrapperId(portletNamespace);
        Template template = this.getTemplate(portletRequest);
        String portletJavaScript = this._soyPortletHelper.getRouterJavaScript(portletComponentId, portletId, portletNamespace, portletWrapperId, template);
        HashSet<String> requiredModules = new HashSet<String>();
        requiredModules.add(NPMResolverUtil.resolveModuleName(SoyPortlet.class, (String)"portal-portlet-bridge-soy-impl/router/SoyPortletRouter as SoyPortletRouter"));
        String path = this.getPath(portletRequest, portletResponse);
        requiredModules.addAll(this.getJavaScriptRequiredModules(path));
        String requiredModulesString = StringUtil.merge(requiredModules);
        scriptData.append(portletId, portletJavaScript, requiredModulesString, ScriptData.ModulesType.ES6);
        scriptData.writeTo(writer);
    }

    private void _writeTemplate(PortletRequest portletRequest, PortletResponse portletResponse, Writer writer) throws Exception {
        writer.write("<div id=\"");
        writer.write(this._getPortletWrapperId(portletResponse.getNamespace()));
        writer.write("\">");
        Template template = this.getTemplate(portletRequest);
        template.processTemplate(writer);
        writer.write("</div>");
    }
}

