Liferay.Loader.define("portal-portlet-bridge-soy-impl@1.0.8/router/SoyPortletRouter", ['exports', 'frontend-js-web/liferay/compat/alert/Alert.es', 'metal/src/metal', 'metal-component/src/all/component', 'metal-dom/src/all/dom', 'metal-router/src/all/router', 'metal-soy/src/Soy', 'metal-state/src/all/state', 'metal-uri/src/Uri', 'metal-promise/src/promise/Promise', 'senna/src/senna', 'metal-path-parser/src/pathParser'], function (exports, _Alert, _metal, _component, _dom, _router, _Soy, _state, _Uri, _Promise, _senna, _pathParser) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _Alert2 = _interopRequireDefault(_Alert);

	var _metal2 = _interopRequireDefault(_metal);

	var _component2 = _interopRequireDefault(_component);

	var _dom2 = _interopRequireDefault(_dom);

	var _router2 = _interopRequireDefault(_router);

	var _Soy2 = _interopRequireDefault(_Soy);

	var _state2 = _interopRequireDefault(_state);

	var _Uri2 = _interopRequireDefault(_Uri);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	var _extends = Object.assign || function (target) {
		for (var i = 1; i < arguments.length; i++) {
			var source = arguments[i];

			for (var key in source) {
				if (Object.prototype.hasOwnProperty.call(source, key)) {
					target[key] = source[key];
				}
			}
		}

		return target;
	};

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var SoyPortletRouter = function (_State) {
		_inherits(SoyPortletRouter, _State);

		/**
   * @inheritDoc
   */
		function SoyPortletRouter(config) {
			_classCallCheck(this, SoyPortletRouter);

			var _this = _possibleConstructorReturn(this, (SoyPortletRouter.__proto__ || Object.getPrototypeOf(SoyPortletRouter)).call(this, config));

			_this.initializeRoutes_();

			var router = _this.getRouter();
			router.ignoreQueryStringFromRoutePath = false;
			router.on('endNavigate', _this.onEndNavigate_.bind(_this));
			router.dispatch();

			var handler = Liferay.once('beforeScreenFlip', function () {
				router.dispose();
				_router2.default.routerInstance = null;
				_router2.default.activeRouter = null;
			});

			Liferay.once(_this.portletId + ':portletRefreshed', function () {
				handler.detach();
				router.dispose();
				_router2.default.routerInstance = null;
				_router2.default.activeRouter = null;
			});
			return _this;
		}

		/**
   * Gets the currently active component from the current router.
   * @return {Component}
   * @see {Router.getActiveComponent}
   */


		_createClass(SoyPortletRouter, [{
			key: 'getActiveComponent',
			value: function getActiveComponent() {
				return _router2.default.getActiveComponent();
			}
		}, {
			key: 'getActiveState',
			value: function getActiveState() {
				return _router2.default.activeState;
			}
		}, {
			key: 'getRouter',
			value: function getRouter() {
				return _router2.default.router();
			}
		}, {
			key: 'createDefaultScreen_',
			value: function createDefaultScreen_() {
				var instance = this;

				/**
     * Special screen that uses attempts to load the controller in a deferred
     * way after retrieving the new renderState.
     */

				var DeferredComponentScreen = function (_Router$defaultScreen) {
					_inherits(DeferredComponentScreen, _Router$defaultScreen);

					/**
      * @inheritDoc
      */
					function DeferredComponentScreen(router) {
						_classCallCheck(this, DeferredComponentScreen);

						return _possibleConstructorReturn(this, (DeferredComponentScreen.__proto__ || Object.getPrototypeOf(DeferredComponentScreen)).call(this, router));
					}

					/**
      * Runs before updating the history path to remove the special
      * params added to the URL when calculating the fetch version of
      * the provided one
      * @param {*} args
      * @return {string} The stringified URL
      */


					_createClass(DeferredComponentScreen, [{
						key: 'beforeUpdateHistoryPath',
						value: function beforeUpdateHistoryPath() {
							for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
								args[_key] = arguments[_key];
							}

							var redirect = _senna.RequestScreen.prototype.beforeUpdateHistoryPath.apply(this, args);

							var uri = new _Uri2.default(redirect);
							uri.removeParameter('p_p_lifecycle');
							uri.removeParameter(instance.portletNamespace + 'pjax');

							if (uri.hasParameter(instance.portletNamespace + 'no_p_p_id')) {
								uri.removeParameter('p_p_id');
								uri.removeParameter(instance.portletNamespace + 'no_p_p_id');
							}

							return uri.toString();
						}
					}, {
						key: 'flip',
						value: function flip() {
							var _this3 = this;

							var loadedState = _get(DeferredComponentScreen.prototype.__proto__ || Object.getPrototypeOf(DeferredComponentScreen.prototype), 'maybeParseLastLoadedStateAsJson', this).call(this);

							_Soy2.default.setInjectedData(loadedState._INJECTED_DATA_);

							var deferred = new _Promise.CancellablePromise(function (resolve, reject) {
								Liferay.Loader.require(loadedState.javaScriptLoaderModule, function (module) {
									_get(DeferredComponentScreen.prototype.__proto__ || Object.getPrototypeOf(DeferredComponentScreen.prototype), 'maybeRedirectRouter', _this3).call(_this3);
									_this3.router.component = module.default;
									resolve();
								}, function (error) {
									return reject(error);
								});
							});

							return deferred.then(function () {
								return _get(DeferredComponentScreen.prototype.__proto__ || Object.getPrototypeOf(DeferredComponentScreen.prototype), 'flip', _this3).call(_this3);
							});
						}
					}]);

					return DeferredComponentScreen;
				}(_router2.default.defaultScreen);

				DeferredComponentScreen.SYNC_UPDATES = true;

				_router2.default.defaultScreen = DeferredComponentScreen;
			}
		}, {
			key: 'createRouter_',
			value: function createRouter_(route, pathFn) {
				var config = _extends({
					cacheable: false,
					element: this.element,
					fetch: true,
					fetchUrl: this.getFetchUrl_.bind(this),
					path: pathFn || this.matchPath_.bind(this, route.mvcRenderCommandName),
					portletNamespace: this.portletNamespace,
					route: route
				});

				try {
					if (config.path(_senna.utils.getCurrentBrowserPath())) {
						config.data = this.context;
					}
				} catch (e) {}

				return new _router2.default(config, this.portletWrapper);
			}
		}, {
			key: 'getFetchUrl_',
			value: function getFetchUrl_(url) {
				var uri = new _Uri2.default(url);

				if (uri.hasParameter('p_p_lifecycle')) {
					var original_p_p_lifecyle = uri.getParameterValue('p_p_lifecycle');

					uri.setParameterValue(this.portletNamespace + 'original_p_p_lifecycle', original_p_p_lifecyle);
				}

				uri.setParameterValue('p_p_lifecycle', '2');
				uri.setParameterValue(this.portletNamespace + 'pjax', true);

				if (!uri.hasParameter('p_p_id')) {
					uri.setParameterValue('p_p_id', this.portletId);
					uri.setParameterValue(this.portletNamespace + 'no_p_p_id', true);
				}

				return uri.toString();
			}
		}, {
			key: 'getPathFunctionForFriendlyURLPattern_',
			value: function getPathFunctionForFriendlyURLPattern_(pattern, mapping) {
				var _this4 = this;

				return function (url) {
					var mappingPrefix = '/' + mapping;
					if (_this4.friendlyURLPrefix) {
						mappingPrefix = '/-' + mappingPrefix;
					}
					var uri = new _Uri2.default(url);
					var pathname = uri.getPathname();
					var currentPath = pathname.substring(pathname.lastIndexOf(mappingPrefix));
					return currentPath === '' + mappingPrefix + pattern;
				};
			}
		}, {
			key: 'getPathFunctionForFriendlyURLRoute_',
			value: function getPathFunctionForFriendlyURLRoute_(friendlyURLRoute) {
				return this.getPathFunctionForOverriddenParameters_(friendlyURLRoute.overriddenParameters) || this.getPathFunctionForFriendlyURLPattern_(friendlyURLRoute.pattern, this.friendlyURLMapping);
			}
		}, {
			key: 'getPathFunctionForOverriddenParameters_',
			value: function getPathFunctionForOverriddenParameters_(overriddenParameters) {
				if (overriddenParameters['pattern-metal-router']) {
					var url = '(.*)/' + this.friendlyURLMapping + overriddenParameters['pattern-metal-router'];
					var regex = (0, _pathParser.toRegex)(url);
					return regex.test.bind(regex);
				}
			}
		}, {
			key: 'hasMVCRenderCommandName',
			value: function hasMVCRenderCommandName(mvcRenderCommandName) {
				return this.mvcRenderCommandNames.indexOf(mvcRenderCommandName) > -1;
			}
		}, {
			key: 'initializeRoutes_',
			value: function initializeRoutes_() {
				this.createDefaultScreen_();
				this.initializeActionRouter_();
				this.initializeRouters_();
				this.initializeFriendlyURLRouters_();
				this.initializeDefaultRouter_();
			}
		}, {
			key: 'initializeActionRouter_',
			value: function initializeActionRouter_() {
				var _this5 = this;

				var pathFn = function pathFn(url) {
					var uri = new _Uri2.default(url);

					var portletIdParam = uri.getParameterValue('p_p_id');
					var lifecycleParam = uri.getParameterValue('p_p_lifecycle');

					return lifecycleParam === '1' && portletIdParam === _this5.portletId;
				};

				this.createRouter_({}, pathFn);
			}
		}, {
			key: 'initializeDefaultRouter_',
			value: function initializeDefaultRouter_() {
				var pathFn = this.isDefaultURL_.bind(this);

				this.createRouter_({
					mvcRenderCommandName: '/'
				}, pathFn);
			}
		}, {
			key: 'initializeFriendlyURLRouters_',
			value: function initializeFriendlyURLRouters_() {
				var routes = this.friendlyURLRoutes.reduce(function (routes, route) {
					routes[route.pattern] = route;

					return routes;
				}, {});

				var keys = Object.keys(routes);

				for (var i = 0, l = keys.length; i < l; i++) {
					var pattern = keys[i];
					var friendlyURLRoute = routes[pattern];
					var implicitParameters = friendlyURLRoute.implicitParameters;
					var mvcRenderCommandName = implicitParameters.mvcRenderCommandName;

					if (!this.hasMVCRenderCommandName(mvcRenderCommandName)) {
						console.warn('Unable to find route for mvcRenderCommandName:', mvcRenderCommandName);
						continue;
					}

					var pathFn = this.getPathFunctionForFriendlyURLRoute_(friendlyURLRoute);

					this.createRouter_({ mvcRenderCommandName: mvcRenderCommandName }, pathFn);
				}
			}
		}, {
			key: 'initializeRouters_',
			value: function initializeRouters_() {
				var _this6 = this;

				this.mvcRenderCommandNames.forEach(function (mvcRenderCommandName) {
					return _this6.createRouter_({ mvcRenderCommandName: mvcRenderCommandName });
				});
			}
		}, {
			key: 'isDefaultURL_',
			value: function isDefaultURL_(url) {
				var uri = new _Uri2.default(url);

				if (uri.getParameterValue('p_p_lifecycle') === '1') {
					return false;
				}

				if (uri.hasParameter(this.portletNamespace + 'javax.portlet.action')) {
					return false;
				}

				if (uri.hasParameter(this.portletNamespace + 'mvcRenderCommandName')) {
					return false;
				}

				if (this.isFriendlyURL_(url)) {
					return false;
				}

				var currentURI = new _Uri2.default(Liferay.currentURL);

				if (uri.getPathname() === currentURI.getPathname()) {
					return true;
				}

				if (uri.getPathname() === themeDisplay.getLayoutRelativeURL()) {
					return true;
				}

				return false;
			}
		}, {
			key: 'isFriendlyURL_',
			value: function isFriendlyURL_(url) {
				var _this7 = this;

				var friendlyURLRoute = this.friendlyURLRoutes.find(function (friendlyURLRoute) {
					return _this7.getPathFunctionForFriendlyURLPattern_(friendlyURLRoute.pattern, _this7.friendlyURLMapping)(url);
				});

				return !!friendlyURLRoute;
			}
		}, {
			key: 'matchPath_',
			value: function matchPath_(mvcRenderCommandName, path) {
				var uri = new _Uri2.default(path);

				var mvcRenderCommandNameParam = uri.getParameterValue(this.portletNamespace + 'mvcRenderCommandName');

				var portletIdParam = uri.getParameterValue('p_p_id');

				return mvcRenderCommandNameParam === mvcRenderCommandName && portletIdParam === this.portletId;
			}
		}, {
			key: 'maybeShowAlert_',
			value: function maybeShowAlert_(message) {
				var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'danger';

				if (message) {
					var alert = _component2.default.render(_Alert2.default, {
						body: message,
						dismissible: true,
						elementClasses: 'alert-' + type,
						hideDelay: 30000,
						visible: true
					}, this.portletWrapper);

					this.portletWrapper.parentNode.insertBefore(alert.element, this.portletWrapper);

					_router2.default.router().once('startNavigate', function () {
						return alert.dispose();
					});
				}
			}
		}, {
			key: 'onEndNavigate_',
			value: function onEndNavigate_(event) {
				var _this8 = this;

				if (event.error && (event.error.requestError || event.error.invalidStatus)) {
					window.location.href = event.path;
				} else {
					var activeState = _router2.default.getActiveState();
					if (activeState) {
						var _INJECTED_DATA_ = activeState._INJECTED_DATA_;
						var sessionErrors = _INJECTED_DATA_.sessionErrors,
						    sessionMessages = _INJECTED_DATA_.sessionMessages;


						if (sessionMessages) {
							Object.keys(sessionMessages).forEach(function (key) {
								return _this8.maybeShowAlert_(sessionMessages[key], 'success');
							});
						}

						if (sessionErrors) {
							Object.keys(sessionErrors).forEach(function (key) {
								return _this8.maybeShowAlert_(sessionErrors[key]);
							});
						}
					}
				}
			}
		}]);

		return SoyPortletRouter;
	}(_state2.default);

	/**
  * State definition.
  * @ignore
  * @type {!Object}
  * @static
  */
	SoyPortletRouter.STATE = {
		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {Object}
   */
		context: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		element: {
			setter: _dom2.default.toElement
		},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {Array<string>}
   */
		friendlyURLRoutes: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		friendlyURLMapping: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		friendlyURLPrefix: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {Array<String>}
   */
		mvcRenderCommandNames: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		portletId: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		portletNamespace: {},

		/**
   * @instance
   * @memberof SoyPortletRouter
   * @type {string}
   */
		portletWrapper: {
			setter: _dom2.default.toElement
		}
	};

	exports.default = SoyPortletRouter;
});
//# sourceMappingURL=SoyPortletRouter.js.map
