Liferay.Loader.define("portal-portlet-bridge-soy-impl@1.0.8/metal-router/src/Router", ['exports', 'metal-promise/src/promise/Promise', 'metal-incremental-dom/src/all/incremental-dom', 'metal-uri/src/Uri', 'metal-component/src/all/component', 'senna/src/senna', 'metal/src/metal'], function (exports, _Promise, _incrementalDom, _Uri, _component, _senna, _metal) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _Promise2 = _interopRequireDefault(_Promise);

	var _incrementalDom2 = _interopRequireDefault(_incrementalDom);

	var _Uri2 = _interopRequireDefault(_Uri);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}

			return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var Router = function (_Component) {
		_inherits(Router, _Component);

		function Router() {
			_classCallCheck(this, Router);

			return _possibleConstructorReturn(this, (Router.__proto__ || Object.getPrototypeOf(Router)).apply(this, arguments));
		}

		_createClass(Router, [{
			key: 'created',
			value: function created() {
				this.route = new _senna.Route(this.path, this.createScreen_.bind(this));
				this.route.router = this;
				Router.router().addRoutes(this.route);

				// Router is never active on the first render, since it needs to wait for
				// any async data to load first. This code is to make sure it won't lose
				// the reference to its `element` and cause it to be removed from the dom
				// (which would be bad for progressive enhancement) due to not rendering
				// anything. It will be set back in `attached`.
				this.firstRenderElement = this.element;
				this.element = null;
			}
		}, {
			key: 'addRoutingData',
			value: function addRoutingData(path, state) {
				if (this.includeRoutingData) {
					var params = this.lastExtractedParams || this.extractParams(path);
					var query = this.extractQuery(path);
					return _metal.object.mixin({}, state, {
						router: {
							currentUrl: path,
							params: params,
							query: query
						}
					});
				}
				return state;
			}
		}, {
			key: 'attached',
			value: function attached() {
				if (!this.wasRendered) {
					this.element = this.firstRenderElement;
				}
			}
		}, {
			key: 'createScreen_',
			value: function createScreen_() {
				this.screen_ = new Router.defaultScreen(this); // eslint-disable-line
				return this.screen_;
			}
		}, {
			key: 'disposeInternal',
			value: function disposeInternal() {
				if (Router.activeRouter === this) {
					Router.activeRouter = null;
				}
				Router.router().removeRoute(this.route);
				_get(Router.prototype.__proto__ || Object.getPrototypeOf(Router.prototype), 'disposeInternal', this).call(this);
			}
		}, {
			key: 'extractParams',
			value: function extractParams(path) {
				return Router.router().extractParams(this.route, path);
			}
		}, {
			key: 'extractQuery',
			value: function extractQuery(path) {
				var uri = new _Uri2.default(path);
				var queryStrings = {};

				var parameterNames = uri.getParameterNames();

				for (var i = 0; i < parameterNames.length; i++) {
					var name = parameterNames[i];

					queryStrings[name] = uri.getParameterValue(name);
				}

				return queryStrings;
			}
		}, {
			key: 'getRouteComponent',
			value: function getRouteComponent() {
				return this.components.comp;
			}
		}, {
			key: 'getScreen',
			value: function getScreen() {
				return this.screen_;
			}
		}, {
			key: 'render',
			value: function render() {
				if (this.isActive_) {
					var _IncrementalDOM;

					var component = this.asyncComponent_ || this.component;

					(_IncrementalDOM = IncrementalDOM).elementVoid.apply(_IncrementalDOM, [component, null, null, 'ref', 'comp'].concat(_toConsumableArray(this.toArray_(Router.activeState))));
				}
			}
		}, {
			key: 'setterComponentFn_',
			value: function setterComponentFn_(ctor) {
				if (_metal.core.isString(ctor)) {
					ctor = _component.ComponentRegistry.getConstructor(ctor);
				}
				return ctor;
			}
		}, {
			key: 'shouldUpdate',
			value: function shouldUpdate(changes) {
				return changes.isActive_ || changes.component;
			}
		}, {
			key: 'toArray_',
			value: function toArray_(config) {
				var arr = [];
				var keys = Object.keys(config || {});
				for (var i = 0; i < keys.length; i++) {
					arr.push(keys[i], config[keys[i]]);
				}
				return arr;
			}
		}], [{
			key: 'getActiveComponent',
			value: function getActiveComponent() {
				return Router.activeRouter ? Router.activeRouter.getRouteComponent() : null;
			}
		}, {
			key: 'getActiveState',
			value: function getActiveState() {
				return Router.activeState;
			}
		}, {
			key: 'router',
			value: function router() {
				if (!Router.routerInstance) {
					var app = new _senna.App();
					app.setIgnoreQueryStringFromRoutePath(true);
					Router.routerInstance = app;
				}
				return Router.routerInstance;
			}
		}]);

		return Router;
	}(_component.Component);

	Router.RENDERER = _incrementalDom2.default;

	/**
  * Router state definition.
  * @type {!Object}
  * @static
  */
	Router.STATE = {
		/**
   * Flag indicating if the component should be loaded via a request
   * to the server.
   * @type {boolean}
   * @default false
   */
		async: {
			validator: _metal.core.isBoolean,
			value: false
		},

		/**
   * Internal value for the constructor of the component that was loaded
   * async. This component overrides the original component.
   * @type {!Function}
   */
		asyncComponent_: {},

		/**
   * Handler to be called before a router is activated. Can be given as a
   * function reference directly, or as the name of a function to be called in
   * the router's component instance.
   * @type {!function()|string}
   */
		beforeActivateHandler: {
			validator: function validator(val) {
				return _metal.core.isString(val) || _metal.core.isFunction(val);
			}
		},

		/**
   * Handler to be called before a router is deactivated. Can be given as a
   * function reference directly, or as the name of a function to be called in
   * the router's component instance.
   * @type {!function()|string}
   */
		beforeDeactivateHandler: {
			validator: function validator(val) {
				return _metal.core.isString(val) || _metal.core.isFunction(val);
			}
		},

		/**
   * If set to true navigation will cache component state deferred results.
   * @type {boolean}
   * @default true
   */
		cacheable: {
			validator: _metal.core.isBoolean,
			value: true
		},

		/**
   * The constructor of the component to render when path is accessed.
   * @type {!Function|string}
   */
		component: {
			setter: 'setterComponentFn_'
		},

		/**
   * Holds the load data value, function or deferred function that
   * resolves the component configurations.
   * @type {!Object|function(?string=)}
   */
		data: {
			setter: function setter(val) {
				return _metal.core.isFunction(val) ? val : function () {
					return val || {};
				};
			}
		},

		/**
   * Flag indicating if the component's data should be loaded via a request
   * to the server. By default the data will come from `data` instead.
   */
		fetch: {
			value: false
		},

		/**
   * Url to be used when fetching data for this route. If nothing is given,
   * the current path will be used by default. Note that this is only relevant
   * if "fetch" is set to `true`.
   * @type {?string|function()}
   */
		fetchUrl: {
			validator: function validator(val) {
				return _metal.core.isString(val) || _metal.core.isFunction(val);
			}
		},

		/**
   * The timeout in ms used by `Router.defaultScreen` in ajax requests for
   * fetching data.
   * @type {?number}
   */
		fetchTimeout: {
			validator: function validator(val) {
				return _metal.core.isNumber(val) || !_metal.core.isDefAndNotNull(val);
			},
			value: 30000
		},

		/**
   * Flag indicating if routing data (such as the current url) should be
   * included in the component's data.
   */
		includeRoutingData: {
			value: true
		},

		/**
   * Internal flag indicating if the router's path is currently active.
   * @type {boolean}
   */
		isActive_: {
			internal: true,
			value: false
		},

		/**
   * Defines the path which will trigger the route handler responsible for
   * rendering the metal component.
   * @type {!string|RegExp|Function}
   */
		path: {}
	};

	/**
  * Holds the active router.
  * @type {Router}
  * @static
  */
	Router.activeRouter = null;

	/**
  * Holds the active render state.
  * @type {*}
  * @static
  */
	Router.activeState = null;

	/**
  * ComponentScreen class.
  */

	var ComponentScreen = function (_RequestScreen) {
		_inherits(ComponentScreen, _RequestScreen);

		/**
   * @inheritDoc
   */
		function ComponentScreen(router) {
			_classCallCheck(this, ComponentScreen);

			var _this2 = _possibleConstructorReturn(this, (ComponentScreen.__proto__ || Object.getPrototypeOf(ComponentScreen)).call(this));

			if (!router) {
				throw new Error('Router not specified for component screen.');
			}

			/**
    * Router responsible for the screen.
    * @type {Router}
    */
			_this2.router = router;

			// Sets the timeout used by `RequestScreen` to be the one specified by
			// the router.
			_this2.timeout = router.fetchTimeout;
			return _this2;
		}

		/**
   * @inheritDoc
   */


		_createClass(ComponentScreen, [{
			key: 'beforeActivate',
			value: function beforeActivate() {
				var handler = this.router.beforeActivateHandler;
				if (handler) {
					if (_metal.core.isString(handler)) {
						// Passing component class because only static methods can be
						// used for beforeActivateHandler
						handler = this.resolveHandler_(handler, this.router.component);
					}
					return handler();
				}
			}
		}, {
			key: 'beforeDeactivate',
			value: function beforeDeactivate() {
				var handler = this.router.beforeDeactivateHandler;
				if (handler) {
					if (_metal.core.isString(handler)) {
						// Passing component instance because all instance methods can
						// be used for beforeDeactivateHandler
						handler = this.resolveHandler_(handler, this.router.getRouteComponent());
					}
					return handler();
				}
			}
		}, {
			key: 'beforeUpdateHistoryPath',
			value: function beforeUpdateHistoryPath(path) {
				return this.router.fetchUrl ? path : _get(ComponentScreen.prototype.__proto__ || Object.getPrototypeOf(ComponentScreen.prototype), 'beforeUpdateHistoryPath', this).call(this, path);
			}
		}, {
			key: 'evaluateScripts',
			value: function evaluateScripts() {}
		}, {
			key: 'evaluateStyles',
			value: function evaluateStyles() {}
		}, {
			key: 'flip',
			value: function flip() {
				this.maybeRedirectRouter();

				Router.activeState = this.router.addRoutingData(this.router.lastPath, this.maybeParseLastLoadedStateAsJson());

				if (Router.activeRouter) {
					Router.activeRouter.isActive_ = false;
					this.reuseActiveRouterElementInNewRouter_(this.router);
				}

				var deferred = this.waitRouterRenderSubComponents(this.router);
				Router.activeRouter = this.router;
				Router.activeRouter.isActive_ = true;
				return deferred;
			}
		}, {
			key: 'getFetchUrl_',
			value: function getFetchUrl_(path) {
				var fetchPath = this.router.fetchUrl || path;
				if (_metal.core.isFunction(fetchPath)) {
					fetchPath = fetchPath(path);
				}
				return fetchPath;
			}
		}, {
			key: 'load',
			value: function load(path) {
				var _this3 = this;

				this.setCacheable(this.router.cacheable);
				var deferred = _Promise2.default.resolve();
				var params = void 0;
				if (this.router.fetch) {
					deferred = deferred.then(function () {
						return _get(ComponentScreen.prototype.__proto__ || Object.getPrototypeOf(ComponentScreen.prototype), 'load', _this3).call(_this3, _this3.getFetchUrl_(path));
					});
				} else {
					params = this.router.extractParams(path);
					deferred = deferred.then(function () {
						return _this3.router.data(path, params);
					});
				}

				if (this.router.async) {
					deferred = deferred.then(function (loadedState) {
						return _this3.router.component().then(function (component) {
							_this3.router.asyncComponent_ = component;

							if (_this3.router.cacheable) {
								_this3.router.async = false;
							}

							return loadedState;
						});
					});
				}

				return deferred.then(function (loadedState) {
					_this3.router.lastPath = path;
					_this3.router.lastRedirectPath = _this3.maybeFindRedirectPath();
					_this3.router.lastLoadedState = loadedState;
					_this3.router.lastExtractedParams = params;
					return loadedState;
				});
			}
		}, {
			key: 'maybeFindRedirectPath',
			value: function maybeFindRedirectPath() {
				var redirectPath = this.beforeUpdateHistoryPath(this.router.lastPath);
				if (redirectPath !== this.router.lastPath) {
					return redirectPath;
				}
				return null;
			}
		}, {
			key: 'maybeFindRedirectRouter',
			value: function maybeFindRedirectRouter() {
				var redirectPath = this.maybeFindRedirectPath();
				if (redirectPath) {
					var redirectRoute = Router.router().findRoute(redirectPath);
					if (redirectRoute) {
						// The initiator component will load the render state and follow any
						// "302" redirect that may happen. Therefore, the data returned of the
						// redirect is used as "lastLoadedState" and the "lastRedirectPath" as
						// "lastPath" for redirect router.
						redirectRoute.router.lastPath = this.router.lastRedirectPath;
						redirectRoute.router.lastLoadedState = this.router.lastLoadedState; // eslint-disable-line
						return redirectRoute.router;
					}
				}
				return null;
			}
		}, {
			key: 'maybeParseLastLoadedStateAsJson',
			value: function maybeParseLastLoadedStateAsJson() {
				var state = this.router.lastLoadedState;
				try {
					return JSON.parse(state);
				} catch (err) {
					return _metal.core.isDefAndNotNull(state) ? state : {};
				}
			}
		}, {
			key: 'maybeRedirectRouter',
			value: function maybeRedirectRouter() {
				var redirectRouter = this.maybeFindRedirectRouter();
				if (redirectRouter) {
					// If performing a redirect use "redirectRouter" as "this.router". The
					// initiator "this.router" is completely ignored from now on.
					this.router = redirectRouter;

					// Schedule screen cache redirect on "endNavigate".
					var app = Router.router();
					app.once('endNavigate', function () {
						app.screens[app.redirectPath] = app.screens[app.activePath];
						delete app.screens[app.activePath];
					});
				}
			}
		}, {
			key: 'resolveHandler_',
			value: function resolveHandler_(name, comp) {
				if (comp && _metal.core.isFunction(comp[name])) {
					return comp[name];
				} else {
					var compName = (0, _metal.getFunctionName)(comp);

					throw new Error('No function named "' + name + '" exists inside ' + compName + '.');
				}
			}
		}, {
			key: 'reuseActiveRouterElementInNewRouter_',
			value: function reuseActiveRouterElementInNewRouter_(router) {
				var activeRouter = Router.activeRouter;
				if (activeRouter !== router) {
					if (activeRouter.firstRenderElement === router.firstRenderElement) {
						router.element = activeRouter.element;
						activeRouter.element = null;
					}
				}
			}
		}, {
			key: 'waitRouterRenderSubComponents',
			value: function waitRouterRenderSubComponents(router) {
				return new _Promise2.default(function (res) {
					return router.once('rendered', res);
				});
			}
		}]);

		return ComponentScreen;
	}(_senna.RequestScreen);

	/**
  * Default screen used for handling components.
  * @type {ComponentScreen}
  */
	Router.defaultScreen = ComponentScreen;

	exports.default = Router;
});
//# sourceMappingURL=Router.js.map
