/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.portlet.bridge.soy.internal;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONSerializer;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.Route;
import com.liferay.portal.kernel.portlet.Router;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCCommandCache;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SoyPortletHelper {
    private static final String _RESOURCES_PATH = "/META-INF/resources";
    private final Bundle _bundle;
    private final FriendlyURLMapper _friendlyURLMapper;
    private final Map<String, String> _javaScriptLoaderModulesMap = new HashMap<String, String>();
    private final JSONSerializer _jsonSerializer;
    private final MVCCommandCache _mvcRenderCommandCache;
    private final String _routerJavaScriptTPL;

    public SoyPortletHelper(Bundle bundle, MVCCommandCache mvcRenderCommandCache, FriendlyURLMapper friendlyURLMapper) throws Exception {
        this._bundle = bundle;
        this._mvcRenderCommandCache = mvcRenderCommandCache;
        this._friendlyURLMapper = friendlyURLMapper;
        this._jsonSerializer = JSONFactoryUtil.createJSONSerializer();
        this._routerJavaScriptTPL = this.getRouterJavaScriptTPL();
    }

    public String getJavaScriptLoaderModule(String mvcCommandName) throws Exception {
        String loaderModule = this._javaScriptLoaderModulesMap.get(mvcCommandName);
        if (loaderModule != null) {
            return loaderModule;
        }
        String controllerName = this.getJavaScriptControllerName(mvcCommandName);
        String packageName = this.getJavaScriptPackageName(mvcCommandName);
        if (packageName == null) {
            throw new Exception("Unable to get package name");
        }
        if (!controllerName.startsWith("/")) {
            packageName = packageName.concat("/");
        }
        loaderModule = packageName.concat(controllerName);
        this._javaScriptLoaderModulesMap.put(mvcCommandName, loaderModule);
        return loaderModule;
    }

    public String getRouterJavaScript(String elementId, String portletId, String portletNamespace, String portletWrapperId, Template template) throws Exception {
        Set<String> mvcRenderCommandNames = this.getMVCRenderCommandNames();
        String mvcRenderCommandNamesString = this._jsonSerializer.serialize(mvcRenderCommandNames);
        template.remove((Object)"element");
        String contextString = this._jsonSerializer.serializeDeep((Object)template);
        List<Map<String, Object>> friendlyURLRoutes = this.getFriendlyURLRoutes();
        String friendlyURLRoutesString = this._jsonSerializer.serializeDeep(friendlyURLRoutes);
        return StringUtil.replace((String)this._routerJavaScriptTPL, (String[])new String[]{"$ELEMENT_ID", "$MVC_RENDER_COMMAND_NAMES", "$PORTLET_ID", "$PORTLET_NAMESPACE", "$PORTLET_WRAPPER_ID", "$CONTEXT", "$FRIENDLY_URL_ROUTES", "$FRIENDLY_URL_MAPPING", "$FRIENDLY_URL_PREFIX"}, (String[])new String[]{elementId, mvcRenderCommandNamesString, portletId, portletNamespace, portletWrapperId, contextString, friendlyURLRoutesString, this.getFriendlyURLMapping(), String.valueOf(this.isCheckMappingWithPrefix())});
    }

    public String serializeTemplate(Template template) {
        return this._jsonSerializer.serializeDeep((Object)template);
    }

    protected String getFriendlyURLMapping() {
        if (this._friendlyURLMapper == null) {
            return "";
        }
        return this._friendlyURLMapper.getMapping();
    }

    protected List<Map<String, Object>> getFriendlyURLRoutes() {
        ArrayList<Map<String, Object>> routesMapping = new ArrayList<Map<String, Object>>();
        if (this._friendlyURLMapper != null) {
            Router router = this._friendlyURLMapper.getRouter();
            List routes = router.getRoutes();
            for (Route route : routes) {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                mapping.put("implicitParameters", route.getImplicitParameters());
                mapping.put("overriddenParameters", route.getOverriddenParameters());
                mapping.put("pattern", route.getPattern());
                routesMapping.add(mapping);
            }
        }
        return routesMapping;
    }

    protected String getJavaScriptControllerName(String mvcCommandName) throws PortletException {
        String controllerName = this._javaScriptLoaderModulesMap.get(mvcCommandName);
        if (controllerName != null) {
            return controllerName;
        }
        Bundle bundle = this.getMVCCommandBundle(mvcCommandName);
        String filePath = this.getJavaScriptFilePath(bundle, mvcCommandName);
        if (filePath.endsWith(".js")) {
            filePath = StringUtil.replace((String)filePath, (String)".js", (String)"");
        }
        controllerName = StringUtil.replace((String)filePath, (String)_RESOURCES_PATH, (String)"");
        this._javaScriptLoaderModulesMap.put(mvcCommandName, controllerName);
        return controllerName;
    }

    protected String getJavaScriptFilePath(Bundle bundle, String mvcCommandName) throws PortletException {
        String filePath;
        String resourcesPath = _RESOURCES_PATH;
        if (!mvcCommandName.startsWith("/")) {
            resourcesPath = resourcesPath.concat("/");
        }
        if (bundle.getEntry(filePath = resourcesPath.concat(mvcCommandName).concat(".js")) != null) {
            return filePath;
        }
        filePath = resourcesPath.concat(mvcCommandName).concat(".es.js");
        if (bundle.getEntry(filePath) != null) {
            return filePath;
        }
        filePath = resourcesPath.concat(mvcCommandName).concat(".soy");
        if (bundle.getEntry(filePath) != null) {
            return filePath;
        }
        throw new PortletException("Unable to get controller for " + mvcCommandName);
    }

    protected String getJavaScriptPackageName(String path) throws Exception {
        JSONObject jsonObject = this.getPackageJSONObject(path);
        if (jsonObject == null) {
            return null;
        }
        String moduleName = jsonObject.getString("name");
        if (Validator.isNull((String)moduleName)) {
            return null;
        }
        String moduleVersion = jsonObject.getString("version");
        if (Validator.isNull((String)moduleVersion)) {
            return moduleName;
        }
        return moduleName.concat("@").concat(moduleVersion);
    }

    protected Bundle getMVCCommandBundle(String mvcCommandName) throws PortletException {
        Object mvcRenderCommand = null;
        mvcRenderCommand = Validator.isNull((String)mvcCommandName) ? MVCRenderCommand.EMPTY : this._mvcRenderCommandCache.getMVCCommand(mvcCommandName);
        if (mvcRenderCommand == MVCRenderCommand.EMPTY) {
            return this._bundle;
        }
        return FrameworkUtil.getBundle(mvcRenderCommand.getClass());
    }

    protected Set<String> getMVCRenderCommandNames() {
        MVCCommandCache mvcRenderCommandCache = this._mvcRenderCommandCache;
        return mvcRenderCommandCache.getMVCCommandNames();
    }

    protected JSONObject getPackageJSONObject(String path) throws Exception {
        Bundle bundle = this.getMVCCommandBundle(path);
        URL url = bundle.getEntry("package.json");
        if (url == null) {
            return null;
        }
        String json = StringUtil.read((InputStream)url.openStream());
        return JSONFactoryUtil.createJSONObject((String)json);
    }

    protected String getRouterJavaScriptTPL() throws Exception {
        Class<?> clazz = this.getClass();
        InputStream inputStream = clazz.getResourceAsStream("dependencies/router.js.tpl");
        return StringUtil.read((InputStream)inputStream);
    }

    protected boolean isCheckMappingWithPrefix() {
        if (this._friendlyURLMapper == null) {
            return false;
        }
        return this._friendlyURLMapper.isCheckMappingWithPrefix();
    }
}

