/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.reference.support.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.osgi.web.wab.generator.WabGenerator;
import com.liferay.portal.osgi.web.wab.reference.support.internal.WabDirHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Component(immediate=true, property={"url.handler.protocol=webbundledir"}, service={URLStreamHandlerService.class})
public class WabDirURLStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final Log _log = LogFactoryUtil.getLog(WabDirURLStreamHandlerService.class);
    private static final Pattern _pattern = Pattern.compile(".*\\/(.*-(T|t)heme)\\/?.*");
    private ClassLoader _classLoader;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private Http _http;
    @Reference
    private WabGenerator _wabGenerator;

    public URLConnection openConnection(URL url) {
        try {
            File generatedJarFile;
            String contextName;
            URI uri = new URI(url.getPath());
            File warDir = new File(uri);
            String bundleSymbolicName = this._http.getParameter(url.toExternalForm(), "Bundle-SymbolicName");
            if (bundleSymbolicName.equals("")) {
                bundleSymbolicName = this._getNameFromDirectory(warDir);
            }
            if (bundleSymbolicName.equals("")) {
                bundleSymbolicName = this._getNameFromXMLFile(warDir);
            }
            if (bundleSymbolicName.equals("")) {
                bundleSymbolicName = this._getNameFromProperties(warDir);
            }
            if ((contextName = this._http.getParameter(url.toExternalForm(), "Web-ContextPath")).equals("")) {
                contextName = this._getNameFromDirectory(warDir);
            }
            if (contextName.equals("")) {
                contextName = this._getNameFromXMLFile(warDir);
            }
            if (contextName.equals("")) {
                contextName = this._getNameFromProperties(warDir);
            }
            if (contextName.equals("")) {
                throw new IllegalArgumentException("Unable to determine context name from " + url);
            }
            if (!contextName.startsWith("/")) {
                contextName = "/".concat(contextName);
            }
            if ((generatedJarFile = this._wabGenerator.generate(this._classLoader, warDir, (Map)HashMapBuilder.put((Object)"Bundle-SymbolicName", (Object)new String[]{bundleSymbolicName}).put((Object)"Web-ContextPath", (Object)new String[]{contextName}).build())) != null) {
                this._file.unzip(generatedJarFile, warDir);
            }
            uri = warDir.toURI();
            WabDirHandler wabDirHandler = new WabDirHandler(uri.toASCIIString());
            return wabDirHandler.openConnection(url);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to open connection", (Throwable)exception);
            return null;
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Bundle bundle = bundleContext.getBundle(0L);
        Class<?> clazz = bundle.getClass();
        this._classLoader = clazz.getClassLoader();
    }

    private String _getNameFromDirectory(File warDir) {
        Matcher matcher = _pattern.matcher(warDir.getAbsolutePath());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    private String _getNameFromProperties(File warDir) throws IOException {
        File liferayPluginPackagePropertiesFile = new File(warDir, "WEB-INF/liferay-plugin-package.properties");
        if (!liferayPluginPackagePropertiesFile.exists()) {
            return "";
        }
        try (FileInputStream fileInputStream = new FileInputStream(liferayPluginPackagePropertiesFile);){
            Properties properties = new Properties();
            properties.load(fileInputStream);
            String string = properties.getProperty("name");
            return string;
        }
    }

    private String _getNameFromXMLFile(File warDir) throws IOException {
        File lookAndFeelXmlFile = new File(warDir, "WEB-INF/liferay-look-and-feel.xml");
        if (!lookAndFeelXmlFile.exists()) {
            return "";
        }
        Document document = this._readDocument(lookAndFeelXmlFile);
        Element rootElement = document.getRootElement();
        XPath xPath = SAXReaderUtil.createXPath((String)"//theme/@id", null, null);
        List nodes = xPath.selectNodes((Object)rootElement);
        String themeId = null;
        if (nodes != null && !nodes.isEmpty()) {
            Node themeNode = (Node)nodes.get(0);
            themeId = themeNode.getText();
        }
        if (themeId != null) {
            return themeId + "-theme";
        }
        return "";
    }

    private Document _readDocument(File file) throws IOException {
        String content = FileUtil.read((File)file);
        try {
            return UnsecureSAXReaderUtil.read((String)content);
        }
        catch (DocumentException documentException) {
            throw new IOException(documentException);
        }
    }
}

