/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal.registration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;

public class FilterRegistrationImpl
implements FilterRegistration.Dynamic {
    private boolean _asyncSupported;
    private String _className = "";
    private final FilterMapping _filterMapping = new FilterMapping();
    private Map<String, String> _initParameters = new HashMap<String, String>();
    private Filter _instance;
    private String _name = "";

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean matchAfter, String ... servletNames) {
        this._filterMapping.setDispatcher(dispatcherTypes);
        int i = 0;
        for (String servletName : servletNames) {
            if (matchAfter) {
                this._filterMapping.addServletName(servletName);
                continue;
            }
            this._filterMapping.addServletName(i, servletName);
            ++i;
        }
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean matchAfter, String ... urlPatterns) {
        this._filterMapping.setDispatcher(dispatcherTypes);
        int i = 0;
        for (String servletName : urlPatterns) {
            if (matchAfter) {
                this._filterMapping.addURLPattern(servletName);
                continue;
            }
            this._filterMapping.addURLPattern(i, servletName);
            ++i;
        }
    }

    public String getClassName() {
        return this._className;
    }

    public FilterMapping getFilterMapping() {
        return this._filterMapping;
    }

    public String getInitParameter(String name) {
        return this._initParameters.get(name);
    }

    public Map<String, String> getInitParameters() {
        return this._initParameters;
    }

    public Filter getInstance() {
        return this._instance;
    }

    public String getName() {
        return this._name;
    }

    public Collection<String> getServletNameMappings() {
        return this._filterMapping.getServletNames();
    }

    public Collection<String> getUrlPatternMappings() {
        return this._filterMapping.getURLPatterns();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this._asyncSupported = asyncSupported;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public boolean setInitParameter(String name, String value) {
        boolean exists = this._initParameters.containsKey(name);
        this._initParameters.put(name, value);
        return exists;
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        this._initParameters = initParameters;
        return new HashSet<String>();
    }

    public void setInstance(Filter instance) {
        this._instance = instance;
    }

    public void setName(String name) {
        this._name = name;
    }

    private static class FilterMappingItem {
        private String _itemContent = "";
        private boolean _urlPattern;

        private FilterMappingItem() {
        }

        public String getItemContent() {
            return this._itemContent;
        }

        public boolean isUrlPattern() {
            return this._urlPattern;
        }

        public void setItemContent(String itemContent) {
            this._itemContent = itemContent;
        }

        public void setUrlPattern(boolean urlPattern) {
            this._urlPattern = urlPattern;
        }
    }

    public class FilterMapping {
        private EnumSet<DispatcherType> _dispatchers = EnumSet.noneOf(DispatcherType.class);
        private final List<FilterMappingItem> _filterMappingItems = new ArrayList<FilterMappingItem>();

        public void addServletName(int index, String servletName) {
            FilterMappingItem filterMappingItem = new FilterMappingItem();
            filterMappingItem.setItemContent(servletName);
            this._filterMappingItems.add(index, filterMappingItem);
        }

        public void addServletName(String servletName) {
            this.addServletName(this._filterMappingItems.size(), servletName);
        }

        public void addURLPattern(int index, String urlPattern) {
            FilterMappingItem filterMappingItem = new FilterMappingItem();
            filterMappingItem.setUrlPattern(true);
            filterMappingItem.setItemContent(urlPattern);
            this._filterMappingItems.add(index, filterMappingItem);
        }

        public void addURLPattern(String urlPattern) {
            this.addURLPattern(this._filterMappingItems.size(), urlPattern);
        }

        public EnumSet<DispatcherType> getDispatchers() {
            return this._dispatchers;
        }

        public List<String> getServletNames() {
            return Collections.unmodifiableList(this._getFilterMappingItems(false));
        }

        public List<String> getURLPatterns() {
            return Collections.unmodifiableList(this._getFilterMappingItems(true));
        }

        public void setDispatcher(EnumSet<DispatcherType> dispatcher) {
            this._dispatchers = dispatcher;
        }

        private List<String> _getFilterMappingItems(boolean urlPattern) {
            ArrayList<String> filterMappingItems = new ArrayList<String>();
            for (FilterMappingItem filterMappingItem : this._filterMappingItems) {
                if (urlPattern != filterMappingItem.isUrlPattern()) continue;
                filterMappingItems.add(filterMappingItem.getItemContent());
            }
            return filterMappingItems;
        }
    }
}

