/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal.event;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.osgi.web.wab.extender.internal.WabUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EventUtil
implements ServiceTrackerCustomizer<EventAdmin, EventAdmin> {
    public static final String DEPLOYED = "org/osgi/service/web/DEPLOYED";
    public static final String DEPLOYING = "org/osgi/service/web/DEPLOYING";
    public static final String FAILED = "org/osgi/service/web/FAILED";
    public static final String UNDEPLOYED = "org/osgi/service/web/UNDEPLOYED";
    public static final String UNDEPLOYING = "org/osgi/service/web/UNDEPLOYING";
    private static final boolean[] _VALID_CHARS;
    private static final Log _log;
    private final BundleContext _bundleContext;
    private final boolean _enabled;
    private EventAdmin _eventAdmin;
    private final ServiceTracker<EventAdmin, EventAdmin> _eventAdminServiceTracker;
    private final Bundle _webExtenderBundle;

    public EventUtil(BundleContext bundleContext) {
        this._enabled = GetterUtil.getBoolean((String)bundleContext.getProperty("wab.event.enabled"));
        if (this._enabled) {
            this._bundleContext = bundleContext;
            this._webExtenderBundle = this._bundleContext.getBundle();
            this._eventAdminServiceTracker = ServiceTrackerFactory.open((BundleContext)this._bundleContext, EventAdmin.class, (ServiceTrackerCustomizer)this);
        } else {
            this._bundleContext = null;
            this._eventAdminServiceTracker = null;
            this._webExtenderBundle = null;
        }
    }

    public EventAdmin addingService(ServiceReference<EventAdmin> serviceReference) {
        this._eventAdmin = (EventAdmin)this._bundleContext.getService(serviceReference);
        return this._eventAdmin;
    }

    public void close() {
        if (!this._enabled) {
            return;
        }
        this._eventAdminServiceTracker.close();
    }

    public void modifiedService(ServiceReference<EventAdmin> serviceReference, EventAdmin eventAdmin) {
    }

    public void removedService(ServiceReference<EventAdmin> serviceReference, EventAdmin eventAdmin) {
        this._bundleContext.ungetService(serviceReference);
        this._eventAdmin = null;
    }

    public void sendEvent(Bundle bundle, String eventTopic, Exception exception, boolean collision) {
        if (!this._enabled) {
            return;
        }
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("bundle", bundle);
        properties.put("bundle.id", bundle.getBundleId());
        properties.put("bundle.symbolicName", bundle.getSymbolicName());
        properties.put("bundle.version", bundle.getVersion());
        String contextPath = GetterUtil.getString((String)WabUtil.getWebContextPath(bundle));
        if (collision) {
            ArrayList<Long> collidedBundleIds = new ArrayList<Long>();
            ArrayList<String> collidedBundleNames = new ArrayList<String>();
            BundleContext bundleContext = bundle.getBundleContext();
            for (Bundle curBundle : bundleContext.getBundles()) {
                String curContextPath;
                if (curBundle.equals(bundle) || curBundle.getState() != 32 || (curContextPath = WabUtil.getWebContextPath(curBundle)) == null || !curContextPath.equals(contextPath)) continue;
                collidedBundleIds.add(curBundle.getBundleId());
                collidedBundleNames.add(curBundle.getSymbolicName());
            }
            if (!collidedBundleIds.isEmpty()) {
                properties.put("collision", contextPath);
                properties.put("collision.bundles", collidedBundleIds);
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(10);
                    sb.append("Newly added bundle: \"");
                    sb.append(bundle.getSymbolicName());
                    sb.append("\" has the same Web-ContextPath as the ");
                    sb.append("following bundles: ");
                    sb.append(collidedBundleNames);
                    sb.append(". This can lead to unexpected behavior when ");
                    sb.append("multiple bundles provide the same context ");
                    sb.append("path. See https://osgi.org/specification/osgi.");
                    sb.append("cmpn/7.0.0/service.http.whiteboard.html");
                    sb.append("#service.http.whiteboard.servletcontext");
                    _log.warn((Object)sb.toString());
                }
            }
        }
        properties.put("context.path", contextPath);
        if (exception != null) {
            properties.put("exception", exception);
        }
        properties.put("extender.bundle", this._webExtenderBundle);
        properties.put("extender.bundle.id", this._webExtenderBundle.getBundleId());
        properties.put("extender.bundle.symbolicName", this._webExtenderBundle.getSymbolicName());
        properties.put("extender.bundle.version", this._webExtenderBundle.getVersion());
        String symbolicName = bundle.getSymbolicName();
        properties.put("servlet.context.name", EventUtil._sanitizeSymbolicName(symbolicName));
        properties.put("timestamp", System.currentTimeMillis());
        if (this._eventAdmin == null) {
            return;
        }
        Event event = new Event(eventTopic, (Dictionary)properties);
        this._eventAdmin.sendEvent(event);
    }

    private static String _sanitizeSymbolicName(String symbolicName) {
        StringBuilder sb = new StringBuilder(symbolicName.length());
        for (int i = 0; i < symbolicName.length(); ++i) {
            char c = symbolicName.charAt(i);
            if (c >= '\u0080' || !_VALID_CHARS[c]) continue;
            sb.append(c);
        }
        if (sb.length() == symbolicName.length()) {
            return symbolicName;
        }
        return sb.toString();
    }

    static {
        int i;
        _VALID_CHARS = new boolean[128];
        _log = LogFactoryUtil.getLog(EventUtil.class);
        for (i = 48; i <= 57; ++i) {
            EventUtil._VALID_CHARS[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            EventUtil._VALID_CHARS[i] = true;
        }
        for (i = 97; i <= 122; ++i) {
            EventUtil._VALID_CHARS[i] = true;
        }
    }
}

