/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal.adapter;

import com.liferay.portal.kernel.util.ServerDetector;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ServletContextListenerExceptionAdapter
implements ServletContextListener {
    private Exception _exception;
    private final ServletContext _servletContext;
    private final ServletContextListener _servletContextListener;

    public ServletContextListenerExceptionAdapter(ServletContextListener servletContextListener, ServletContext servletContext) {
        this._servletContextListener = servletContextListener;
        this._servletContext = servletContext;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (ServerDetector.isJBoss() || ServerDetector.isWildfly()) {
            ServletContext servletContext = servletContextEvent.getServletContext();
            Thread thread = new Thread("Context destroyed thread for ".concat(servletContext.getServletContextName())){

                @Override
                public void run() {
                    ServletContextListenerExceptionAdapter.this._destroyContext();
                }
            };
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {}
        } else {
            this._destroyContext();
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (ServerDetector.isJBoss() || ServerDetector.isWildfly()) {
            ServletContext servletContext = servletContextEvent.getServletContext();
            Thread thread = new Thread("Context initialized thread for ".concat(servletContext.getServletContextName())){

                @Override
                public void run() {
                    ServletContextListenerExceptionAdapter.this._initializeContext();
                }
            };
            thread.setDaemon(true);
            thread.start();
            try {
                thread.join();
            }
            catch (Exception exception) {}
        } else {
            this._initializeContext();
        }
    }

    public Exception getException() {
        return this._exception;
    }

    private void _destroyContext() {
        try {
            this._servletContextListener.contextDestroyed(new ServletContextEvent(this._servletContext));
        }
        catch (Exception e) {
            this._exception = e;
        }
    }

    private void _initializeContext() {
        try {
            this._servletContextListener.contextInitialized(new ServletContextEvent(this._servletContext));
        }
        catch (Exception e) {
            this._exception = e;
        }
    }
}

