/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal.adapter;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.FilterDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ListenerDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ServletDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.JspServletWrapper;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.ModifiableServletContext;
import com.liferay.portal.osgi.web.wab.extender.internal.registration.FilterRegistrationImpl;
import com.liferay.portal.osgi.web.wab.extender.internal.registration.ServletRegistrationImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Registration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ModifiableServletContextAdapter
implements InvocationHandler,
ModifiableServletContext {
    private static final Class<?>[] _INTERFACES = new Class[]{ModifiableServletContext.class, ServletContext.class};
    private static final Log _log = LogFactoryUtil.getLog(ModifiableServletContextAdapter.class);
    private static final Map<Method, Method> _contextAdapterMethods = ModifiableServletContextAdapter._createContextAdapterMethods();
    private final Bundle _bundle;
    private final BundleContext _bundleContext;
    private final Map<Class<? extends EventListener>, EventListener> _eventListeners = new LinkedHashMap<Class<? extends EventListener>, EventListener>();
    private final Map<String, FilterRegistrationImpl> _filterRegistrationImpls = new LinkedHashMap<String, FilterRegistrationImpl>();
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private final JSPServletFactory _jspServletFactory;
    private final ServletContext _servletContext;
    private final Map<String, ServletRegistrationImpl> _servletRegistrationImpls = new LinkedHashMap<String, ServletRegistrationImpl>();
    private final WebXMLDefinition _webXMLDefinition;

    public static ServletContext createInstance(BundleContext bundleContext, ServletContext servletContext, JSPServletFactory jspServletFactory, WebXMLDefinition webXMLDefinition) {
        return (ServletContext)Proxy.newProxyInstance(ModifiableServletContextAdapter.class.getClassLoader(), _INTERFACES, (InvocationHandler)new ModifiableServletContextAdapter(servletContext, bundleContext, jspServletFactory, webXMLDefinition));
    }

    public static ServletContext createInstance(BundleContext bundleContext, ServletContext servletContext, JSPServletFactory jspServletFactory, WebXMLDefinition webXMLDefinition, List<ListenerDefinition> listenerDefinitions, Map<String, FilterRegistrationImpl> filterRegistrationImpls, Map<String, ServletRegistrationImpl> servletRegistrationImpls, Map<String, Object> attributes) {
        ServletContext newServletContext = ModifiableServletContextAdapter.createInstance(bundleContext, servletContext, jspServletFactory, webXMLDefinition);
        Set<String> attributeNames = attributes.keySet();
        if (attributeNames != null) {
            for (String attributeName : attributeNames) {
                newServletContext.setAttribute(attributeName, attributes.get(attributeName));
            }
        }
        if (listenerDefinitions != null) {
            for (ListenerDefinition listenerDefinition : listenerDefinitions) {
                newServletContext.addListener(listenerDefinition.getEventListener());
            }
        }
        ModifiableServletContext modifiableServletContext = (ModifiableServletContext)newServletContext;
        if (filterRegistrationImpls != null) {
            Map<String, FilterRegistrationImpl> newFilterRegistrationImpls = modifiableServletContext.getFilterRegistrationImpls();
            for (Map.Entry<String, Object> entry : filterRegistrationImpls.entrySet()) {
                newFilterRegistrationImpls.put(entry.getKey(), (FilterRegistrationImpl)entry.getValue());
            }
        }
        if (servletRegistrationImpls != null) {
            Map<String, ServletRegistrationImpl> newServletRegistrationImpls = modifiableServletContext.getServletRegistrationImpls();
            for (Map.Entry<String, Object> entry : servletRegistrationImpls.entrySet()) {
                newServletRegistrationImpls.put(entry.getKey(), (ServletRegistrationImpl)entry.getValue());
            }
        }
        return newServletContext;
    }

    public ModifiableServletContextAdapter(ServletContext servletContext, BundleContext bundleContext, JSPServletFactory jspServletFactory, WebXMLDefinition webXMLDefinition) {
        this._servletContext = servletContext;
        this._bundleContext = bundleContext;
        this._jspServletFactory = jspServletFactory;
        this._webXMLDefinition = webXMLDefinition;
        this._bundle = this._bundleContext.getBundle();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.addFilter(filterName, filterClass.getName());
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        FilterRegistrationImpl filterRegistrationImpl = this.getFilterRegistrationImpl(filterName);
        if (filterRegistrationImpl == null) {
            filterRegistrationImpl = new FilterRegistrationImpl();
        }
        Class<?> filterClass = filter.getClass();
        filterRegistrationImpl.setClassName(filterClass.getName());
        filterRegistrationImpl.setName(filterName);
        filterRegistrationImpl.setInstance(filter);
        this._filterRegistrationImpls.put(filterName, filterRegistrationImpl);
        return filterRegistrationImpl;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        FilterRegistrationImpl filterRegistrationImpl = this.getFilterRegistrationImpl(filterName);
        if (filterRegistrationImpl == null) {
            filterRegistrationImpl = new FilterRegistrationImpl();
        }
        filterRegistrationImpl.setClassName(className);
        filterRegistrationImpl.setName(filterName);
        this._filterRegistrationImpls.put(filterName, filterRegistrationImpl);
        return filterRegistrationImpl;
    }

    public void addListener(Class<? extends EventListener> eventListenerClass) {
        this._eventListeners.put(eventListenerClass, null);
    }

    public void addListener(String className) {
        try {
            Class clazz = this._bundle.loadClass(className);
            if (!EventListener.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException();
            }
            Class<EventListener> eventListenerClass = clazz.asSubclass(EventListener.class);
            this._eventListeners.put(eventListenerClass, null);
        }
        catch (Exception e) {
            _log.error((Object)("Bundle " + this._bundle + " is unable to load filter " + className));
            throw new IllegalArgumentException(e);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        this._eventListeners.put(t.getClass(), t);
    }

    public Registration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.addServlet(servletName, servletClass.getName());
    }

    public Registration.Dynamic addServlet(String servletName, Servlet servlet) {
        ServletRegistrationImpl servletRegistrationImpl = this.getServletRegistrationImpl(servletName);
        if (servletRegistrationImpl == null) {
            servletRegistrationImpl = new ServletRegistrationImpl();
        }
        Class<?> servetClass = servlet.getClass();
        servletRegistrationImpl.setClassName(servetClass.getName());
        servletRegistrationImpl.setName(servletName);
        servletRegistrationImpl.setInstance(servlet);
        this._servletRegistrationImpls.put(servletName, servletRegistrationImpl);
        return servletRegistrationImpl;
    }

    public Registration.Dynamic addServlet(String servletName, String className) {
        ServletRegistrationImpl servletRegistrationImpl = this.getServletRegistrationImpl(servletName);
        if (servletRegistrationImpl == null) {
            servletRegistrationImpl = new ServletRegistrationImpl();
        }
        servletRegistrationImpl.setClassName(className);
        servletRegistrationImpl.setName(servletName);
        this._servletRegistrationImpls.put(servletName, servletRegistrationImpl);
        return servletRegistrationImpl;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)clazz.newInstance());
        }
        catch (Throwable t) {
            _log.error((Object)("Bundle " + this._bundle + " is unable to load filter " + clazz));
            throw new ServletException(t);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)clazz.newInstance());
        }
        catch (Throwable t) {
            _log.error((Object)("Bundle " + this._bundle + " is unable to load listener " + clazz));
            throw new ServletException(t);
        }
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.newInstance());
        }
        catch (Throwable t) {
            _log.error((Object)("Bundle " + this._bundle + " is unable to load servlet " + clazz));
            throw new ServletException(t);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServletContext)) {
            return true;
        }
        ServletContext servletContext = (ServletContext)obj;
        if (obj instanceof ModifiableServletContext) {
            ModifiableServletContext modifiableServletContext = (ModifiableServletContext)obj;
            servletContext = modifiableServletContext.getWrappedServletContext();
        }
        return this._servletContext.equals(servletContext);
    }

    @Override
    public Bundle getBundle() {
        return this._bundle;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.getFilterRegistrationImpl(filterName);
    }

    public FilterRegistrationImpl getFilterRegistrationImpl(String filterName) {
        return this._filterRegistrationImpls.get(filterName);
    }

    @Override
    public Map<String, FilterRegistrationImpl> getFilterRegistrationImpls() {
        return this._filterRegistrationImpls;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.getFilterRegistrationImpls();
    }

    public String getInitParameter(String name) {
        String value = this._servletContext.getInitParameter(name);
        if (value == null) {
            return this._initParameters.get(name);
        }
        return value;
    }

    public Enumeration<String> getInitParameterNames() {
        ArrayList<Object> names = new ArrayList<Object>();
        names.addAll(Collections.list(this._servletContext.getInitParameterNames()));
        names.addAll(this._initParameters.keySet());
        return Collections.enumeration(names);
    }

    @Override
    public List<ListenerDefinition> getListenerDefinitions() {
        ArrayList<ListenerDefinition> listenerDefinitions = new ArrayList<ListenerDefinition>();
        for (Map.Entry<Class<? extends EventListener>, EventListener> entry : this._eventListeners.entrySet()) {
            Class<? extends EventListener> eventListenerClass = entry.getKey();
            try {
                EventListener eventListener = entry.getValue();
                if (eventListener == null) {
                    eventListener = eventListenerClass.newInstance();
                }
                ListenerDefinition listenerDefinition = new ListenerDefinition();
                listenerDefinition.setEventListener(eventListener);
                listenerDefinitions.add(listenerDefinition);
            }
            catch (Exception e) {
                _log.error((Object)("Bundle " + this._bundle + " is unable to load listener " + eventListenerClass));
            }
        }
        return listenerDefinitions;
    }

    public Map<Class<? extends EventListener>, EventListener> getListenersImpl() {
        return this._eventListeners;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.getServletRegistrationImpl(servletName);
    }

    public ServletRegistrationImpl getServletRegistrationImpl(String servletName) {
        return this._servletRegistrationImpls.get(servletName);
    }

    @Override
    public Map<String, ServletRegistrationImpl> getServletRegistrationImpls() {
        return this._servletRegistrationImpls;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.getServletRegistrationImpls();
    }

    @Override
    public Map<String, String> getUnregisteredInitParameters() {
        return this._initParameters;
    }

    @Override
    public ServletContext getWrappedServletContext() {
        return this._servletContext;
    }

    public int hashCode() {
        return this._servletContext.hashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method adapterMethod = _contextAdapterMethods.get(method);
        if (adapterMethod != null) {
            return adapterMethod.invoke((Object)this, args);
        }
        return method.invoke((Object)this._servletContext, args);
    }

    @Override
    public void registerFilters() {
        Map filterDefinitions = this._webXMLDefinition.getFilterDefinitions();
        for (FilterRegistrationImpl filterRegistrationImpl : this._filterRegistrationImpls.values()) {
            String filterClassName = filterRegistrationImpl.getClassName();
            try {
                Filter filter = filterRegistrationImpl.getInstance();
                if (filter == null) {
                    Class clazz = this._bundle.loadClass(filterClassName);
                    Class<Filter> filterClass = clazz.asSubclass(Filter.class);
                    filter = filterClass.newInstance();
                    filterRegistrationImpl.setInstance(filter);
                }
                FilterDefinition filterDefinition = new FilterDefinition();
                filterDefinition.setAsyncSupported(filterRegistrationImpl.isAsyncSupported());
                FilterRegistrationImpl.FilterMapping filterMapping = filterRegistrationImpl.getFilterMapping();
                for (DispatcherType dispatcherType : filterMapping.getDispatchers()) {
                    filterDefinition.addDispatcher(dispatcherType.toString());
                }
                filterDefinition.setFilter(filter);
                filterDefinition.setInitParameters(filterRegistrationImpl.getInitParameters());
                filterDefinition.setName(filterRegistrationImpl.getName());
                filterDefinition.setServletNames(new ArrayList<String>(filterRegistrationImpl.getServletNameMappings()));
                filterDefinition.setURLPatterns(new ArrayList<String>(filterRegistrationImpl.getUrlPatternMappings()));
                filterDefinitions.put(filterRegistrationImpl.getName(), filterDefinition);
            }
            catch (Exception e) {
                _log.error((Object)("Bundle " + this._bundle + " is unable to load filter " + filterClassName));
            }
        }
        for (FilterDefinition filterDefinition : filterDefinitions.values()) {
            Filter filter = filterDefinition.getFilter();
            if (this._filterRegistrationImpls.containsValue(filter)) continue;
            this.addFilter(filterDefinition.getName(), filter);
        }
    }

    @Override
    public void registerServlets() {
        Map servletDefinitions = this._webXMLDefinition.getServletDefinitions();
        for (ServletRegistrationImpl servletRegistrationImpl : this._servletRegistrationImpls.values()) {
            String servletClassName = servletRegistrationImpl.getClassName();
            try {
                Object servlet = servletRegistrationImpl.getInstance();
                if (servlet == null) {
                    String jspFile = servletRegistrationImpl.getJspFile();
                    if (Validator.isNotNull((String)jspFile)) {
                        servlet = new JspServletWrapper(this._jspServletFactory.createJSPServlet(), jspFile);
                    } else {
                        Class clazz = this._bundle.loadClass(servletClassName);
                        Class<Servlet> servletClass = clazz.asSubclass(Servlet.class);
                        servlet = servletClass.newInstance();
                    }
                    servletRegistrationImpl.setInstance((Servlet)servlet);
                }
                ServletDefinition servletDefinition = new ServletDefinition();
                servletDefinition.setAsyncSupported(servletRegistrationImpl.isAsyncSupported());
                servletDefinition.setInitParameters(servletRegistrationImpl.getInitParameters());
                servletDefinition.setJSPFile(servletRegistrationImpl.getJspFile());
                servletDefinition.setName(servletRegistrationImpl.getName());
                servletDefinition.setServlet(servlet);
                servletDefinition.setURLPatterns(new ArrayList<String>(servletRegistrationImpl.getMappings()));
                servletDefinitions.put(servletRegistrationImpl.getName(), servletDefinition);
            }
            catch (Exception e) {
                _log.error((Object)("Bundle " + this._bundle + " is unable to load servlet " + servletClassName));
            }
        }
        for (ServletDefinition servletDefinition : servletDefinitions.values()) {
            Servlet servlet = servletDefinition.getServlet();
            if (this._servletRegistrationImpls.containsValue(servlet)) continue;
            this.addServlet(servletDefinition.getName(), servlet);
        }
    }

    public boolean setInitParameter(String name, String value) throws IllegalStateException, UnsupportedOperationException {
        boolean exists = this._initParameters.containsKey(name);
        if (!exists && this._servletContext.getInitParameter(name) != null) {
            exists = true;
        }
        if (!exists) {
            this._initParameters.put(name, value);
        }
        return !exists;
    }

    private static Map<Method, Method> _createContextAdapterMethods() {
        Method[] adapterMethods;
        HashMap<Method, Method> methods = new HashMap<Method, Method>();
        for (Method adapterMethod : adapterMethods = ModifiableServletContextAdapter.class.getDeclaredMethods()) {
            String name = adapterMethod.getName();
            Class<?>[] parameterTypes = adapterMethod.getParameterTypes();
            try {
                Method method = ServletContext.class.getMethod(name, parameterTypes);
                methods.put(method, adapterMethod);
            }
            catch (NoSuchMethodException nsme1) {
                try {
                    Method method = ModifiableServletContext.class.getMethod(name, parameterTypes);
                    methods.put(method, adapterMethod);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        try {
            Method equalsMethod = Object.class.getMethod("equals", Object.class);
            Method equalsHandlerMethod = ModifiableServletContextAdapter.class.getMethod("equals", Object.class);
            methods.put(equalsMethod, equalsHandlerMethod);
            Method hashCodeMethod = Object.class.getMethod("hashCode", null);
            Method hashCodeHandlerMethod = ModifiableServletContextAdapter.class.getMethod("hashCode", null);
            methods.put(hashCodeMethod, hashCodeHandlerMethod);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return Collections.unmodifiableMap(methods);
    }
}

