/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal.adapter;

import com.liferay.portal.kernel.servlet.PortletSessionListenerManager;
import com.liferay.portal.kernel.util.HashMapDictionary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.eclipse.equinox.http.servlet.HttpSessionTrackerUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class HttpAdapter {
    private static final Class<?>[] _INTERFACES = new Class[]{ServletContext.class};
    private static final HttpSessionListener _INVALIDATEHTTPSESSION_LISTENER = new HttpSessionListener(){

        public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        }

        public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
            HttpSession httpSession = httpSessionEvent.getSession();
            HttpSessionTrackerUtil.invalidate((String)httpSession.getId());
        }
    };
    private HttpServiceServlet _httpServiceServlet;
    private ServiceRegistration<?> _serviceRegistration;
    private ServletContext _servletContext;

    @Activate
    protected void activate(ComponentContext componentContext) {
        this._httpServiceServlet = new HttpServiceServlet(){
            private ServletConfig _servletConfig;

            public ServletConfig getServletConfig() {
                return this._servletConfig;
            }

            public void init(ServletConfig servletConfig) {
                this._servletConfig = servletConfig;
            }
        };
        ServletConfig servletConfig = new ServletConfig(){

            public String getInitParameter(String name) {
                if (name.equals("osgi.http.endpoint")) {
                    return HttpAdapter.this._servletContext.getContextPath() + HttpAdapter.this._servletContext.getInitParameter(name);
                }
                return HttpAdapter.this._servletContext.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return HttpAdapter.this._servletContext.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return HttpAdapter.this._servletContext;
            }

            public String getServletName() {
                return "Module Framework Servlet";
            }
        };
        try {
            this._httpServiceServlet.init(servletConfig);
        }
        catch (ServletException se) {
            this._servletContext.log(se.getMessage(), (Throwable)se);
            return;
        }
        BundleContext bundleContext = componentContext.getBundleContext();
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("bean.id", HttpServlet.class.getName());
        properties.put("original.bean", Boolean.TRUE.toString());
        this._serviceRegistration = bundleContext.registerService(new String[]{HttpServiceServlet.class.getName(), HttpServlet.class.getName()}, (Object)this._httpServiceServlet, (Dictionary)properties);
        PortletSessionListenerManager.addHttpSessionListener((HttpSessionListener)_INVALIDATEHTTPSESSION_LISTENER);
    }

    @Deactivate
    protected void deactivate() {
        PortletSessionListenerManager.removeHttpSessionListener((HttpSessionListener)_INVALIDATEHTTPSESSION_LISTENER);
        this._serviceRegistration.unregister();
        this._serviceRegistration = null;
        this._httpServiceServlet.destroy();
        this._httpServiceServlet = null;
    }

    @Reference(target="(original.bean=true)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        Class<?> clazz = this.getClass();
        this._servletContext = (ServletContext)Proxy.newProxyInstance(clazz.getClassLoader(), _INTERFACES, (InvocationHandler)new ServletContextAdaptor(servletContext));
    }

    private static class ServletContextAdaptor
    implements InvocationHandler {
        private final ServletContext _servletContext;

        public ServletContextAdaptor(ServletContext servletContext) {
            this._servletContext = servletContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getInitParameter") && args != null && args.length == 1) {
                if (Objects.equals(args[0], "osgi.http.endpoint")) {
                    return this._servletContext.getInitParameter((String)args[0]);
                }
                return null;
            }
            if (methodName.equals("getInitParameterNames") && args == null) {
                return Collections.enumeration(Collections.singleton("osgi.http.endpoint"));
            }
            if (methodName.equals("getJspConfigDescriptor") && JspConfigDescriptor.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            try {
                return method.invoke((Object)this._servletContext, args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

