/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.JSPTaglibHelper;
import com.liferay.portal.osgi.web.wab.extender.internal.WabBundleProcessor;
import com.liferay.portal.osgi.web.wab.extender.internal.WabUtil;
import com.liferay.portal.osgi.web.wab.extender.internal.event.EventUtil;
import com.liferay.portal.profile.PortalProfile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRevision;

public class WebBundleDeployer {
    private final BundleContext _bundleContext;
    private final EventUtil _eventUtil;
    private final JSPServletFactory _jspServletFactory;
    private final JSPTaglibHelper _jspTaglibHelper;
    private final Dictionary<String, Object> _properties;
    private final ConcurrentMap<Bundle, WabBundleProcessor> _wabBundleProcessors = new ConcurrentHashMap<Bundle, WabBundleProcessor>();

    public WebBundleDeployer(BundleContext bundleContext, JSPServletFactory jspServletFactory, JSPTaglibHelper jspTaglibHelper, Dictionary<String, Object> properties, EventUtil eventUtil) {
        this._bundleContext = bundleContext;
        this._jspServletFactory = jspServletFactory;
        this._jspTaglibHelper = jspTaglibHelper;
        this._properties = properties;
        this._eventUtil = eventUtil;
    }

    public void close() {
        for (Bundle bundle : this._wabBundleProcessors.keySet()) {
            this.doStop(bundle);
        }
    }

    public ServiceRegistration<PortalProfile> doStart(Bundle bundle) {
        this._eventUtil.sendEvent(bundle, "org/osgi/service/web/DEPLOYING", null, true);
        BundleContext bundleContext = bundle.getBundleContext();
        if (bundleContext == null) {
            this._eventUtil.sendEvent(bundle, "org/osgi/service/web/FAILED", null, false);
            return null;
        }
        Enumeration enumeration = bundle.findEntries("/WEB-INF", "liferay-plugin-package.properties", false);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            this._initWabBundle(bundle);
            return null;
        }
        URL url = (URL)enumeration.nextElement();
        Properties properties = new Properties();
        try (InputStream inputStream = url.openStream();){
            properties.load(inputStream);
        }
        catch (IOException ioe) {
            this._eventUtil.sendEvent(bundle, "org/osgi/service/web/FAILED", ioe, false);
        }
        Set portalProfileNames = SetUtil.fromArray((Object[])StringUtil.split((String)properties.getProperty("liferay-portal-profile-names")));
        if (portalProfileNames.isEmpty()) {
            this._initWabBundle(bundle);
            return null;
        }
        portalProfileNames.add(bundle.getSymbolicName());
        return this._bundleContext.registerService(PortalProfile.class, (Object)new WarModuleProfile(bundle, portalProfileNames), null);
    }

    public void doStop(Bundle bundle) {
        WabBundleProcessor wabBundleProcessor = (WabBundleProcessor)this._wabBundleProcessors.remove(bundle);
        if (wabBundleProcessor == null) {
            return;
        }
        this._eventUtil.sendEvent(bundle, "org/osgi/service/web/UNDEPLOYING", null, false);
        try {
            wabBundleProcessor.destroy();
            this._eventUtil.sendEvent(bundle, "org/osgi/service/web/UNDEPLOYED", null, false);
            this.handleCollidedWABs(bundle);
        }
        catch (Exception e) {
            this._eventUtil.sendEvent(bundle, "org/osgi/service/web/FAILED", e, false);
        }
    }

    public boolean isFragmentBundle(Bundle bundle) {
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        return (bundleRevision.getTypes() & 1) != 0;
    }

    protected void handleCollidedWABs(Bundle bundle) {
        String contextPath = WabUtil.getWebContextPath(bundle);
        for (Bundle curBundle : this._bundleContext.getBundles()) {
            String curContextPath;
            if (bundle.equals(curBundle) || this.isFragmentBundle(curBundle) || this._wabBundleProcessors.containsKey(curBundle) || !contextPath.equals(curContextPath = WabUtil.getWebContextPath(curBundle))) continue;
            this.doStart(curBundle);
            break;
        }
    }

    private void _initWabBundle(Bundle bundle) {
        try {
            WabBundleProcessor newWabBundleProcessor = new WabBundleProcessor(bundle, this._jspServletFactory, this._jspTaglibHelper);
            WabBundleProcessor oldWabBundleProcessor = this._wabBundleProcessors.putIfAbsent(bundle, newWabBundleProcessor);
            if (oldWabBundleProcessor != null) {
                this._eventUtil.sendEvent(bundle, "org/osgi/service/web/FAILED", null, false);
                return;
            }
            newWabBundleProcessor.init(this._properties);
        }
        catch (Exception e) {
            this._eventUtil.sendEvent(bundle, "org/osgi/service/web/FAILED", e, false);
        }
    }

    private class WarModuleProfile
    implements PortalProfile {
        private final Bundle _bundle;
        private final Set<String> _portalProfileNames;

        public void activate() {
            WebBundleDeployer.this._initWabBundle(this._bundle);
        }

        public Set<String> getPortalProfileNames() {
            return this._portalProfileNames;
        }

        private WarModuleProfile(Bundle bundle, Set<String> portalProfileNames) {
            this._bundle = bundle;
            this._portalProfileNames = portalProfileNames;
        }
    }
}

