/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.JSPTaglibHelper;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperFactory;
import com.liferay.portal.osgi.web.wab.extender.internal.WabUtil;
import com.liferay.portal.osgi.web.wab.extender.internal.WebBundleDeployer;
import com.liferay.portal.osgi.web.wab.extender.internal.configuration.WabExtenderConfiguration;
import com.liferay.portal.osgi.web.wab.extender.internal.event.EventUtil;
import com.liferay.portal.profile.PortalProfile;
import java.util.Dictionary;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(configurationPid={"com.liferay.portal.osgi.web.wab.extender.internal.configuration.WabExtenderConfiguration"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, service={})
public class WabFactory
implements BundleTrackerCustomizer<WABExtension> {
    private static final Log _log = LogFactoryUtil.getLog(WabFactory.class);
    private BundleTracker<?> _bundleTracker;
    private EventUtil _eventUtil;
    @Reference
    private JSPServletFactory _jspServletFactory;
    @Reference
    private JSPTaglibHelper _jspTaglibHelper;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private ServletContextHelperFactory _servletContextHelperFactory;
    private WabExtenderConfiguration _wabExtenderConfiguration;
    private WebBundleDeployer _webBundleDeployer;

    public WABExtension addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        String contextPath = WabUtil.getWebContextPath(bundle);
        if (contextPath == null) {
            return null;
        }
        WABExtension wabExtension = new WABExtension(bundle);
        wabExtension.start();
        return wabExtension;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, WABExtension wabExtension) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, WABExtension wabExtension) {
        wabExtension.destroy();
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        BundleContext bundleContext = componentContext.getBundleContext();
        this._eventUtil = new EventUtil(bundleContext);
        Dictionary properties = componentContext.getProperties();
        this._wabExtenderConfiguration = (WabExtenderConfiguration)ConfigurableUtil.createConfigurable(WabExtenderConfiguration.class, (Dictionary)properties);
        this._webBundleDeployer = new WebBundleDeployer(bundleContext, this._jspServletFactory, this._jspTaglibHelper, properties, this._eventUtil);
        this._bundleTracker = new BundleTracker(bundleContext, 40, (BundleTrackerCustomizer)this);
        this._bundleTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._bundleTracker.close();
        this._eventUtil.close();
        this._eventUtil = null;
        this._webBundleDeployer.close();
        this._webBundleDeployer = null;
    }

    public class WABExtension {
        private final Bundle _bundle;
        private ServiceRegistration<PortalProfile> _serviceRegistration;
        private final CountDownLatch _started = new CountDownLatch(1);

        public WABExtension(Bundle bundle) {
            this._bundle = bundle;
        }

        public void destroy() {
            try {
                this._started.await(WabFactory.this._wabExtenderConfiguration.stopTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                _log.error((Object)String.format("The wait for bundle {0}/{1} to start before destroying was interrupted", this._bundle.getSymbolicName(), this._bundle.getBundleId()), (Throwable)ie);
            }
            if (this._serviceRegistration != null) {
                this._serviceRegistration.unregister();
            }
            WabFactory.this._webBundleDeployer.doStop(this._bundle);
        }

        public void start() {
            try {
                this._serviceRegistration = WabFactory.this._webBundleDeployer.doStart(this._bundle);
            }
            finally {
                this._started.countDown();
            }
        }
    }
}

