/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.JSPTaglibHelper;
import com.liferay.portal.osgi.web.servlet.context.helper.ServletContextHelperRegistration;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.FilterDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ListenerDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ServletDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.wab.extender.internal.PortletContextLoaderListener;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.AsyncAttributeAdapterServlet;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.FilterExceptionAdapter;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.ModifiableServletContext;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.ModifiableServletContextAdapter;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.ServletContextListenerExceptionAdapter;
import com.liferay.portal.osgi.web.wab.extender.internal.adapter.ServletExceptionAdapter;
import com.liferay.portal.osgi.web.wab.extender.internal.registration.FilterRegistrationImpl;
import com.liferay.portal.osgi.web.wab.extender.internal.registration.ListenerServiceRegistrationComparator;
import com.liferay.portal.osgi.web.wab.extender.internal.registration.ServletRegistrationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

public class WabBundleProcessor {
    private static final HandlesTypes _NULL_HANDLES_TYPES = new HandlesTypes(){

        public Class<? extends Annotation> annotationType() {
            return null;
        }

        public Class<?>[] value() {
            return new Class[0];
        }
    };
    private static final String _VENDOR = "Liferay, Inc.";
    private static final Log _log = LogFactoryUtil.getLog(WabBundleProcessor.class);
    private final Bundle _bundle;
    private final ClassLoader _bundleClassLoader;
    private final BundleContext _bundleContext;
    private String _contextName;
    private final Set<ServiceRegistration<Filter>> _filterServiceRegistrations = new ConcurrentSkipListSet<ServiceRegistration<Filter>>();
    private final JSPServletFactory _jspServletFactory;
    private final JSPTaglibHelper _jspTaglibHelper;
    private final Set<ServiceRegistration<?>> _listenerServiceRegistrations = new ConcurrentSkipListSet(new ListenerServiceRegistrationComparator());
    private ServiceReference<ServletContextHelperRegistration> _servletContextHelperRegistrationServiceReference;
    private final Set<ServiceRegistration<Servlet>> _servletServiceRegistrations = new ConcurrentSkipListSet<ServiceRegistration<Servlet>>();

    public WabBundleProcessor(Bundle bundle, JSPServletFactory jspServletFactory, JSPTaglibHelper jspTaglibHelper) {
        this._bundle = bundle;
        this._jspServletFactory = jspServletFactory;
        this._jspTaglibHelper = jspTaglibHelper;
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        this._bundleClassLoader = bundleWiring.getClassLoader();
        this._bundleContext = this._bundle.getBundleContext();
    }

    public void destroy() throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this._bundleClassLoader);
            this.destroyServlets();
            this.destroyFilters();
            this.destroyListeners();
            this._bundleContext.ungetService(this._servletContextHelperRegistrationServiceReference);
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public void init(Dictionary<String, Object> properties) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(this._bundleClassLoader);
            ServletContextHelperRegistration servletContextHelperRegistration = this.initContext();
            boolean wabShapedBundle = servletContextHelperRegistration.isWabShapedBundle();
            if (!wabShapedBundle) {
                return;
            }
            WebXMLDefinition webXMLDefinition = servletContextHelperRegistration.getWebXMLDefinition();
            Exception exception = webXMLDefinition.getException();
            if (exception != null) {
                throw exception;
            }
            ServletContext servletContext = ModifiableServletContextAdapter.createInstance(this._bundle.getBundleContext(), servletContextHelperRegistration.getServletContext(), this._jspServletFactory, webXMLDefinition);
            this.initServletContainerInitializers(this._bundle, servletContext);
            ModifiableServletContext modifiableServletContext = (ModifiableServletContext)servletContext;
            Map<String, String> unregisteredInitParameters = modifiableServletContext.getUnregisteredInitParameters();
            if (unregisteredInitParameters != null && !unregisteredInitParameters.isEmpty()) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                Enumeration attributeNames = servletContext.getAttributeNames();
                while (attributeNames.hasMoreElements()) {
                    String attributeName = (String)attributeNames.nextElement();
                    attributes.put(attributeName, servletContext.getAttribute(attributeName));
                }
                List<ListenerDefinition> listenerDefinitions = modifiableServletContext.getListenerDefinitions();
                Map<String, FilterRegistrationImpl> filterRegistrationImpls = modifiableServletContext.getFilterRegistrationImpls();
                Map<String, ServletRegistrationImpl> servletRegistrationImpls = modifiableServletContext.getServletRegistrationImpls();
                servletContextHelperRegistration.setProperties(unregisteredInitParameters);
                ServletContext newServletContext = servletContextHelperRegistration.getServletContext();
                servletContext = ModifiableServletContextAdapter.createInstance(this._bundle.getBundleContext(), newServletContext, this._jspServletFactory, webXMLDefinition, listenerDefinitions, filterRegistrationImpls, servletRegistrationImpls, attributes);
                modifiableServletContext = (ModifiableServletContext)servletContext;
            }
            this.scanTLDsForListeners(webXMLDefinition, servletContext);
            LinkedHashSet<ListenerDefinition> listenerDefinitions = new LinkedHashSet<ListenerDefinition>();
            listenerDefinitions.addAll(modifiableServletContext.getListenerDefinitions());
            listenerDefinitions.addAll(webXMLDefinition.getListenerDefinitions());
            this.initListeners(listenerDefinitions, servletContext);
            modifiableServletContext.registerFilters();
            this.initFilters(webXMLDefinition.getFilterDefinitions());
            modifiableServletContext.registerServlets();
            this.initServlets(webXMLDefinition.getServletDefinitions(), modifiableServletContext);
        }
        catch (Exception e) {
            _log.error((Object)("Catastrophic initialization failure! Shutting down " + this._contextName + " WAB due to: " + e.getMessage()), (Throwable)e);
            this.destroy();
            throw e;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    protected void collectAnnotatedClasses(String classResource, Bundle bundle, Class<?>[] handledTypesArray, Set<Class<?>> annotatedClasses) {
        Field[] declaredFields;
        Class annotatedClass;
        block22: {
            Method[] classMethods;
            block20: {
                Annotation[] classAnnotations;
                block19: {
                    String className = classResource.replaceAll("\\.class$", "");
                    className = className.replaceAll("/", ".");
                    annotatedClass = null;
                    try {
                        annotatedClass = bundle.loadClass(className);
                    }
                    catch (Throwable t) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)t.getMessage());
                        }
                        return;
                    }
                    for (Class<?> handledType : handledTypesArray) {
                        if (!handledType.isAssignableFrom(annotatedClass) || Modifier.isAbstract(annotatedClass.getModifiers())) continue;
                        annotatedClasses.add(annotatedClass);
                        return;
                    }
                    classAnnotations = new Annotation[]{};
                    try {
                        classAnnotations = annotatedClass.getAnnotations();
                    }
                    catch (Throwable t) {
                        if (!_log.isDebugEnabled()) break block19;
                        _log.debug((Object)t.getMessage());
                    }
                }
                for (Annotation classAnnotation : classAnnotations) {
                    if (!ArrayUtil.contains((Object[])handledTypesArray, classAnnotation.annotationType())) continue;
                    annotatedClasses.add(annotatedClass);
                    return;
                }
                classMethods = new Method[]{};
                try {
                    classMethods = annotatedClass.getDeclaredMethods();
                }
                catch (Throwable t) {
                    if (!_log.isDebugEnabled()) break block20;
                    _log.debug((Object)t.getMessage());
                }
            }
            for (Method method : classMethods) {
                Annotation[] methodAnnotations;
                block21: {
                    methodAnnotations = new Annotation[]{};
                    try {
                        methodAnnotations = method.getDeclaredAnnotations();
                    }
                    catch (Throwable t) {
                        if (!_log.isDebugEnabled()) break block21;
                        _log.debug((Object)t.getMessage());
                    }
                }
                for (Annotation methodAnnotation : methodAnnotations) {
                    if (!ArrayUtil.contains((Object[])handledTypesArray, methodAnnotation.annotationType())) continue;
                    annotatedClasses.add(annotatedClass);
                    return;
                }
            }
            declaredFields = new Field[]{};
            try {
                declaredFields = annotatedClass.getDeclaredFields();
            }
            catch (Throwable t) {
                if (!_log.isDebugEnabled()) break block22;
                _log.debug((Object)t.getMessage());
            }
        }
        for (Field field : declaredFields) {
            Annotation[] fieldAnnotations;
            block23: {
                fieldAnnotations = new Annotation[]{};
                try {
                    fieldAnnotations = field.getDeclaredAnnotations();
                }
                catch (Throwable t) {
                    if (!_log.isDebugEnabled()) break block23;
                    _log.debug((Object)t.getMessage());
                }
            }
            for (Annotation fieldAnnotation : fieldAnnotations) {
                if (!ArrayUtil.contains((Object[])handledTypesArray, fieldAnnotation.annotationType())) continue;
                annotatedClasses.add(annotatedClass);
                return;
            }
        }
    }

    protected void destroyFilters() {
        for (ServiceRegistration<Filter> serviceRegistration : this._filterServiceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._filterServiceRegistrations.clear();
    }

    protected void destroyListeners() {
        for (ServiceRegistration<?> serviceRegistration : this._listenerServiceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._listenerServiceRegistrations.clear();
    }

    protected void destroyServlets() {
        for (ServiceRegistration<Servlet> serviceRegistration : this._servletServiceRegistrations) {
            try {
                serviceRegistration.unregister();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        this._servletServiceRegistrations.clear();
    }

    protected String[] getClassNames(EventListener eventListener) {
        ArrayList<String> classNamesList = new ArrayList<String>();
        if (HttpSessionAttributeListener.class.isInstance(eventListener)) {
            classNamesList.add(HttpSessionAttributeListener.class.getName());
        }
        if (HttpSessionListener.class.isInstance(eventListener)) {
            classNamesList.add(HttpSessionListener.class.getName());
        }
        if (ServletContextAttributeListener.class.isInstance(eventListener)) {
            classNamesList.add(ServletContextAttributeListener.class.getName());
        }
        if (ServletRequestAttributeListener.class.isInstance(eventListener)) {
            classNamesList.add(ServletRequestAttributeListener.class.getName());
        }
        if (ServletRequestListener.class.isInstance(eventListener)) {
            classNamesList.add(ServletRequestListener.class.getName());
        }
        return classNamesList.toArray(new String[0]);
    }

    protected ServletContextHelperRegistration initContext() {
        this._servletContextHelperRegistrationServiceReference = this._bundleContext.getServiceReference(ServletContextHelperRegistration.class);
        ServletContextHelperRegistration servletContextHelperRegistration = (ServletContextHelperRegistration)this._bundleContext.getService(this._servletContextHelperRegistrationServiceReference);
        WebXMLDefinition webXMLDefinition = servletContextHelperRegistration.getWebXMLDefinition();
        ServletContext servletContext = servletContextHelperRegistration.getServletContext();
        this._contextName = servletContext.getServletContextName();
        servletContext.setAttribute("jsp.taglib.mappings", (Object)webXMLDefinition.getJspTaglibMappings());
        servletContext.setAttribute("osgi-bundlecontext", (Object)this._bundleContext);
        servletContext.setAttribute("osgi-runtime-vendor", (Object)_VENDOR);
        return servletContextHelperRegistration;
    }

    protected void initFilters(Map<String, FilterDefinition> filterDefinitions) throws Exception {
        for (Map.Entry<String, FilterDefinition> entry : filterDefinitions.entrySet()) {
            FilterDefinition filterDefinition = entry.getValue();
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("osgi.http.whiteboard.context.select", this._contextName);
            properties.put("osgi.http.whiteboard.filter.asyncSupported", filterDefinition.isAsyncSupported());
            properties.put("osgi.http.whiteboard.filter.dispatcher", filterDefinition.getDispatchers());
            properties.put("osgi.http.whiteboard.filter.name", filterDefinition.getName());
            properties.put("osgi.http.whiteboard.filter.pattern", filterDefinition.getURLPatterns());
            properties.put("osgi.http.whiteboard.filter.servlet", filterDefinition.getServletNames());
            properties.put("service.ranking", filterDefinition.getPriority());
            Map initParameters = filterDefinition.getInitParameters();
            for (Map.Entry initParametersEntry : initParameters.entrySet()) {
                String key = (String)initParametersEntry.getKey();
                String value = (String)initParametersEntry.getValue();
                properties.put("filter.init." + key, value);
            }
            FilterExceptionAdapter filterExceptionAdaptor = new FilterExceptionAdapter(filterDefinition.getFilter());
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(Filter.class, (Object)filterExceptionAdaptor, (Dictionary)properties);
            Exception exception = filterExceptionAdaptor.getException();
            if (exception != null) {
                serviceRegistration.unregister();
                throw exception;
            }
            this._filterServiceRegistrations.add((ServiceRegistration<Filter>)serviceRegistration);
        }
    }

    protected void initListeners(Collection<ListenerDefinition> listenerDefinitions, ServletContext servletContext) throws Exception {
        boolean registeredPortletContextLoaderListener = false;
        for (ListenerDefinition listenerDefinition : listenerDefinitions) {
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("osgi.http.whiteboard.context.select", this._contextName);
            properties.put("osgi.http.whiteboard.listener", Boolean.TRUE.toString());
            String[] classNames = this.getClassNames(listenerDefinition.getEventListener());
            if (classNames.length > 0) {
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(classNames, (Object)listenerDefinition.getEventListener(), (Dictionary)properties);
                this._listenerServiceRegistrations.add(serviceRegistration);
            }
            if (!ServletContextListener.class.isInstance(listenerDefinition.getEventListener())) continue;
            if (!registeredPortletContextLoaderListener) {
                PortletContextLoaderListener portletContextLoaderListener = new PortletContextLoaderListener(this._bundleContext);
                ServletContextListenerExceptionAdapter servletContextListenerExceptionAdaptor = new ServletContextListenerExceptionAdapter((ServletContextListener)portletContextLoaderListener, servletContext);
                ServiceRegistration serviceRegistration = this._bundleContext.registerService(ServletContextListener.class, (Object)servletContextListenerExceptionAdaptor, (Dictionary)properties);
                Exception exception = servletContextListenerExceptionAdaptor.getException();
                List<ServiceRegistration<?>> contextServiceRegistrations = portletContextLoaderListener.getServiceRegistrations();
                if (exception != null) {
                    for (ServiceRegistration<?> contextServiceRegistration : contextServiceRegistrations) {
                        contextServiceRegistration.unregister();
                    }
                    serviceRegistration.unregister();
                    throw exception;
                }
                this._listenerServiceRegistrations.add(serviceRegistration);
                this._listenerServiceRegistrations.addAll(contextServiceRegistrations);
                registeredPortletContextLoaderListener = true;
            }
            ServletContextListenerExceptionAdapter servletContextListenerExceptionAdaptor = new ServletContextListenerExceptionAdapter((ServletContextListener)listenerDefinition.getEventListener(), servletContext);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(ServletContextListener.class, (Object)servletContextListenerExceptionAdaptor, (Dictionary)properties);
            Exception exception = servletContextListenerExceptionAdaptor.getException();
            if (exception != null) {
                serviceRegistration.unregister();
                throw exception;
            }
            this._listenerServiceRegistrations.add(serviceRegistration);
        }
    }

    protected void initServletContainerInitializers(Bundle bundle, ServletContext servletContext) throws IOException {
        Enumeration initializerResources = bundle.getResources("META-INF/services/javax.servlet.ServletContainerInitializer");
        if (initializerResources == null) {
            return;
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        while (initializerResources.hasMoreElements()) {
            URL url = (URL)initializerResources.nextElement();
            try {
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    ArrayList fqcns = new ArrayList();
                    StringUtil.readLines((InputStream)inputStream, fqcns);
                    for (String fqcn : fqcns) {
                        int index = fqcn.indexOf("#");
                        if (index == 0) continue;
                        if (index > 0) {
                            fqcn = fqcn.substring(0, index);
                        }
                        if (!Validator.isNotNull((String)(fqcn = fqcn.trim()))) continue;
                        this.processServletContainerInitializerClass(fqcn, bundle, bundleWiring, servletContext);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
        }
    }

    protected void initServlets(Map<String, ServletDefinition> servletDefinitions, ModifiableServletContext modifiableServletContext) throws Exception {
        for (Map.Entry<String, ServletDefinition> entry : servletDefinitions.entrySet()) {
            ServletDefinition servletDefinition = entry.getValue();
            HashMapDictionary properties = new HashMapDictionary();
            properties.put("osgi.http.whiteboard.context.select", this._contextName);
            properties.put("osgi.http.whiteboard.servlet.asyncSupported", servletDefinition.isAsyncSupported());
            properties.put("osgi.http.whiteboard.servlet.errorPage", servletDefinition.getErrorPages());
            properties.put("osgi.http.whiteboard.servlet.name", servletDefinition.getName());
            String jspFile = servletDefinition.getJspFile();
            List urlPatterns = servletDefinition.getURLPatterns();
            if (urlPatterns.isEmpty() && jspFile != null) {
                urlPatterns.add(jspFile);
            }
            properties.put("osgi.http.whiteboard.servlet.pattern", urlPatterns);
            Map initParameters = servletDefinition.getInitParameters();
            for (Map.Entry initParametersEntry : initParameters.entrySet()) {
                String key = (String)initParametersEntry.getKey();
                String value = (String)initParametersEntry.getValue();
                properties.put("servlet.init." + key, value);
            }
            ServletExceptionAdapter servletExceptionAdaptor = new ServletExceptionAdapter(new AsyncAttributeAdapterServlet(servletDefinition.getServlet()), modifiableServletContext);
            ServiceRegistration serviceRegistration = this._bundleContext.registerService(Servlet.class, (Object)servletExceptionAdaptor, (Dictionary)properties);
            Exception exception = servletExceptionAdaptor.getException();
            if (exception != null) {
                serviceRegistration.unregister();
                throw exception;
            }
            this._servletServiceRegistrations.add((ServiceRegistration<Servlet>)serviceRegistration);
        }
    }

    protected void processServletContainerInitializerClass(String fqcn, Bundle bundle, BundleWiring bundleWiring, ServletContext servletContext) {
        ArrayList classResources;
        Class[] handledTypesArray;
        Class<ServletContainerInitializer> initializerClass = null;
        try {
            Class clazz = bundle.loadClass(fqcn);
            if (!ServletContainerInitializer.class.isAssignableFrom(clazz)) {
                return;
            }
            initializerClass = clazz.asSubclass(ServletContainerInitializer.class);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return;
        }
        HandlesTypes handledTypes = initializerClass.getAnnotation(HandlesTypes.class);
        if (handledTypes == null) {
            handledTypes = _NULL_HANDLES_TYPES;
        }
        if ((handledTypesArray = handledTypes.value()) == null) {
            handledTypesArray = new Class[]{};
        }
        if ((classResources = bundleWiring.listResources("/", "*.class", 1)) == null) {
            classResources = new ArrayList(0);
        }
        HashSet annotatedClasses = new HashSet();
        for (String classResource : classResources) {
            URL urlClassResource = bundle.getResource(classResource);
            if (urlClassResource == null) continue;
            this.collectAnnotatedClasses(classResource, bundle, handledTypesArray, annotatedClasses);
        }
        if (annotatedClasses.isEmpty()) {
            annotatedClasses = null;
        }
        try {
            ServletContainerInitializer servletContainerInitializer = initializerClass.newInstance();
            servletContainerInitializer.onStartup(annotatedClasses, servletContext);
        }
        catch (Throwable t) {
            _log.error((Object)t, t);
        }
    }

    protected void scanTLDsForListeners(WebXMLDefinition webXMLDefinition, ServletContext servletContext) {
        ArrayList listenerClassNames = new ArrayList();
        this._jspTaglibHelper.scanTLDs(this._bundle, servletContext, listenerClassNames);
        for (String listenerClassName : listenerClassNames) {
            try {
                Class clazz = this._bundle.loadClass(listenerClassName);
                Class<EventListener> eventListenerClass = clazz.asSubclass(EventListener.class);
                EventListener eventListener = eventListenerClass.newInstance();
                ListenerDefinition listenerDefinition = new ListenerDefinition();
                listenerDefinition.setEventListener(eventListener);
                webXMLDefinition.addListenerDefinition(listenerDefinition);
            }
            catch (Exception e) {
                _log.error((Object)("Bundle " + this._bundle + " is unable to load listener " + listenerClassName));
            }
        }
    }
}

