/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal;

import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.osgi.web.wab.extender.internal.PortletApplicationContext;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class PortletContextLoaderListener
extends ContextLoaderListener {
    private static final String _PORTAL_CONFIG_LOCATION_PARAM = "portalContextConfigLocation";
    private static final Log _log = LogFactoryUtil.getLog(PortletContextLoaderListener.class);
    private final BundleContext _bundleContext;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();

    public PortletContextLoaderListener(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        block3: {
            ServletContext servletContext = servletContextEvent.getServletContext();
            ClassLoader classLoader = ServletContextClassLoaderPool.getClassLoader((String)servletContext.getServletContextName());
            if (classLoader == null) {
                throw new IllegalStateException("Unable to find the class loader for servlet context " + servletContext.getServletContextName());
            }
            try {
                Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
                Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
                setBeanLocatorMethod.invoke(beanLocatorUtilClass, new Object[]{null});
                PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), null);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e, (Throwable)e);
            }
        }
        super.contextDestroyed(servletContextEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        MethodKey.resetCache();
        ServletContext servletContext = servletContextEvent.getServletContext();
        Object previousApplicationContext = servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        ClassLoader classLoader = ServletContextClassLoaderPool.getClassLoader((String)servletContext.getServletContextName());
        if (classLoader == null) {
            throw new IllegalStateException("Unable to find the class loader for servlet context " + servletContext.getServletContextName());
        }
        PortletClassLoaderUtil.setServletContextName((String)servletContext.getServletContextName());
        try {
            super.contextInitialized(servletContextEvent);
        }
        finally {
            PortletClassLoaderUtil.setServletContextName(null);
        }
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        this._registerApplicationContext((ConfigurableApplicationContext)applicationContext);
        BeanLocatorImpl beanLocatorImpl = new BeanLocatorImpl(classLoader, (ApplicationContext)applicationContext);
        try {
            Class<?> beanLocatorUtilClass = Class.forName("com.liferay.util.bean.PortletBeanLocatorUtil", true, classLoader);
            Method setBeanLocatorMethod = beanLocatorUtilClass.getMethod("setBeanLocator", BeanLocator.class);
            setBeanLocatorMethod.invoke(beanLocatorUtilClass, beanLocatorImpl);
            PortletBeanLocatorUtil.setBeanLocator((String)servletContext.getServletContextName(), (BeanLocator)beanLocatorImpl);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (previousApplicationContext == null) {
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        } else {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, previousApplicationContext);
        }
    }

    public List<ServiceRegistration<?>> getServiceRegistrations() {
        return this._serviceRegistrations;
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) {
        return new PortletApplicationContext();
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        String configLocation = servletContext.getInitParameter(_PORTAL_CONFIG_LOCATION_PARAM);
        configurableWebApplicationContext.setConfigLocation(configLocation);
        configurableWebApplicationContext.addBeanFactoryPostProcessor(configurableListableBeanFactory -> {
            if (configurableListableBeanFactory.getBeanDefinitionCount() > 0 && !configurableListableBeanFactory.containsBean("liferayDataSource")) {
                configurableListableBeanFactory.registerSingleton("liferayDataSource", (Object)InfrastructureUtil.getDataSource());
            }
        });
        ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator = (ConfigurableApplicationContextConfigurator)PortalBeanLocatorUtil.locate((String)"configurableApplicationContextConfigurator");
        configurableApplicationContextConfigurator.configure((ConfigurableApplicationContext)configurableWebApplicationContext);
    }

    private void _registerApplicationContext(ConfigurableApplicationContext configurableApplicationContext) {
        ConfigurableListableBeanFactory configurableListableBeanFactory = configurableApplicationContext.getBeanFactory();
        Iterator iterator = configurableListableBeanFactory.getBeanNamesIterator();
        iterator.forEachRemaining(beanName -> {
            try {
                Object bean = configurableApplicationContext.getBean(beanName);
                ServiceRegistration<?> serviceRegistration = this._registerService(this._bundleContext, (String)beanName, bean);
                if (serviceRegistration != null) {
                    this._serviceRegistrations.add(serviceRegistration);
                }
            }
            catch (BeanIsAbstractException bean) {
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        });
    }

    private ServiceRegistration<?> _registerService(BundleContext bundleContext, String beanName, Object bean) {
        Class<?> clazz = bean.getClass();
        OSGiBeanProperties osgiBeanProperties = clazz.getAnnotation(OSGiBeanProperties.class);
        Set names = OSGiBeanProperties.Service.interfaceNames((Object)bean, (OSGiBeanProperties)osgiBeanProperties, (String[])PropsValues.MODULE_FRAMEWORK_SERVICES_IGNORED_INTERFACES);
        if (names.isEmpty()) {
            return null;
        }
        HashMapDictionary properties = new HashMapDictionary();
        if (osgiBeanProperties != null) {
            properties.putAll(OSGiBeanProperties.Convert.toMap((OSGiBeanProperties)osgiBeanProperties));
        }
        properties.put((Object)"bean.id", (Object)beanName);
        return bundleContext.registerService(names.toArray(new String[0]), bean, (Dictionary)properties);
    }
}

