/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.extender.internal;

import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletClassLoaderUtil;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.spring.util.FilterClassLoader;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class PortletApplicationContext
extends XmlWebApplicationContext {
    private static final Log _log = LogFactoryUtil.getLog(PortletApplicationContext.class);

    public PortletApplicationContext() {
        ClassLoader beanClassLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader[])new ClassLoader[]{PortletClassLoaderUtil.getClassLoader(), PortalClassLoaderUtil.getClassLoader()});
        this.setClassLoader((ClassLoader)new FilterClassLoader(beanClassLoader));
    }

    protected String[] getDefaultConfigLocations() {
        return new String[0];
    }

    protected String[] getPortletConfigLocations() {
        Object[] configLocations = this.getConfigLocations();
        ClassLoader classLoader = PortletClassLoaderUtil.getClassLoader();
        URL url = classLoader.getResource("service.properties");
        if (url == null) {
            return configLocations;
        }
        Configuration serviceBuilderPropertiesConfiguration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"service");
        List serviceBuilderPropertiesConfigLocations = ListUtil.fromArray((Object[])serviceBuilderPropertiesConfiguration.getArray("spring.configs"));
        serviceBuilderPropertiesConfigLocations.remove("WEB-INF/classes/META-INF/base-spring.xml");
        serviceBuilderPropertiesConfigLocations.remove("WEB-INF/classes/META-INF/cluster-spring.xml");
        serviceBuilderPropertiesConfigLocations.remove("WEB-INF/classes/META-INF/hibernate-spring.xml");
        serviceBuilderPropertiesConfigLocations.remove("WEB-INF/classes/META-INF/infrastructure-spring.xml");
        return (String[])ArrayUtil.append((Object[])configLocations, (Object[])serviceBuilderPropertiesConfigLocations.toArray(new String[0]));
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        xmlBeanDefinitionReader.setBeanClassLoader(this.getClassLoader());
    }

    protected void injectExplicitBean(Class<?> clazz, BeanDefinitionRegistry beanDefinitionRegistry) {
        beanDefinitionRegistry.registerBeanDefinition(clazz.getName(), (BeanDefinition)new RootBeanDefinition(clazz));
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader xmlBeanDefinitionReader) {
        for (String configLocation : this.getPortletConfigLocations()) {
            try {
                xmlBeanDefinitionReader.loadBeanDefinitions(configLocation);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause instanceof FileNotFoundException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)cause.getMessage());
                    continue;
                }
                _log.error((Object)cause, cause);
            }
        }
    }
}

