/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class JspBundleClassloader
extends URLClassLoader {
    private static final Log _log = LogFactoryUtil.getLog(JspBundleClassloader.class);
    private final Bundle[] _bundles;

    public JspBundleClassloader(Bundle ... bundles) {
        super(new URL[0], PortalException.class.getClassLoader());
        if (bundles.length == 0) {
            throw new IllegalArgumentException("At least one bundle is required");
        }
        this._bundles = bundles;
    }

    @Override
    public URL findResource(String name) {
        for (Bundle bundle : this._bundles) {
            URL url = bundle.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> findResources(String name) {
        for (Bundle bundle : this._bundles) {
            try {
                Enumeration enumeration = bundle.getResources(name);
                if (enumeration == null || !enumeration.hasMoreElements()) continue;
                return enumeration;
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)ioException);
            }
        }
        return Collections.enumeration(Collections.emptyList());
    }

    public Bundle[] getBundles() {
        return this._bundles;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.findResources(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = null;
        for (Bundle bundle : this._bundles) {
            try {
                clazz = bundle.loadClass(name);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)classNotFoundException);
            }
        }
        if (clazz == null) {
            return super.loadClass(name, resolve);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

