/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.jsp.compiler.internal;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.osgi.web.servlet.JSPTaglibHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={JSPTaglibHelper.class})
public class JSPTaglibHelperImpl
implements JSPTaglibHelper {
    private static final String _ANALYZED_TLDS = JSPTaglibHelperImpl.class.getName() + "#ANALYZED_TLDS";

    public void scanTLDs(Bundle bundle, ServletContext servletContext, List<String> listenerClassNames) {
        Boolean analyzedTlds = (Boolean)servletContext.getAttribute(_ANALYZED_TLDS);
        if (analyzedTlds != null && analyzedTlds.booleanValue()) {
            return;
        }
        servletContext.setAttribute(_ANALYZED_TLDS, (Object)Boolean.TRUE);
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Collection resources = bundleWiring.listResources("META-INF/", "*.tld", 1);
        if (resources == null) {
            return;
        }
        for (String resource : resources) {
            URL url = bundle.getResource(resource);
            if (url == null) continue;
            try {
                InputStream inputStream = url.openStream();
                Throwable throwable = null;
                try {
                    Document document = SAXReaderUtil.read((InputStream)inputStream);
                    Element rootElement = document.getRootElement();
                    for (Element listenerElement : rootElement.elements("listener")) {
                        String listenerClassName = listenerElement.elementText("listener-class");
                        if (Validator.isNull((String)listenerClassName)) continue;
                        listenerClassNames.add(listenerClassName);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                servletContext.log(exception.getMessage(), (Throwable)exception);
            }
        }
    }
}

